/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateInteractionHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.ProxyBidibLinkData;
import org.bidib.jbidibc.netbidib.server.AbstractNetBidibServerHandler;
import org.bidib.jbidibc.netbidib.server.NetBidibChannelInboundHandler;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.bidib.jbidibc.netbidib.server.ServerNetMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetBidibNettyServer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibNettyServer.class);
    public static final String BIND_ADDRESS_ALL_INTERFACES = "0.0.0.0";
    public static final int DEFAULT_PORTNUM = 62875;
    public static final String DEFAULT_HOSTNAME = "localhost";
    private int portNumber = 62875;
    private String hostName;
    private String connectionName;
    private EventLoopGroup group;
    private EventLoopGroup workerGroup;
    private final EventExecutorGroup eventExecutorGroup = new DefaultEventExecutorGroup(3);
    private ChannelFuture channelFuture;
    private final Object shutdownLock = new Object();
    private Thread shutdownHook;
    private NetBidibLinkData serverLinkData;
    private ScheduledExecutorService serverWorkers;
    private final RoleTypeEnum roleType;
    private AbstractNetBidibServerHandler<T> netBidibServerHandler;

    public NetBidibNettyServer(String connectionName, NetBidibLinkData serverLinkData, RoleTypeEnum roleType, AbstractNetBidibServerHandler<T> netBidibServerHandler) {
        this(DEFAULT_HOSTNAME, 62875, connectionName, serverLinkData, roleType, netBidibServerHandler);
    }

    public NetBidibNettyServer(String hostName, int portNumber, String connectionName, NetBidibLinkData serverLinkData, RoleTypeEnum roleType, AbstractNetBidibServerHandler<T> netBidibServerHandler) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.connectionName = connectionName;
        this.serverLinkData = serverLinkData;
        this.roleType = roleType;
        this.netBidibServerHandler = netBidibServerHandler;
    }

    public void setNetMessageReceiver(ServerNetMessageReceiver netMessageReceiver) {
        LOGGER.info("Set the netMessageReceiver: {}", (Object)netMessageReceiver);
        this.netBidibServerHandler.setNetMessageReceiver(netMessageReceiver);
    }

    private void createServerWorkers() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("netBidibServerWorkers-thread-%d").build();
        this.serverWorkers = Executors.newScheduledThreadPool(1, namedThreadFactory);
    }

    public String getConnectionParams() {
        return this.hostName + ":" + this.portNumber;
    }

    public Thread getShutdownHook() {
        return this.shutdownHook;
    }

    public void setShutdownHook(Thread shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public Object getShutdownLock() {
        return this.shutdownLock;
    }

    protected abstract NetBidibChannelInboundHandler<T> createNetBidibChannelInboundHandler(NetBidibLinkData var1, String var2, RoleTypeEnum var3, ConnectionListener var4);

    public void startServer(final ConnectionListener connectionListener) {
        LOGGER.info("Start the server.");
        this.netBidibServerHandler.setConnectionListener(connectionListener);
        CountDownLatch startLatch = new CountDownLatch(1);
        try {
            LOGGER.info("Create ServerBootstrap with hostname: {}, portNumber: {}", (Object)this.hostName, (Object)this.portNumber);
            this.group = new NioEventLoopGroup(1);
            this.workerGroup = new NioEventLoopGroup();
            this.createServerWorkers();
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            serverBootstrap.group(this.group, this.workerGroup);
            serverBootstrap.channel(NioServerSocketChannel.class);
            serverBootstrap.localAddress((SocketAddress)new InetSocketAddress(this.hostName, this.portNumber));
            serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)100);
            serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            serverBootstrap.handler((ChannelHandler)new LoggingHandler(LogLevel.INFO));
            serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    LOGGER.info("Init the socketChannel: {}", (Object)socketChannel);
                    NetBidibChannelInboundHandler netBidibChannelInboundHandler = NetBidibNettyServer.this.createNetBidibChannelInboundHandler(NetBidibNettyServer.this.serverLinkData, NetBidibNettyServer.this.connectionName, NetBidibNettyServer.this.roleType, connectionListener);
                    socketChannel.pipeline().addLast(NetBidibNettyServer.this.eventExecutorGroup, "netBidibHandler", netBidibChannelInboundHandler);
                }
            });
            LOGGER.info("Start pre-loading the messageTypes.");
            StopWatch sw = StopWatch.createStarted();
            BidibFactory.getMessageTypes();
            sw.stop();
            LOGGER.info("Finished pre-loading the messageTypes, duration: {}ms", (Object)sw.getTime());
            Runnable serverThread = () -> {
                try {
                    ChannelFuture channelFuture;
                    LOGGER.info("Start the TCP server.");
                    this.channelFuture = channelFuture = serverBootstrap.bind().sync();
                    try {
                        connectionListener.opened(this.channelFuture.channel().remoteAddress() != null ? this.channelFuture.channel().remoteAddress().toString() : "local");
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Notify that the client connection was opened failed.", (Throwable)ex);
                    }
                    Channel channel = channelFuture.channel();
                    startLatch.countDown();
                    channel.closeFuture().sync();
                    LOGGER.info("The TCP server channel was closed.");
                }
                catch (Exception ex) {
                    LOGGER.warn("Process socket with netty failed.", (Throwable)ex);
                }
                finally {
                    try {
                        this.group.shutdownGracefully().sync();
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Shutdown the netty server gradefully failed.", (Throwable)ex);
                    }
                }
                LOGGER.info("The TCP server has finished.");
            };
            this.serverWorkers.submit(serverThread);
        }
        catch (Exception ex) {
            LOGGER.warn("Start the server failed.", (Throwable)ex);
        }
        try {
            startLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOGGER.warn("Wait for startup of server failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Future terminate;
        LOGGER.info("Stop the NetBidibServer instance.");
        if (this.netBidibServerHandler != null) {
            this.netBidibServerHandler.cleanupHandlerContext(null);
        }
        if (this.channelFuture != null) {
            LOGGER.info("Close the channel of the server.");
            try {
                this.channelFuture.channel().disconnect();
            }
            catch (Exception ex) {
                LOGGER.warn("Disconnect the channel failed.", (Throwable)ex);
            }
            this.channelFuture = null;
        } else {
            LOGGER.info("No channelFuture available.");
        }
        if (this.group != null) {
            terminate = this.group.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
            LOGGER.info("Wait for termination of server.");
            try {
                terminate.await(5000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for termination of server was interrupted.");
            }
            this.group = null;
        }
        if (this.workerGroup != null) {
            terminate = this.workerGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
            LOGGER.info("Wait for termination of workerGroup.");
            try {
                terminate.await(5000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for termination of workerGroup was interrupted.");
            }
            this.workerGroup = null;
        }
        LOGGER.info("Shutdown the serverWorkers.");
        if (this.serverWorkers != null) {
            try {
                this.serverWorkers.shutdown();
                this.serverWorkers.awaitTermination(2000L, TimeUnit.MILLISECONDS);
                this.serverWorkers = null;
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for termination of serverWorker failed.", (Throwable)ex);
            }
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            LOGGER.info("Notify the shutdownLock.");
            this.shutdownLock.notifyAll();
        }
    }

    public void signalUserAction(String actionKey, Context context) {
        LOGGER.info("signalUserAction, actionKey: {}, context: {}", (Object)actionKey, (Object)context);
        Long uniqueId = (Long)context.get("uniqueId", Long.class, null);
        if (uniqueId == null) {
            LOGGER.warn("No uniqueId delivered. Skip signal user action with actionKey: {}", (Object)actionKey);
            return;
        }
        PairingStateHandler netBidibPairingStateHandler = this.netBidibServerHandler.getPairingStateHandler(uniqueId);
        block4 : switch (actionKey) {
            case "pairingStatus": {
                NetBidibLinkData.PairingStatus pairingStatus = (NetBidibLinkData.PairingStatus)context.get("pairingStatus", NetBidibLinkData.PairingStatus.class, (Object)NetBidibLinkData.PairingStatus.UNPAIRED);
                ProxyBidibLinkData remotePartnerLinkData = netBidibPairingStateHandler.getRemotePartnerLinkData();
                if (NetBidibLinkData.PairingStatus.PAIRING_REQUESTED == remotePartnerLinkData.getPairingStatus()) {
                    LOGGER.info("The remote partner has sent the pairing request message to the server. Now send the pairing status: {}", (Object)pairingStatus);
                    switch (pairingStatus) {
                        case PAIRED: {
                            ((PairingStateInteractionHandler)netBidibPairingStateHandler).pairingResult(uniqueId, PairingResult.PAIRED);
                            break block4;
                        }
                    }
                    ((PairingStateInteractionHandler)netBidibPairingStateHandler).pairingResult(uniqueId, PairingResult.UNPAIRED);
                    break;
                }
                LOGGER.info("The pairing status is not sent because the pairing status of the remote partner is: {}", (Object)remotePartnerLinkData);
                break;
            }
            case "pairingRequest": {
                if (netBidibPairingStateHandler instanceof PairingStateInteractionHandler) {
                    LOGGER.info("Initiate the pairing.");
                    ((PairingStateInteractionHandler)netBidibPairingStateHandler).initiatePairing();
                    break;
                }
                LOGGER.warn("The netBidibPairingStateHandler is not of expected type. Check configuration.");
                break;
            }
            default: {
                LOGGER.warn("Unhandled user action: {}, context: {}", (Object)actionKey, (Object)context);
            }
        }
    }
}

