/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.AbstractMessageReceiver;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.RequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.server.NetBidibNettyServer;
import org.bidib.jbidibc.netbidib.server.ServerNetMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibServerBidib
extends AbstractBidib<ServerNetMessageReceiver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibServerBidib.class);
    private NetBidibNettyServer<BidibMessageInterface> netBidibNettyServer;
    private String requestedPortName;
    private ConnectionListener connectionListenerDelegate;

    protected NetBidibServerBidib() {
        LOGGER.info("Create instance of NetBidibServerBidib.");
    }

    public static NetBidibServerBidib createInstance(Context context) {
        NetBidibServerBidib instance = new NetBidibServerBidib();
        instance.initialize(context);
        return instance;
    }

    protected ServerNetMessageReceiver createMessageReceiver(NodeRegistry nodeRegistry, RawMessageListener rawMessageListener, Context context) {
        ServerNetMessageReceiver messageReceiver = new ServerNetMessageReceiver(nodeRegistry, (RequestFactory)nodeRegistry.getRequestFactory(), false);
        messageReceiver.setRawMessageListener(rawMessageListener);
        messageReceiver.init(context);
        return messageReceiver;
    }

    protected BidibRequestFactory createRequestFactory() {
        BidibRequestFactory requestFactory = super.createRequestFactory();
        requestFactory.setEscapeMagic(false);
        return requestFactory;
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize. Current context: {}", (Object)context);
        super.initialize(context);
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        NetBidibNettyServer netBidibNettyServer;
        LOGGER.info("Open is called, portName: {}", (Object)portName);
        this.requestedPortName = portName;
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners, context);
        LOGGER.info("Get the NetBidibNettyServer instance from the context.");
        this.netBidibNettyServer = netBidibNettyServer = (NetBidibNettyServer)context.get(NetBidibNettyServer.class.getSimpleName(), NetBidibNettyServer.class, null);
        this.netBidibNettyServer.setNetMessageReceiver((ServerNetMessageReceiver)this.getMessageReceiver());
        this.netBidibNettyServer.startServer(this.connectionListenerDelegate);
    }

    public void close() {
        LOGGER.info("Close the port.");
        if (this.netBidibNettyServer != null) {
            LOGGER.info("Stop the netBidibJettyServer.");
            this.netBidibNettyServer.stop();
            this.netBidibNettyServer = null;
            LOGGER.info("Stop the netBidibJettyServer has finished.");
            super.close();
            if (this.getConnectionListener() != null) {
                LOGGER.info("Notify that the port was closed: {}", (Object)this.requestedPortName);
                this.getConnectionListener().closed(this.requestedPortName);
            } else {
                LOGGER.info("No connection listener available to publish the closed report for port: {}", (Object)this.requestedPortName);
            }
            this.cleanupAfterClose(this.getMessageReceiver());
            LOGGER.info("Close the port has finished.");
        }
    }

    public boolean isOpened() {
        return this.netBidibNettyServer != null;
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    protected void contactInterface() {
        LOGGER.info("Contact the interface node.");
        try {
            this.sendDisableAndEnableMessageReceiver();
            LOGGER.info("Sent disable to the root node.");
        }
        catch (ProtocolException ex) {
            throw new NoAnswerException("Contact the interface node failed.", (Throwable)ex);
        }
    }

    private void sendDisableAndEnableMessageReceiver() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send sysDisable to the rootNode.");
        rootNode.sysDisable();
        try {
            LOGGER.info("Wait 300ms before enable the message receiver.");
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before enable the message receiver failed.", (Throwable)ex);
        }
        BidibMessageProcessor serialMessageReceiver = this.getBidibMessageProcessor();
        if (serialMessageReceiver instanceof AbstractMessageReceiver) {
            LOGGER.info("Enable the message receiver: {}", (Object)serialMessageReceiver);
            ((AbstractMessageReceiver)serialMessageReceiver).enable();
        }
    }

    public void send(byte[] data) {
        ((ServerNetMessageReceiver)this.getMessageReceiver()).processMessageFromHost(data);
    }

    public void signalUserAction(String actionKey, Context context) {
        LOGGER.info("Signal the user action, actionKey: {}, context: {}", (Object)actionKey, (Object)context);
        this.netBidibNettyServer.signalUserAction(actionKey, context);
    }

    public void setConnectionListener(final ConnectionListener connectionListener) {
        this.connectionListenerDelegate = new ConnectionListener(){

            public void status(String messageKey, Context context) {
                LOGGER.info("The status was signalled: {}, context: {}", (Object)messageKey, (Object)context);
                connectionListener.status(messageKey, context);
            }

            public void actionRequired(String messageKey, Context context) {
                connectionListener.actionRequired(messageKey, context);
            }

            public void opened(String port) {
                LOGGER.info("The port of the netBiDiB connection was opened: {}", (Object)port);
                connectionListener.opened(port);
                LOGGER.info("The port was opened. Contact the interface.");
                try {
                    NetBidibServerBidib.this.contactInterface();
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("Contact interface failed. Abort signal opened.", (Throwable)ex);
                    throw ex;
                }
            }

            public void closed(String portName) {
                LOGGER.info("The port was closed: {}", (Object)portName);
                connectionListener.closed(portName);
            }

            public void stall(boolean stall) {
                connectionListener.stall(stall);
            }

            public void pairingFinished(PairingResult pairingResult, long uniqueId) {
                LOGGER.info("The pairing was finished, pairingResult: {}, uniqueId: {}", (Object)pairingResult, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
                connectionListener.pairingFinished(pairingResult, uniqueId);
            }

            public void logonReceived(int localNodeAddr, long uniqueId) {
                LOGGER.info("The logon was received, localNodeAddr: {}, uniqueId: {}", (Object)localNodeAddr, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
                connectionListener.logonReceived(localNodeAddr, uniqueId);
            }

            public void logoffReceived(long uniqueId) {
                LOGGER.info("The logoff was received, uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
                connectionListener.logoffReceived(uniqueId);
            }
        };
        super.setConnectionListener(this.connectionListenerDelegate);
    }
}

