/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server.adapter;

import java.util.function.Function;
import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.HostAdapter;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHostAdapter<T>
implements HostAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHostAdapter.class);
    private BidibMessagePublisher<T> toGuestPublisher;
    private BidibMessagePublisher<T> toBackendPublisher;
    protected final Function<BidibMessageInterface, T> messageContentSupplier;

    public DefaultHostAdapter(Function<BidibMessageInterface, T> messageContentSupplier) {
        this.messageContentSupplier = messageContentSupplier;
    }

    public void initialize(Context context) {
    }

    public BidibMessagePublisher<T> getToGuestPublisher() {
        return this.toGuestPublisher;
    }

    public void setToGuestPublisher(BidibMessagePublisher<T> toGuestPublisher) {
        LOGGER.info("Set the toGuestPublisher: {}", toGuestPublisher);
        this.toGuestPublisher = toGuestPublisher;
    }

    public BidibMessagePublisher<T> getToBackendPublisher() {
        return this.toBackendPublisher;
    }

    public void setToBackendPublisher(BidibMessagePublisher<T> toBackendPublisher) {
        LOGGER.info("Set the toBackendPublisher: {}", toBackendPublisher);
        this.toBackendPublisher = toBackendPublisher;
    }

    public void forwardMessageToBackend(T rawMessage) {
        if (this.toBackendPublisher != null) {
            this.toBackendPublisher.publishBidibMessage(null, null, rawMessage);
        } else {
            LOGGER.warn("No toBackendPublisher available, discard message.");
        }
    }

    public void forwardMessageToGuest(String contextKey, SequenceNumberProvider node, T rawMessage) {
        if (this.toGuestPublisher != null) {
            this.toGuestPublisher.publishBidibMessage(contextKey, node, rawMessage);
        } else {
            LOGGER.warn("No toGuestPublisher available, discard message.");
        }
    }

    public void signalConnectionOpened(Context context) {
        LOGGER.info("The connection was opened. Current toBackendPublisher: {}", this.toBackendPublisher);
    }

    public void signalConnectionClosed(Context context) {
        LOGGER.info("The connection was closed.");
    }
}

