package org.bidib.jbidibc.netbidib.server;

import java.util.function.Supplier;

import org.bidib.jbidibc.core.BidibMessageEvaluator;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibServerHandlerByteArray extends AbstractNetBidibServerHandler<byte[]> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibServerHandlerByteArray.class);

    public NetBidibServerHandlerByteArray(NetBidibLinkData serverLinkData, final RoleTypeEnum roleType,
        final Supplier<BidibMessageEvaluator> bidibMessageEvaluatorSupplier) {
        super(serverLinkData, message -> message.getContent(), roleType, bidibMessageEvaluatorSupplier);
    }

    @Override
    public void publishBidibMessage(
        final String contextKey, final SequenceNumberProvider proxyNode, final byte[] content) {
        LOGGER.info("Received message to publish to host: {}", ByteUtils.bytesToHex(content));

        super.publishBidibMessage(contextKey, proxyNode, content);
    }

}
