/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.pairingstore.LocalPairingStore;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.bidib.jbidibc.netbidib.server.adapter.DefaultHostAdapter;
import org.bidib.jbidibc.netbidib.server.adapter.ScmSerialHostAdapter;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Disabled
public class NetBidibNettyServerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibNettyServerTest.class);
    public static final String PAIRINGSTORE_FILENAME = ".pairingstore_" + NetBidibNettyServerTest.class.getSimpleName();
    private static final String OUTPUT_TARGET_DIR = "target/pairingstore-test";
    private static final String SERVER_REQUESTOR = "BiDiB-Server-Test";

    @Test
    @Order(value=1)
    public void startClientAndServer() throws InterruptedException {
        LOGGER.info("Start the test server.");
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.internalStartClientAndServer(callback, SERVER_REQUESTOR, "BiDiB-Client-Test");
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.atLeastOnce())).accept("established");
    }

    @Test
    @Order(value=2)
    public void startClientAndServerAccessDenied() throws InterruptedException {
        LOGGER.info("Start the test server.");
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.internalStartClientAndServer(callback, SERVER_REQUESTOR, "WrongBidib");
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).accept("established");
    }

    private void internalStartClientAndServer(final Consumer<String> callback, String serverRequestor, String clientRequestor) throws InterruptedException {
        String pairingStorePath = new File(OUTPUT_TARGET_DIR).getAbsolutePath();
        File pairingStoreFile = new File(pairingStorePath, PAIRINGSTORE_FILENAME);
        LOGGER.info("Load the data from the pairing store.");
        LocalPairingStore pairingStore = new LocalPairingStore(pairingStoreFile);
        pairingStore.load();
        NetBidibLinkData serverLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.LOCAL_CLIENT);
        serverLinkData.setRequestorName(serverRequestor);
        serverLinkData.setProtocolVersion(ProtocolVersion.VERSION_0_8);
        serverLinkData.setUniqueId(Long.valueOf(1L));
        serverLinkData.setProdString("TEST_PROD");
        serverLinkData.setUserString("TEST_USER");
        final DefaultHostAdapter hostAdapter = new DefaultHostAdapter(message -> message.getContent());
        hostAdapter.setToBackendPublisher((BidibMessagePublisher)new BidibMessagePublisher<byte[]>(){

            public void publishBidibMessage(String contextKey, SequenceNumberProvider proxyNode, byte[] content) {
                LOGGER.info("Received message content: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                callback.accept("established");
                if (content[3] == ByteUtils.getLowByte((int)1)) {
                    try {
                        SysMagicResponse response = new SysMagicResponse(Node.ROOTNODE_ADDR, 0, new byte[]{-2, -81});
                        LOGGER.warn("Demo only. Let the scheduler send the message to the host.");
                        Executors.newScheduledThreadPool(1).submit(() -> {
                            byte[] messageContent = response.getContent();
                            LOGGER.warn("Publish message back to host: {}", (Object)ByteUtils.bytesToHex((byte[])messageContent));
                            hostAdapter.getToGuestPublisher().publishBidibMessage(contextKey, proxyNode, (Object)messageContent);
                        });
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Send sysMagic response failed.", (Throwable)ex);
                    }
                } else {
                    LOGGER.warn("Discard message: {}", (Object)ByteUtils.bytesToHex((byte[])content));
                }
            }
        });
        RoleTypeEnum roleType = RoleTypeEnum.INTERFACE;
        LOGGER.info("Finished.");
    }

    public static void main(String[] args) throws InterruptedException {
        LOGGER.info("Start the test server.");
        NetBidibLinkData serverLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.LOCAL_CLIENT);
        serverLinkData.setProtocolVersion(ProtocolVersion.VERSION_0_8);
        ScmSerialHostAdapter hostAdapter = new ScmSerialHostAdapter(message -> message.getContent());
        RoleTypeEnum roleType = RoleTypeEnum.INTERFACE;
        NetBidibLinkData pairedPartner = new NetBidibLinkData(NetBidibLinkData.PartnerType.REMOTE);
        pairedPartner.setPairingStatus(NetBidibLinkData.PairingStatus.UNKNOWN);
        pairedPartner.setLogonStatus(NetBidibLinkData.LogonStatus.LOGGED_OFF);
    }
}

