/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.BidibMessageEvaluator;
import org.bidib.jbidibc.messages.BidibMessagePublisher;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.enums.NetBidibSocketType;
import org.bidib.jbidibc.messages.enums.PairingResult;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.LocalLogonRejectedMessage;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.pairingstates.DefaultPairingStateHandler;
import org.bidib.jbidibc.netbidib.client.pairingstates.NetBidibMessageSender;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingInteractionPublisher;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateHandler;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.jbidibc.netbidib.server.RoleTypeEnum;
import org.bidib.jbidibc.netbidib.server.ServerNetMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetBidibServerHandler<T>
implements BidibMessagePublisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNetBidibServerHandler.class);
    private static final Logger MSG_TX_LOGGER = LoggerFactory.getLogger((String)"TX");
    private BidibRequestFactory bidibRequestFactory;
    protected final Object pairedPartnerLock = new Object();
    private PairingStore pairingStore;
    private final Map<String, ChannelHandlerContext> channelHandlerMap = new LinkedHashMap<String, ChannelHandlerContext>();
    private final Map<String, PairingStateHandler> pairingStateHandlerMap = new LinkedHashMap<String, PairingStateHandler>();
    private Set<ConnectionListener> remoteConnectionListeners = new HashSet<ConnectionListener>();
    private RoleTypeEnum roleType;
    private final NetBidibLinkData serverLinkData;
    private ServerNetMessageReceiver netMessageReceiver;
    private final ScheduledExecutorService logonReceivedPublisherWorker;
    private final Supplier<BidibMessageEvaluator> bidibMessageEvaluatorSupplier;
    private NetBidibMessageSender netBidibMessageSender;
    private PairingInteractionPublisher pairingInteractionPublisher;

    public AbstractNetBidibServerHandler(NetBidibLinkData serverLinkData, Function<BidibMessageInterface, T> messageContentSupplier, RoleTypeEnum roleType, Supplier<BidibMessageEvaluator> bidibMessageEvaluatorSupplier) {
        LOGGER.info("Create new NetBidibServerHandler instance. Provided roleType: {}", (Object)roleType);
        this.serverLinkData = serverLinkData;
        this.roleType = roleType;
        this.bidibMessageEvaluatorSupplier = bidibMessageEvaluatorSupplier;
        this.logonReceivedPublisherWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("publisherWorkers-thread-%d").build());
    }

    public void setNetMessageReceiver(ServerNetMessageReceiver netMessageReceiver) {
        LOGGER.info("Set the netMessageReceiver: {}", (Object)netMessageReceiver);
        this.netMessageReceiver = netMessageReceiver;
        LOGGER.info("Set the message listener map and the message evaluator in the message receiver.");
        this.netMessageReceiver.setNetBidibLocalMessageListenerMap(this.pairingStateHandlerMap);
        this.netMessageReceiver.setBidibMessageEvaluator(this.bidibMessageEvaluatorSupplier.get());
    }

    public void initialize() {
        LOGGER.info("Initialize the NetBidibServerHandler.");
        this.bidibRequestFactory = new BidibRequestFactory();
        this.bidibRequestFactory.setEscapeMagic(false);
        this.bidibRequestFactory.initialize();
        this.netBidibMessageSender = new NetBidibMessageSender(){

            public void publishNetBidibMessage(String contextKey, BidibCommand message) throws ProtocolException {
                LOGGER.info("publishNetBidibMessage, contextKey: {}, message: {}", (Object)contextKey, (Object)message);
                try {
                    AbstractNetBidibServerHandler.this.sendNetBidibMessage(contextKey, message);
                }
                catch (Exception ex) {
                    LOGGER.warn("Send the netBidibMessage failed.", (Throwable)ex);
                    throw new ProtocolException("Send the netBidibMessage failed.");
                }
            }

            public void publishLocalLogonRejected(String contextKey, long uniqueId) {
                LOGGER.info("publishLocalLogonRejected, contextKey: {}, uniqueId: {}", (Object)contextKey, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
                AbstractNetBidibServerHandler.this.sendLocalLogonRejected(contextKey, uniqueId);
            }
        };
        this.pairingInteractionPublisher = new PairingInteractionPublisher(){

            public void publishUserAction(String actionKey, Context context) {
                LOGGER.info("Publish the user action, actionKey: {}, context: {}", (Object)actionKey, (Object)context);
                AbstractNetBidibServerHandler.this.logonReceivedPublisherWorker.submit(() -> AbstractNetBidibServerHandler.this.publishUserAction(actionKey, context));
            }

            public void publishPairingFinished(PairingResult pairingResult, long uniqueId) {
                LOGGER.info("Publish the pairing result: {}", (Object)pairingResult);
                AbstractNetBidibServerHandler.this.logonReceivedPublisherWorker.submit(() -> AbstractNetBidibServerHandler.this.publishPairingFinished(pairingResult, uniqueId));
            }

            public void publishLocalLogon(int localNodeAddr, long uniqueId) {
                LOGGER.info("Publish the logon received from a different thread, localNodeAddr: {}, uniqueId: {}", (Object)localNodeAddr, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
                AbstractNetBidibServerHandler.this.logonReceivedPublisherWorker.submit(() -> AbstractNetBidibServerHandler.this.publishLogonReceived(localNodeAddr, uniqueId));
            }

            public void publishLocalLogoff(long uniqueId) {
                LOGGER.info("Publish the logoff received from a different thread.");
                AbstractNetBidibServerHandler.this.logonReceivedPublisherWorker.submit(() -> AbstractNetBidibServerHandler.this.publishLogoffReceived(uniqueId));
            }

            public void handleError(RuntimeException ex) {
                AbstractNetBidibServerHandler.this.logonReceivedPublisherWorker.submit(() -> AbstractNetBidibServerHandler.this.handleError(ex));
            }
        };
    }

    private PairingStateHandler createPairingStateHandler(String contextKey) {
        LOGGER.info("Create new pairing state handler for contextKey: {}", (Object)contextKey);
        DefaultPairingStateHandler netBidibPairingStateHandler = new DefaultPairingStateHandler(this.netBidibMessageSender, this.pairingInteractionPublisher, this.bidibRequestFactory, contextKey);
        netBidibPairingStateHandler.setNetBidibSocketType(NetBidibSocketType.serverSocket);
        NetBidibLinkData remotePartnerLinkData = new NetBidibLinkData(NetBidibLinkData.PartnerType.REMOTE);
        NetBidibLinkData serverLinkData = new NetBidibLinkData(this.serverLinkData);
        netBidibPairingStateHandler.initialize((BidibLinkData)remotePartnerLinkData, (BidibLinkData)serverLinkData, this.pairingStore);
        return netBidibPairingStateHandler;
    }

    public PairingStateHandler getPairingStateHandler(Long uniqueId) {
        LOGGER.info("Get the pairing state handler for remote partner uniqueId: {}", (Object)uniqueId);
        Optional<PairingStateHandler> pairingStateHandler = this.pairingStateHandlerMap.values().stream().filter(psh -> uniqueId.equals(psh.getRemotePartnerLinkData().getUniqueId())).findFirst();
        return pairingStateHandler.orElseThrow(() -> new IllegalArgumentException("No pairingStateHandler found for remote partner uniqueId: " + ByteUtils.formatHexUniqueId((Long)uniqueId)));
    }

    protected boolean handleLocalBidibUpResponse() {
        return this.roleType == RoleTypeEnum.INTERFACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteConnectionListener(ConnectionListener remoteConnectionListener) {
        Set<ConnectionListener> set = this.remoteConnectionListeners;
        synchronized (set) {
            this.remoteConnectionListeners.add(remoteConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteConnectionListener(ConnectionListener remoteConnectionListener) {
        Set<ConnectionListener> set = this.remoteConnectionListeners;
        synchronized (set) {
            this.remoteConnectionListeners.remove(remoteConnectionListener);
        }
    }

    public void setPairingStore(PairingStore pairingStore) {
        this.pairingStore = pairingStore;
    }

    private void sendLocalLogonRejected(String contextKey, long uniqueId) {
        LocalLogonRejectedMessage localLogonRejected = this.bidibRequestFactory.createLocalLogonRejected(uniqueId);
        localLogonRejected.setAddr(Node.ROOTNODE_ADDR);
        this.sendNetBidibMessage(contextKey, (BidibCommand)localLogonRejected);
        ChannelHandlerContext ctx = this.channelHandlerMap.get(contextKey);
        if (ctx != null) {
            LOGGER.info("Disconnect the channel, contextKey: {}", (Object)contextKey);
            ctx.channel().disconnect();
        } else {
            LOGGER.warn("Disconnect channel failed because the context is not registered, contextKey: {}", (Object)contextKey);
        }
    }

    private void sendNetBidibMessage(String contextKey, BidibCommand message) {
        LOGGER.info("Send the netBidibMessage, contextKey: {}, message: {}", (Object)contextKey, (Object)message);
        ChannelHandlerContext ctx = this.channelHandlerMap.get(contextKey);
        if (ctx != null) {
            this.publishMessage(ctx, (BidibMessageInterface)message);
        } else {
            LOGGER.warn("Publish message failed because the context is not registered, contextKey: {}, message: {}", (Object)contextKey, (Object)message);
        }
    }

    public void processMessages(ByteArrayOutputStream messageData, String contextKey) throws ProtocolException {
        this.netMessageReceiver.processMessages(messageData, contextKey);
    }

    public void channelRegistered(String contextKey, ChannelHandlerContext ctx) {
        LOGGER.info("Channel registered, contextKey: {}", (Object)contextKey);
        this.channelHandlerMap.put(contextKey, ctx);
        LOGGER.info("Store the channelHandlerContext: {}", (Object)ctx);
        this.pairingStateHandlerMap.put(contextKey, this.createPairingStateHandler(contextKey));
        this.netMessageReceiver.notifyConnectionOpened(contextKey);
    }

    public void cleanupHandlerContext(String contextKey) {
        LOGGER.info("Cleanup the maps. Fetched the contextKey: {}", (Object)contextKey);
        if (StringUtils.isBlank((CharSequence)contextKey)) {
            this.channelHandlerMap.clear();
            this.pairingStateHandlerMap.clear();
        } else {
            this.channelHandlerMap.remove(contextKey);
            this.pairingStateHandlerMap.remove(contextKey);
        }
        this.netMessageReceiver.notifyConnectionClosed(contextKey);
    }

    protected void publishBidibMessage(String contextKey, SequenceNumberProvider sequenceNumberProvider, BidibMessageInterface message) {
        LOGGER.info("Received message to publish to the guest: {}", (Object)message);
        byte[] addr = message.getAddr();
        Integer localNodeAddress = this.bidibMessageEvaluatorSupplier.get().getLocalNodeAddress(contextKey);
        if (localNodeAddress == null) {
            LOGGER.warn("No local node address found for contextKey: {}, message: {}", (Object)contextKey, (Object)message);
            return;
        }
        if (Arrays.equals(addr, new byte[]{ByteUtils.getLowByte((Integer)localNodeAddress)})) {
            message.setAddr(Node.ROOTNODE_ADDR);
        } else if (!Arrays.equals(addr, Node.ROOTNODE_ADDR)) {
            message.setAddr(ByteUtils.subArray((byte[])addr, (int)1));
        }
        LOGGER.info("Change address of message to publish to the guest: {}", (Object)message);
        byte[] content = message.getContent();
        this.logTX(message, content);
        this.publishMessage(contextKey, content);
    }

    protected void publishBidibMessage(String contextKey, SequenceNumberProvider sequenceNumberProvider, byte[] message) {
        LOGGER.info("Received message to publish to the guest: {}", (Object)ByteUtils.bytesToHex((byte[])message));
        this.publishMessage(contextKey, message);
    }

    protected void logTX(BidibMessageInterface bidibCommand, byte[] content) {
        if (MSG_TX_LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(">>net>> ");
            sb.append(bidibCommand);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])content));
            MSG_TX_LOGGER.info(sb.toString());
        }
    }

    private void publishMessage(String contextKey, byte[] message) {
        ChannelHandlerContext ctx = this.channelHandlerMap.get(contextKey);
        try {
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])message));
        }
        catch (Exception ex) {
            LOGGER.warn("Write message to channel failed.", (Throwable)ex);
        }
    }

    private void publishMessage(ChannelHandlerContext ctx, BidibMessageInterface message) {
        LOGGER.info("Publish the message to channel: {}, message: {}", (Object)ctx, (Object)message);
        byte[] content = message.getContent();
        this.logTX(message, content);
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])content));
        LOGGER.info("Write message to socketChannel has finished, msg: {}", (Object)ByteUtils.bytesToHex((byte[])content));
    }

    private void publishUserAction(String actionKey, Context context) {
        LOGGER.info("Publish the user action, actionKey: {}, context: {}", (Object)actionKey, (Object)context);
        List<ConnectionListener> connectionListeners = this.getSafeConnectionListeners();
        for (ConnectionListener connectionListener : connectionListeners) {
            try {
                connectionListener.actionRequired(actionKey, context);
            }
            catch (Exception ex) {
                LOGGER.warn("Notify that action is required failed, actionKey: {}", (Object)actionKey, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConnectionListener> getSafeConnectionListeners() {
        LinkedList<ConnectionListener> connectionListeners = new LinkedList<ConnectionListener>();
        Set<ConnectionListener> set = this.remoteConnectionListeners;
        synchronized (set) {
            connectionListeners.addAll(this.remoteConnectionListeners);
        }
        LOGGER.info("Publish to connectionListeners: {}", connectionListeners);
        return connectionListeners;
    }

    private void publishPairingFinished(PairingResult pairingResult, long uniqueId) {
        LOGGER.info("Publish the pairing result: {}", (Object)pairingResult, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        List<ConnectionListener> connectionListeners = this.getSafeConnectionListeners();
        for (ConnectionListener connectionListener : connectionListeners) {
            try {
                connectionListener.pairingFinished(pairingResult, uniqueId);
            }
            catch (Exception ex) {
                LOGGER.warn("Notify the pairing result failed, pairingResult: {}", (Object)pairingResult, (Object)ex);
            }
        }
    }

    private void publishLogonReceived(int localNodeAddr, long uniqueId) {
        LOGGER.info("Publish the logon received, localNodeAddr: {}, uniqueId: {}", (Object)localNodeAddr, (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        List<ConnectionListener> connectionListeners = this.getSafeConnectionListeners();
        for (ConnectionListener connectionListener : connectionListeners) {
            try {
                connectionListener.logonReceived(localNodeAddr, uniqueId);
            }
            catch (Exception ex) {
                LOGGER.warn("Notify the logon received failed.", (Throwable)ex);
            }
        }
    }

    private void publishLogoffReceived(long uniqueId) {
        LOGGER.info("Publish the logoff received, uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
        List<ConnectionListener> connectionListeners = this.getSafeConnectionListeners();
        for (ConnectionListener connectionListener : connectionListeners) {
            try {
                connectionListener.logoffReceived(uniqueId);
            }
            catch (Exception ex) {
                LOGGER.warn("Notify the logoff received failed.", (Throwable)ex);
            }
        }
    }

    private void handleError(RuntimeException ex) {
        List<ConnectionListener> connectionListeners = this.getSafeConnectionListeners();
        for (ConnectionListener connectionListener : connectionListeners) {
            try {
                connectionListener.handleError(ex);
            }
            catch (Exception ex1) {
                LOGGER.warn("Handle the error in connectionListener failed.", (Throwable)ex1);
            }
        }
    }

    public void setConnectionListener(final ConnectionListener connectionListener) {
        LOGGER.info("Set the connection listener: {}", (Object)connectionListener);
        this.addRemoteConnectionListener(new ConnectionListener(){

            public void actionRequired(String messageKey, Context context) {
                connectionListener.actionRequired(messageKey, context);
            }

            public void pairingFinished(PairingResult pairingResult, long uniqueId) {
                connectionListener.pairingFinished(pairingResult, uniqueId);
            }

            public void logonReceived(int localNodeAddr, long uniqueId) {
                connectionListener.logonReceived(localNodeAddr, uniqueId);
            }

            public void logoffReceived(long uniqueId) {
                connectionListener.logoffReceived(uniqueId);
            }

            public void status(String messageKey, Context context) {
                LOGGER.info("Connection status received, messageKey: {}, context: {}", (Object)messageKey, (Object)context);
                connectionListener.status(messageKey, context);
            }

            public void opened(String port) {
                LOGGER.info("Remote connection opened, port: {}", (Object)port);
                connectionListener.opened(port);
            }

            public void closed(String port) {
                LOGGER.info("The connection to the client was closed: {}", (Object)port);
                connectionListener.closed(port);
            }

            public void stall(boolean stall) {
                connectionListener.stall(stall);
            }
        });
    }
}

