/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.server.AbstractNetBidibServerHandler;
import org.bidib.jbidibc.netbidib.server.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibChannelInboundHandler<T>
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibChannelInboundHandler.class);
    private final AbstractNetBidibServerHandler<T> netBidibServerHandler;
    private String contextKey;
    private final ByteArrayOutputStream messageData = new ByteArrayOutputStream(2048);

    public NetBidibChannelInboundHandler(AbstractNetBidibServerHandler<T> netBidibServerHandler) {
        this.netBidibServerHandler = netBidibServerHandler;
    }

    private static String prepareKey(InetSocketAddress remoteAddress) {
        String key = remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
        return key;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        String contextKey;
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        LOGGER.info("Session created. Remote IP: {}, port: {}, channel: {}", new Object[]{remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort(), ctx.channel()});
        ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.NOT_CONNECTED);
        if (remoteAddress != null) {
            ctx.channel().attr(ConnectionState.REMOTE_ADDRESS_KEY).set((Object)remoteAddress.toString());
        }
        super.channelRegistered(ctx);
        this.contextKey = contextKey = NetBidibChannelInboundHandler.prepareKey(remoteAddress);
        ctx.channel().attr(ConnectionState.CONTEXT_KEY).set((Object)contextKey);
        this.netBidibServerHandler.channelRegistered(contextKey, ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        LOGGER.info("Session closed. IP: {}", (Object)remoteAddress);
        if (remoteAddress == null) {
            SocketAddress localAddress = ctx.channel().localAddress();
            LOGGER.info("No remoteAddress available. Use localAddress: {}", (Object)localAddress);
            remoteAddress = localAddress;
        }
        String connectedRemoteAddress = (String)ctx.channel().attr(ConnectionState.REMOTE_ADDRESS_KEY).get();
        LOGGER.info("The connected remote address: {}", (Object)connectedRemoteAddress);
        ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.NOT_CONNECTED);
        super.channelUnregistered(ctx);
        this.cleanupHandlerContext(ctx);
        LOGGER.info("Disconnected.");
    }

    private void cleanupHandlerContext(ChannelHandlerContext ctx) {
        String contextKey = (String)ctx.channel().attr(ConnectionState.CONTEXT_KEY).get();
        LOGGER.info("Cleanup the maps. Fetched the contextKey: {}", (Object)contextKey);
        this.netBidibServerHandler.cleanupHandlerContext(contextKey);
        this.contextKey = null;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("channelInactive, ctx: {}", (Object)ctx);
        super.channelInactive(ctx);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("handlerAdded, ctx: {}", (Object)ctx);
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("handlerRemoved, ctx: {}", (Object)ctx);
        super.handlerRemoved(ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug("channelReadComplete.");
        super.channelReadComplete(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            LOGGER.warn("IOException: {}", (Object)cause.getMessage());
        } else {
            LOGGER.warn("Exception caught in server handler. Will close connection.", cause);
        }
        ctx.channel().attr(ConnectionState.STATE_KEY).set((Object)ConnectionState.Phase.NOT_CONNECTED);
        ctx.close();
    }

    public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) {
        byte[] messageContent = new byte[in.readableBytes()];
        in.readBytes(messageContent);
        LOGGER.info("<<net<< {} : {}", (Object)this.contextKey, (Object)ByteUtils.bytesToHex((byte[])messageContent));
        try {
            int len = ByteUtils.getInt((byte)messageContent[0]);
            LOGGER.debug("Current message len: {}", (Object)len);
            try {
                this.messageData.write(messageContent);
            }
            catch (IOException ex2) {
                LOGGER.warn("Write data to output stream failed.", (Throwable)ex2);
            }
            String contextKey = (String)ctx.channel().attr(ConnectionState.CONTEXT_KEY).get();
            this.netBidibServerHandler.processMessages(this.messageData, contextKey);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create messages from provided data failed.", (Throwable)ex);
        }
    }
}

