/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.BidibMessageEvaluator;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.RequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.NetMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerNetMessageReceiver
extends NetMessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerNetMessageReceiver.class);
    private final ScheduledExecutorService rootNodeWorkers;

    public ServerNetMessageReceiver(NodeRegistry nodeRegistry, RequestFactory requestFactory, boolean checkCRC) {
        super(nodeRegistry, requestFactory, checkCRC);
        LOGGER.info("Create new instance of ServerNetMessageReceiver.");
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("rootNodeWorkers-thread-%d").build();
        this.rootNodeWorkers = Executors.newScheduledThreadPool(1, namedThreadFactory);
    }

    public void cleanup() {
        LOGGER.info("Cleanup the ServerNetMessageReceiver.");
        super.cleanup();
        try {
            this.rootNodeWorkers.shutdownNow();
            this.rootNodeWorkers.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            LOGGER.warn("Shutdown rootNodeWorkers failed.", (Throwable)ex);
        }
    }

    public void processMessageFromHost(byte[] data) {
        LOGGER.info("Process the message from the host: {}", (Object)ByteUtils.bytesToHex((byte[])data));
        if (data.length > 2) {
            this.rootNodeWorkers.submit(() -> {
                LOGGER.info("Create messages from data: {}", (Object)ByteUtils.bytesToHex((byte[])data));
                try {
                    List messages = this.getRequestFactory().create(data);
                    for (BidibMessageInterface message : messages) {
                        LOGGER.info("Current message: {}", (Object)message);
                        BidibNode bidibNode = this.getNodeRegistry().findNode(message.getAddr());
                        this.getBidibMessageEvaluator().processBidibMessageFromHost(message, bidibNode, response -> {
                            this.logRX(message, message.getContent());
                            this.processMessageToHost((BidibMessageInterface)response, "");
                        });
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Create request for root node failed.", (Throwable)ex);
                }
            });
        } else {
            LOGGER.warn("Invalid message part detected that is discarded: {}", (Object)ByteUtils.bytesToHex((byte[])data));
        }
    }

    public void notifyConnectionOpened(String contextKey) {
        LOGGER.info("The connection was opened, contextKey: {}", (Object)contextKey);
        this.getBidibMessageEvaluator().connectionOpened(null);
    }

    public void notifyConnectionClosed(String contextKey) {
        LOGGER.info("The connection was closed, contextKey: {}", (Object)contextKey);
        if (StringUtils.isBlank((CharSequence)contextKey)) {
            this.getBidibMessageEvaluator().connectionClosed(null);
        } else {
            this.getBidibMessageEvaluator().connectionClosed(contextKey, message -> {
                this.logRX((BidibMessageInterface)message, message.getContent());
                this.processMessageToHost((BidibMessageInterface)message, contextKey);
            });
        }
    }

    protected void doProcessMessage(BidibMessageInterface bidibCommand, String contextKey, byte[] messageArray) throws ProtocolException {
        LOGGER.info("Processing BiDiB node related command: {}", (Object)bidibCommand);
        BidibMessageEvaluator bidibMessageEvaluator = this.getBidibMessageEvaluator();
        Integer localNodeAddress = bidibMessageEvaluator.getLocalNodeAddress(contextKey);
        if (localNodeAddress == null) {
            LOGGER.warn("No local node address found for contextKey: {}, bidibCommand: {}", (Object)contextKey, (Object)bidibCommand);
            throw new ProtocolException("No local node address found for contextKey: " + contextKey);
        }
        byte[] addr = null;
        addr = Arrays.equals(bidibCommand.getAddr(), Node.ROOTNODE_ADDR) ? new byte[]{ByteUtils.getLowByte((Integer)localNodeAddress)} : ByteUtils.prepend((byte)ByteUtils.getLowByte((Integer)localNodeAddress), (byte[])bidibCommand.getAddr());
        LOGGER.info("Prepared the new address for the message: {}", (Object)NodeUtils.formatAddress((byte[])addr));
        bidibCommand.setAddr(addr);
        LOGGER.info("Continue processing BiDiB node related command: {}", (Object)bidibCommand);
        super.doProcessMessage(bidibCommand, contextKey, messageArray);
    }
}

