/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.netbidib.server.adapter;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.function.Function;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SequenceNumberProvider;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.netbidib.server.adapter.DefaultHostAdapter;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SimulationMessageReceiver;
import org.bidib.jbidibc.simulation.demo.DemoMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationHostAdapter
extends DefaultHostAdapter<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationHostAdapter.class);
    private DemoMaster demoMaster;
    private final BidibRequestFactory requestFactory = new BidibRequestFactory();

    public SimulationHostAdapter(Function<BidibMessageInterface, byte[]> messageContentSupplier) {
        super(messageContentSupplier);
        this.requestFactory.initialize();
    }

    @Override
    public void forwardMessageToBackend(byte[] rawMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Forward message to backend: {}", (Object)ByteUtils.bytesToHex((byte[])rawMessage));
        }
        final String contextKey = null;
        if (this.getToBackendPublisher() != null) {
            this.getToBackendPublisher().publishBidibMessage(contextKey, null, (Object)rawMessage);
        } else {
            if (this.demoMaster == null) {
                long uniqueId = 61361602502354154L;
                boolean autoAddFeature = false;
                SimulationMessageReceiver messageReceiver = new SimulationMessageReceiver(){

                    public void removeNodeListener(NodeListener nodeListener) {
                    }

                    public void publishResponse(ByteArrayOutputStream output) throws ProtocolException {
                        LOGGER.info("Publish the response. Prepare message to send to host using toHostPublisher: {}", SimulationHostAdapter.this.getToGuestPublisher());
                        try {
                            SimulationHostAdapter.this.getToGuestPublisher().publishBidibMessage(contextKey, null, (Object)output.toByteArray());
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Process messages failed.", (Throwable)ex);
                        }
                    }

                    public void setAsyncProcessingEnabled(boolean asyncProcessingEnabled) {
                    }
                };
                LOGGER.info("Create and init the demo master.");
                DefaultContext context = new DefaultContext();
                this.demoMaster = new DemoMaster(new byte[]{0}, uniqueId, autoAddFeature, (SimulationBidibMessageProcessor)messageReceiver, this.requestFactory);
                this.demoMaster.setProtocolVersion(ProtocolVersion.VERSION_0_8.toString());
                this.demoMaster.setSoftwareVersion(SoftwareVersion.build((int)1, (int)0, (int)0).toString());
                this.demoMaster.init((Context)context);
                this.demoMaster.start();
            }
            LOGGER.warn("Demo only. Let the demo master send the message to the host.");
            try {
                List commands = this.requestFactory.create(rawMessage);
                for (BidibMessageInterface bidibMessage : commands) {
                    this.demoMaster.processRequest(bidibMessage);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Process request in demoMaster failed.", (Throwable)ex);
            }
        }
    }

    @Override
    public void forwardMessageToGuest(String contextKey, SequenceNumberProvider node, byte[] rawMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Forward message to host: {}", (Object)ByteUtils.bytesToHex((byte[])rawMessage));
        }
        this.getToGuestPublisher().publishBidibMessage(contextKey, node, (Object)rawMessage);
    }
}

