/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.purejavacomm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TooManyListenersException;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.base.AbstractBaseBidib;
import org.bidib.jbidibc.core.base.RawMessageListener;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.exception.InvalidLibraryException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.purejavacomm.PureJavaCommSerialBidib;
import org.bidib.jbidibc.serial.LineStatusListener;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.CommPortOwnershipListener;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class PureJavaCommSerialConnector
extends AbstractBaseBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(PureJavaCommSerialConnector.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private SerialPort port;
    private CommPortOwnershipListener commPortOwnershipListener;
    private CommPortIdentifier commPort;
    private MessageReceiver messageReceiver;
    protected Object receiveLock = new Object();
    private byte[] inputBuffer = new byte[2048];
    private boolean useHardwareFlowControl;
    private LineStatusListener lineStatusListener;
    private final ByteArrayOutputStream sendBuffer = new ByteArrayOutputStream(2048);

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public LineStatusListener getLineStatusListener() {
        return this.lineStatusListener;
    }

    public void setLineStatusListener(LineStatusListener lineStatusListener) {
        this.lineStatusListener = lineStatusListener;
    }

    protected void internalOpen(String portName, Context context) throws PortNotFoundException, PortNotOpenedException {
        super.internalOpen(portName, context);
        LOGGER.info("Internal open the port.");
        if (this.commPort == null) {
            try {
                this.commPort = CommPortIdentifier.getPortIdentifier((String)portName);
            }
            catch (NoSuchPortException ex) {
                LOGGER.warn("Requested port is not available: {}", (Object)portName, (Object)ex);
                throw new PortNotFoundException(portName);
            }
        } else {
            LOGGER.info("Use existing commPort: {}", (Object)this.commPort);
        }
        if (this.commPortOwnershipListener == null) {
            this.commPortOwnershipListener = new CommPortOwnershipListener(){

                public void ownershipChange(int type) {
                    LOGGER.info("Ownership changed, type: {}", (Object)type);
                }
            };
        }
        this.commPort.addPortOwnershipListener(this.commPortOwnershipListener);
        SerialPort scmPort = null;
        try {
            scmPort = (SerialPort)this.commPort.open(PureJavaCommSerialBidib.class.getName(), 2000);
            Boolean useHardwareFlowControl = (Boolean)context.get("serial.useHardwareFlowControl", Boolean.class, (Object)Boolean.TRUE);
            LOGGER.info("Open port with portName: {}, useHardwareFlowControl: {}", (Object)portName, (Object)useHardwareFlowControl);
            if (useHardwareFlowControl.booleanValue()) {
                LOGGER.info("Set flow control mode to SerialPort.FLOWCONTROL_RTSCTS_IN | SerialPort.FLOWCONTROL_RTSCTS_OUT!");
                scmPort.setFlowControlMode(3);
                this.useHardwareFlowControl = true;
            } else {
                LOGGER.info("Set flow control mode to SerialPort.FLOWCONTROL_NONE!");
                scmPort.setFlowControlMode(0);
                this.useHardwareFlowControl = false;
            }
            Integer baudRate = (Integer)context.get("serial.baudrate", Integer.class, (Object)115200);
            LOGGER.info("Open port with baudRate: {}", (Object)baudRate);
            scmPort.setSerialPortParams(baudRate.intValue(), 8, 1, 0);
        }
        catch (UnsupportedCommOperationException ex) {
            LOGGER.warn("Configure RXTX com port failed.", (Throwable)ex);
            throw new InvalidConfigurationException("Configure RXTX com port failed.");
        }
        catch (PortInUseException ex) {
            LOGGER.warn("The port is in use already.", (Throwable)ex);
            throw new PortNotOpenedException("The port is in use already.", ex.getMessage());
        }
        final SerialPort serialPort = scmPort;
        this.startReceiverAndQueues(this.messageReceiver, context);
        SerialPortEventListener eventListener = new SerialPortEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void serialEvent(SerialPortEvent event) {
                LOGGER.trace("serialEvent received: {}", (Object)event);
                switch (event.getEventType()) {
                    case 1: {
                        try {
                            Object object = PureJavaCommSerialConnector.this.receiveLock;
                            synchronized (object) {
                                InputStream input = serialPort.getInputStream();
                                int len = -1;
                                try {
                                    len = input.read(PureJavaCommSerialConnector.this.inputBuffer, 0, PureJavaCommSerialConnector.this.inputBuffer.length);
                                    int remaining = input.available();
                                    if (remaining > 0) {
                                        LOGGER.warn("More data in inputStream might be available, remaining: {}", (Object)remaining);
                                    }
                                }
                                catch (IOException ex) {
                                    LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
                                }
                                if (len <= -1) return;
                                PureJavaCommSerialConnector.this.receive(PureJavaCommSerialConnector.this.inputBuffer, len);
                                return;
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Message receiver returned from receive with an exception!", (Throwable)ex);
                        }
                        return;
                    }
                    case 2: {
                        LOGGER.trace("The output buffer is empty.");
                        return;
                    }
                    case 6: {
                        LOGGER.warn("CD is signalled.");
                        return;
                    }
                    case 3: {
                        LOGGER.warn("The CTS value has changed, old value: {}, new value: {}", new Object[]{event.getOldValue(), event.getNewValue()});
                        PureJavaCommSerialConnector.this.fireCtsChanged(event.getNewValue());
                        if (event.getNewValue()) return;
                        LOGGER.warn("Close the port.");
                        Thread worker = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                LOGGER.info("Start close port because error was detected.");
                                try {
                                    PureJavaCommSerialConnector.this.close();
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Close after error failed.", (Throwable)ex);
                                }
                                LOGGER.warn("The port was closed.");
                            }
                        });
                        worker.start();
                        return;
                    }
                    case 7: {
                        LOGGER.warn("OE (overrun error) is signalled.");
                        return;
                    }
                    case 4: {
                        LOGGER.warn("DSR is signalled.");
                        return;
                    }
                    default: {
                        LOGGER.warn("SerialPortEvent was triggered, type: {}, old value: {}, new value: {}", new Object[]{event.getEventType(), event.getOldValue(), event.getNewValue()});
                    }
                }
            }
        };
        try {
            serialPort.addEventListener(eventListener);
        }
        catch (TooManyListenersException ex) {
            LOGGER.warn("Add eventlistener to RXTX com port failed.", (Throwable)ex);
            throw new InvalidConfigurationException("Add eventlistener to RXTX com port failed.");
        }
        serialPort.notifyOnCTS(true);
        serialPort.notifyOnCarrierDetect(true);
        serialPort.notifyOnBreakInterrupt(true);
        serialPort.notifyOnDSR(true);
        serialPort.notifyOnOverrunError(true);
        serialPort.notifyOnOutputEmpty(true);
        if (this.useHardwareFlowControl) {
            try {
                LOGGER.info("Activate DTR.");
                serialPort.setDTR(true);
            }
            catch (Exception e) {
                LOGGER.warn("Set DTR true failed.", (Throwable)e);
            }
        }
        LOGGER.info("Let the serial port notify data available.");
        serialPort.notifyOnDataAvailable(true);
        if (this.useHardwareFlowControl) {
            try {
                LOGGER.info("Activate RTS.");
                serialPort.setRTS(true);
            }
            catch (Exception e) {
                LOGGER.warn("Set RTS true failed.", (Throwable)e);
            }
        }
        try {
            if (this.useHardwareFlowControl) {
                this.fireCtsChanged(serialPort.isCTS());
            } else {
                this.fireCtsChanged(true);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Get CTS value failed.", (Throwable)e);
        }
        this.port = serialPort;
        this.setConnected(true);
    }

    protected void fireCtsChanged(boolean ready) {
        LOGGER.info("CTS has changed, ready: {}", (Object)ready);
        if (this.lineStatusListener != null) {
            this.lineStatusListener.notifyLineStatusChanged(ready);
        }
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
                LOGGER.debug("Process current CommPortIdentifier, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
                if (id.getPortType() == 1) {
                    portIdentifiers.add(id.getName());
                    continue;
                }
                LOGGER.debug("Skip port because no serial port, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }

    public boolean isOpened() {
        boolean isOpened = false;
        try {
            LOGGER.debug("Check if port is opened: {}", (Object)this.port);
            isOpened = this.port != null && this.port.getOutputStream() != null;
        }
        catch (IOException ex) {
            LOGGER.warn("OutputStream is not available.", (Throwable)ex);
        }
        return isOpened;
    }

    protected boolean isImplAvaiable() {
        return this.port != null;
    }

    public boolean close() {
        if (this.port != null) {
            LOGGER.info("Start closing the port: {}", (Object)this.port);
            long start = System.currentTimeMillis();
            if (this.useHardwareFlowControl) {
                try {
                    LOGGER.info("Deactivate DTR.");
                    this.port.setDTR(false);
                }
                catch (Exception e) {
                    LOGGER.warn("Set DTR to false failed.", (Throwable)e);
                }
                try {
                    LOGGER.info("Deactivate RTS.");
                    this.port.setRTS(false);
                }
                catch (Exception e) {
                    LOGGER.warn("Set RTS to false failed.", (Throwable)e);
                }
            }
            try {
                LOGGER.info("Remove event listener.");
                this.port.removeEventListener();
                LOGGER.info("Removed event listener.");
            }
            catch (Exception e) {
                LOGGER.warn("Remove event listener failed.", (Throwable)e);
            }
            MessageReceiver serialMessageReceiver = this.getMessageReceiver();
            this.stopReceiverAndQueues(serialMessageReceiver);
            try {
                if (this.useHardwareFlowControl) {
                    this.fireCtsChanged(this.port.isCTS());
                } else {
                    this.fireCtsChanged(false);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Get CTS value failed.", (Throwable)e);
            }
            LOGGER.info("Close the port.");
            try {
                this.port.close();
            }
            catch (Exception e) {
                LOGGER.warn("Close port failed.", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            if (this.commPortOwnershipListener != null) {
                LOGGER.info("Remove the PortOwnershipListener from commPort: {}", (Object)this.commPort);
                try {
                    this.commPort.removePortOwnershipListener(this.commPortOwnershipListener);
                }
                catch (Exception ex) {
                    LOGGER.warn("Remove port ownership listener failed.", (Throwable)ex);
                }
                this.commPortOwnershipListener = null;
            }
            this.setConnected(false);
            this.port = null;
            this.commPort = null;
            return true;
        }
        LOGGER.info("No port to close available.");
        return false;
    }

    protected void sendData(ByteArrayOutputStream data, RawMessageListener rawMessageListener) {
        if (this.port != null && data != null) {
            try {
                OutputStream os = this.port.getOutputStream();
                if (!this.firstPacketSent) {
                    LOGGER.info("Send initial sequence.");
                    try {
                        byte[] initialSequence = new byte[]{-2};
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((byte[])initialSequence));
                        }
                        if (rawMessageListener != null) {
                            rawMessageListener.notifySend(initialSequence);
                        }
                        os.write(initialSequence);
                        Thread.sleep(10L);
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((byte[])initialSequence));
                        }
                        if (rawMessageListener != null) {
                            rawMessageListener.notifySend(initialSequence);
                        }
                        os.write(initialSequence);
                        this.firstPacketSent = true;
                        LOGGER.info("Send initial sequence passed.");
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Send initial sequence failed.", (Throwable)ex);
                    }
                }
                this.sendBuffer.reset();
                SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)this.sendBuffer);
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)this.sendBuffer.toByteArray().length, (Object)ByteUtils.bytesToHex((byte[])this.sendBuffer.toByteArray()));
                }
                if (rawMessageListener != null) {
                    rawMessageListener.notifySend(this.sendBuffer.toByteArray());
                }
                os.write(this.sendBuffer.toByteArray());
                os.flush();
            }
            catch (Exception ex) {
                byte[] bytes = data.toByteArray();
                LOGGER.warn("Send message to output stream failed: [{}] - {}", (Object)data.size(), (Object)ByteUtils.bytesToHex((byte[])bytes));
                throw new RuntimeException("Send message to output stream failed: " + ByteUtils.bytesToHex((byte[])bytes), ex);
            }
            finally {
                this.sendBuffer.reset();
            }
        }
    }
}

