/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.purejavacomm;

import java.util.List;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.purejavacomm.PureJavaCommSerialConnector;
import org.bidib.jbidibc.serial.AbstractSerialBidib;
import org.bidib.jbidibc.serial.LineStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PureJavaCommSerialBidib
extends AbstractSerialBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(PureJavaCommSerialBidib.class);
    private PureJavaCommSerialConnector connector;

    private PureJavaCommSerialBidib() {
    }

    public static BidibInterface createInstance(Context context) {
        LOGGER.info("Create new instance of PureJavaCommSerialBidib.");
        PureJavaCommSerialBidib instance = new PureJavaCommSerialBidib();
        instance.initialize(context);
        return instance;
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize. Create the connector.");
        super.initialize(context);
        this.connector = new PureJavaCommSerialConnector();
        MessageReceiver serialMessageReceiver = this.getMessageReceiver();
        this.connector.setMessageReceiver(serialMessageReceiver);
        this.connector.setLineStatusListener(new LineStatusListener(){

            public void notifyLineStatusChanged(boolean ready, boolean manualEvent) {
                PureJavaCommSerialBidib.this.fireCtsChanged(ready, manualEvent);
            }
        });
        this.initializeConnector(this.connector);
    }

    public List<String> getPortIdentifiers() {
        return this.connector.getPortIdentifiers();
    }

    protected boolean isImplAvaiable() {
        return this.connector.isImplAvaiable();
    }

    protected void internalOpen(String portName, Context context) throws Exception {
        this.connector.internalOpen(portName, context);
    }

    public void close() {
        LOGGER.info("Close is called.");
        if (this.connector.close()) {
            super.close();
            this.cleanupAfterClose(this.getMessageReceiver());
        }
    }

    public boolean isOpened() {
        boolean isOpened = false;
        try {
            isOpened = this.connector.isOpened();
        }
        catch (Exception ex) {
            LOGGER.warn("The connector is not available.", (Throwable)ex);
        }
        return isOpened;
    }

    public void send(byte[] data) {
        this.connector.send(data);
    }

    protected AbstractBaseBidib<MessageReceiver> getConnector() {
        return this.connector;
    }
}

