/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.purejavacomm.debug;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.debug.AbstractDebugReader;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.LineEndingEnum;
import org.bidib.jbidibc.debug.exception.InvalidLibraryException;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class DebugReader
extends AbstractDebugReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReader.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"DEBUG_RAW");
    static final int DEFAULT_TIMEOUT = 300;
    private SerialPort port;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);
    private AtomicBoolean closeInProgress = new AtomicBoolean();
    private byte[] inputBuffer = new byte[2048];
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();

    public DebugReader(DebugMessageProcessor messageReceiver) {
        super(messageReceiver);
    }

    public void initialize() {
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
                LOGGER.debug("Process current CommPortIdentifier, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
                if (id.getPortType() == 1) {
                    portIdentifiers.add(id.getName());
                    continue;
                }
                LOGGER.debug("Skip port because no serial port, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }

    private SerialPort internalOpen(CommPortIdentifier commPort, int baudRate, Context context) throws PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        this.closeInProgress.set(false);
        this.startReceiveQueueWorker();
        LOGGER.info("Open the serial port: {}", (Object)commPort);
        SerialPort serialPort = (SerialPort)commPort.open(DebugReader.class.getName(), 2000);
        LOGGER.info("Open the serial port has passed: {}", (Object)commPort);
        this.getConnectionListener().opened(commPort.getName());
        LOGGER.info("Set flow control mode to SerialPort.FLOWCONTROL_NONE!");
        serialPort.setFlowControlMode(0);
        serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        this.clearInputStream(serialPort);
        this.getMessageReceiver().enable();
        serialPort.addEventListener(new SerialPortEventListener(){

            public void serialEvent(SerialPortEvent event) {
                LOGGER.trace("serialEvent received: {}", (Object)event);
                switch (event.getEventType()) {
                    case 1: {
                        try {
                            DebugReader.this.receive(DebugReader.this.port);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                        }
                        break;
                    }
                    case 2: {
                        LOGGER.info("The output buffer is empty.");
                        if (!MSG_RAW_LOGGER.isInfoEnabled()) break;
                        MSG_RAW_LOGGER.info(">> Notify output empty");
                        break;
                    }
                    case 6: {
                        LOGGER.warn("CD is signalled.");
                        break;
                    }
                    case 3: {
                        LOGGER.warn("The CTS value has changed, old value: {}, new value: {}", new Object[]{event.getOldValue(), event.getNewValue()});
                        if (event.getNewValue()) break;
                        LOGGER.warn("Close the port.");
                        DebugReader.this.closeInProgress.set(true);
                        Thread worker = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                LOGGER.info("Start close port because error was detected.");
                                try {
                                    DebugReader.this.close();
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Close after error failed.", (Throwable)ex);
                                }
                                LOGGER.warn("The port was closed.");
                                try {
                                    if (DebugReader.this.getConnectionListener() != null) {
                                        DebugReader.this.getConnectionListener().closed(DebugReader.this.getRequestedPortName());
                                    }
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Notify connection listener failed.", (Throwable)ex);
                                }
                            }
                        });
                        worker.start();
                        break;
                    }
                    default: {
                        LOGGER.warn("SerialPortEvent was triggered, type: {}, old value: {}, new value: {}", new Object[]{event.getEventType(), event.getOldValue(), event.getNewValue()});
                    }
                }
            }
        });
        serialPort.notifyOnDataAvailable(true);
        serialPort.notifyOnCTS(true);
        serialPort.notifyOnCarrierDetect(true);
        serialPort.notifyOnBreakInterrupt(true);
        serialPort.notifyOnDSR(true);
        serialPort.notifyOnOverrunError(true);
        try {
            LOGGER.info("Activate DTR.");
            serialPort.setDTR(true);
        }
        catch (Exception e) {
            LOGGER.warn("Set DTR true failed.", (Throwable)e);
        }
        try {
            LOGGER.info("Activate RTS.");
            serialPort.setRTS(true);
        }
        catch (Exception e) {
            LOGGER.warn("Set RTS true failed.", (Throwable)e);
        }
        return serialPort;
    }

    private void clearInputStream(SerialPort serialPort) {
        try {
            InputStream serialStream = serialPort.getInputStream();
            int count = serialStream.available();
            LOGGER.debug("input stream shows {} bytes available", (Object)count);
            while (count > 0) {
                serialStream.skip(count);
                count = serialStream.available();
            }
            LOGGER.debug("input stream shows {} bytes available after purge.", (Object)count);
        }
        catch (Exception e) {
            LOGGER.warn("Clear input stream failed.", (Throwable)e);
        }
    }

    public void close() {
        if (this.port != null) {
            LOGGER.debug("Close the port.");
            long start = System.currentTimeMillis();
            try {
                this.port.removeEventListener();
            }
            catch (Exception e) {
                LOGGER.warn("Remove event listener and set receive timeout failed.", (Throwable)e);
            }
            try {
                this.port.close();
            }
            catch (Exception e) {
                LOGGER.warn("Close port failed.", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            LOGGER.debug("Closed the port. duration: {}", (Object)(end - start));
            this.port = null;
            this.getMessageReceiver().disable();
            this.stopReceiveQueueWorker();
            try {
                if (this.getConnectionListener() != null) {
                    this.getConnectionListener().closed(this.getRequestedPortName());
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Notify connection listener failed.", (Throwable)ex);
            }
            this.setRequestedPortName(null);
        }
    }

    public boolean isOpened() {
        boolean isOpened = false;
        try {
            this.portSemaphore.acquire();
            LOGGER.debug("Check if port is opened: {}", (Object)this.port);
            isOpened = this.port != null && this.port.getOutputStream() != null;
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("OutputStream is not available.", (Throwable)ex);
        }
        finally {
            this.portSemaphore.release();
        }
        return isOpened;
    }

    public void open(String portName, int baudRate, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
        block16: {
            this.setConnectionListener(connectionListener);
            if (this.port == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}", (Object)portName);
                CommPortIdentifier commPort = null;
                try {
                    commPort = CommPortIdentifier.getPortIdentifier((String)portName);
                }
                catch (NoSuchPortException ex) {
                    LOGGER.warn("Requested port is not available: {}", (Object)portName, (Object)ex);
                    throw new PortNotFoundException(portName);
                }
                LOGGER.info("Set the requestedPortName: {}, baudRate: {}", (Object)portName, (Object)baudRate);
                this.setRequestedPortName(portName);
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.port = this.internalOpen(commPort, baudRate, context);
                        LOGGER.info("The port was opened internally.");
                        break block16;
                    }
                    catch (PortInUseException ex) {
                        LOGGER.warn("Open communication failed because port is in use.", (Throwable)ex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new PortNotOpenedException(portName, "portInUse");
                    }
                    catch (TooManyListenersException | UnsupportedCommOperationException ex) {
                        LOGGER.warn("Open communication failed because port has thrown an exception.", ex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    public void send(String message, LineEndingEnum lineEnding) {
        if (this.port != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)message);
                }
                OutputStream output = this.port.getOutputStream();
                output.write(message.getBytes());
                output.write(lineEnding.getValues());
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    public void send(byte[] content) {
        if (this.port != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)content.length, (Object)ByteUtils.bytesToHex((byte[])content));
                }
                OutputStream output = this.port.getOutputStream();
                output.write(content);
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(SerialPort port) {
        LOGGER.debug("Start receiving messages.");
        DebugReader debugReader = this;
        synchronized (debugReader) {
            LOGGER.debug("Starting message receiver.");
            try {
                InputStream input = null;
                if (port != null) {
                    input = port.getInputStream();
                }
                if (input != null) {
                    int len = input.read(this.inputBuffer);
                    if (len > 0) {
                        this.output.write(this.inputBuffer, 0, len);
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)this.output.size(), (Object)ByteUtils.bytesToHex((byte[])this.output.toByteArray()));
                        }
                        this.addDataToReceiveQueue(this.output);
                        if (this.output != null && this.output.size() > 0) {
                            LOGGER.warn("Data in output: {}", (Object)this.output.toString());
                        }
                    }
                } else {
                    LOGGER.error("No input available.");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

