/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.exception.NoAnswerException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialBidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerialBidib.class);
    protected Semaphore portSemaphore = new Semaphore(1);
    protected String requestedPortName;
    protected Object receiveLock = new Object();
    private AtomicBoolean isConnected = new AtomicBoolean();

    protected BidibMessageProcessor createMessageReceiver(NodeRegistry nodeRegistry) {
        return new SerialMessageReceiver(nodeRegistry);
    }

    protected void stopReceiverAndQueues(BidibMessageProcessor serialMessageReceiver) {
        if (serialMessageReceiver instanceof SerialMessageReceiver) {
            ((SerialMessageReceiver)serialMessageReceiver).disable();
        } else {
            LOGGER.warn("No message receiver to disable available.");
        }
        super.stopReceiverAndQueues(serialMessageReceiver);
    }

    protected void cleanupAfterClose(BidibMessageProcessor bidibMessageProcessor) {
        this.releaseRootNode();
        InvalidConfigurationException ice = null;
        if (bidibMessageProcessor instanceof SerialMessageReceiver) {
            SerialMessageReceiver serialMessageReceiver = (SerialMessageReceiver)bidibMessageProcessor;
            serialMessageReceiver.clearMessageListeners();
            serialMessageReceiver.clearNodeListeners();
            LOGGER.info("Purge the received data in the message buffer.");
            try {
                serialMessageReceiver.purgeReceivedDataInBuffer();
            }
            catch (InvalidConfigurationException ex) {
                LOGGER.warn("Purge output stream has signaled an error.", (Throwable)ex);
                if ("debug-interface-active".equals(ex.getReason())) {
                    ice = ex;
                }
            }
        } else {
            LOGGER.warn("No message receiver to purge received data buffer available.");
        }
        if (this.getConnectionListener() != null) {
            LOGGER.info("Notify that the port was closed: {}", (Object)this.requestedPortName);
            this.getConnectionListener().closed(this.requestedPortName);
        } else {
            LOGGER.info("No connection listener available to publish the closed report for port: {}", (Object)this.requestedPortName);
        }
        this.requestedPortName = null;
        super.cleanupAfterClose(bidibMessageProcessor);
        if (ice != null) {
            LOGGER.warn("Signal the invalid configuration exception to the caller.");
            throw ice;
        }
    }

    protected void startReceiverAndQueues(BidibMessageProcessor serialMessageReceiver, Context context) {
        super.startReceiverAndQueues(serialMessageReceiver, context);
        if (serialMessageReceiver instanceof SerialMessageReceiver) {
            ((SerialMessageReceiver)serialMessageReceiver).enable();
        } else {
            LOGGER.warn("No message receiver to enable available.");
        }
    }

    protected abstract boolean isImplAvaiable();

    protected abstract void internalOpen(String var1, Context var2) throws Exception;

    protected void notifyStatusKey(String messageKey) {
        if (this.getConnectionListener() != null) {
            this.getConnectionListener().status(messageKey);
        } else {
            LOGGER.info("No connection listener available.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        if (!this.isImplAvaiable()) {
            if (StringUtils.isBlank((CharSequence)portName)) {
                throw new PortNotFoundException("No portName to open provided!");
            }
            LOGGER.info("Open port with name: {}", (Object)portName);
            File file = new File(portName);
            if (file.exists()) {
                Boolean symlink = (Boolean)context.get("symlink", Boolean.class, (Object)Boolean.FALSE);
                if (!symlink.booleanValue()) {
                    try {
                        portName = file.getCanonicalPath();
                        LOGGER.info("Changed port name to: {}", (Object)portName);
                    }
                    catch (IOException ex) {
                        throw new PortNotFoundException(portName);
                    }
                } else {
                    LOGGER.info("Do not replace symlink name.");
                }
            }
            this.requestedPortName = portName;
            int[] baudRates = new int[]{115200, 19200};
            int baudRateIndex = 0;
            try {
                this.portSemaphore.acquire();
                while (baudRateIndex < baudRates.length) {
                    try {
                        this.close();
                        Integer baudRate = baudRates[baudRateIndex];
                        context.register("serial.baudrate", (Object)baudRate);
                        LOGGER.info("Try to connect with baudRate: {}", context.get("serial.baudrate"));
                        this.internalOpen(portName, context);
                        LOGGER.info("The port was opened internally, get the magic.");
                        this.contactInterface();
                        if (this.getConnectionListener() == null) return;
                        LOGGER.info("Notify that the port was opened: {}", (Object)this.requestedPortName);
                        this.getConnectionListener().opened(this.requestedPortName);
                        return;
                    }
                    catch (ProtocolNoAnswerException naex) {
                        LOGGER.warn("Open communication failed because the interface did not send an answer.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (baudRateIndex >= baudRates.length - 1) throw new NoAnswerException(naex.getMessage());
                        LOGGER.info("Try to connect with the next baudRate: {}", (Object)baudRates[++baudRateIndex]);
                        this.notifyStatusKey("bidib-reconnect-with-next-baudrate");
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException ie) {
                            LOGGER.warn("Wait to display status message was interrupted.", (Throwable)ie);
                        }
                    }
                    catch (NoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                            throw naex;
                        }
                        catch (Exception ie) {
                            // empty catch block
                        }
                        throw naex;
                    }
                    catch (PortNotFoundException pnfEx) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)pnfEx);
                        try {
                            this.close();
                            throw new PortNotOpenedException(portName, "portNotFound");
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "portNotFound");
                    }
                    catch (Exception e2) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                        try {
                            this.close();
                            throw new PortNotOpenedException(portName, "unknown");
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                    catch (UnsatisfiedLinkError err) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                        throw new PortNotOpenedException(portName, "unknown");
                        return;
                    }
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                throw new PortNotOpenedException(portName, "unknown");
            }
            finally {
                this.portSemaphore.release();
            }
        }
        LOGGER.warn("Port is already opened.");
    }

    protected boolean isConnected() {
        return this.isConnected.get();
    }

    protected void setConnected(boolean connected) {
        this.isConnected.set(connected);
    }

    public abstract boolean isOpened();

    protected int contactInterface() throws ProtocolException {
        int magic = this.sendResetAndMagic();
        LOGGER.info("The root node returned the magic: {}", (Object)ByteUtils.magicToHex((int)magic));
        return magic;
    }

    private int sendResetAndMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send sysDisable to the rootNode.");
        rootNode.sysDisable();
        try {
            LOGGER.info("Wait 300ms before send the magic request.");
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before send the magic request failed.", (Throwable)ex);
        }
        BidibMessageProcessor serialMessageReceiver = this.getMessageReceiver();
        if (serialMessageReceiver instanceof SerialMessageReceiver) {
            LOGGER.info("Enable the message receiver before send magic: {}", (Object)serialMessageReceiver);
            ((SerialMessageReceiver)serialMessageReceiver).enable();
        }
        LOGGER.info("Send the magic request.");
        int magic = rootNode.getMagic(Integer.valueOf(1500));
        LOGGER.debug("The node returned magic: {}", (Object)magic);
        return magic;
    }
}

