/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.bidib.jbidibc.core.MessageProcessor;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.message.BidibResponseFactory;
import org.bidib.jbidibc.core.message.ResponseFactory;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageReceiver
extends MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageReceiver.class);
    private ByteArrayOutputStream receiveBuffer = new ByteArrayOutputStream(2048);
    private SerialMessageParser messageParser = new SerialMessageParser();

    public SerialMessageReceiver(NodeRegistry nodeFactory) {
        super(nodeFactory, (ResponseFactory)new BidibResponseFactory(), true);
    }

    public void enable() {
        LOGGER.info("enable is called.");
        this.messageParser.setEscapeHot(false);
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        try {
            this.receiveBuffer.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        try {
            this.messageParser.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        MSG_RAW_LOGGER.info("++++ Disable the message receiver.");
        this.messageParser.setEscapeHot(false);
    }

    public String getErrorInformation() {
        if (this.receiveBuffer.size() > 0) {
            byte[] remaining = this.receiveBuffer.toByteArray();
            return new String(remaining);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReceivedDataInBuffer() {
        LOGGER.info("Purge the received data in the message buffer before get the lock.");
        LOGGER.info("Purge the received data in the message buffer. Current escapeHot: {}", (Object)this.messageParser.isEscapeHot());
        this.messageParser.setEscapeHot(false);
        if (this.receiveBuffer.size() > 0) {
            try {
                byte[] remaining = this.receiveBuffer.toByteArray();
                String remainingValue = new String(remaining, StandardCharsets.UTF_8);
                LOGGER.info("Cleared remaining data from message output buffer: {}, text: {}", (Object)ByteUtils.bytesToHex((byte[])remaining), (Object)remainingValue);
                if (remainingValue.indexOf("I=") > -1) {
                    InvalidConfigurationException ice = new InvalidConfigurationException("An active debug interface configuration was detected.");
                    ice.setReason("debug-interface-active");
                    throw ice;
                }
            }
            finally {
                this.receiveBuffer.reset();
            }
            LOGGER.info("Finished purge output stream.");
        } else {
            LOGGER.info("The message buffer is empty.");
        }
    }

    public void receive(ByteArrayOutputStream data) {
        if (!this.running.get()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            try {
                byte[] rawdata = data.toByteArray();
                LOGGER.info("Receiver is stopped, number of bytes read: {}, buffer: {}", (Object)rawdata.length, (Object)ByteUtils.bytesToHex((byte[])rawdata));
            }
            catch (Exception ex) {
                LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
            }
            return;
        }
        MSG_RAW_LOGGER.info("<<<< start parse input");
        try {
            byte[] rawdata = data.toByteArray();
            this.parseInput(rawdata, rawdata.length);
        }
        catch (Exception e) {
            LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
            if (this.messageParser.isEscapeHot()) {
                LOGGER.warn("Reset the escapeHot to false.");
                this.messageParser.setEscapeHot(false);
            }
            throw new RuntimeException(e);
        }
        finally {
            MSG_RAW_LOGGER.info("<<<< finished parse input");
        }
    }

    protected void parseInput(byte[] receivedData, int len) throws ProtocolException {
        this.messageParser.parseInput((MessageProcessor)this, receivedData, len);
    }
}

