/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.core.MessageProcessor;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageParser.class);
    protected static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private ByteArrayOutputStream receiveBuffer = new ByteArrayOutputStream(2048);
    private boolean escapeHot;

    public boolean isEscapeHot() {
        return this.escapeHot;
    }

    public void setEscapeHot(boolean escapeHot) {
        this.escapeHot = escapeHot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ByteArrayOutputStream byteArrayOutputStream = this.receiveBuffer;
        synchronized (byteArrayOutputStream) {
            MSG_RAW_LOGGER.info("Reset the receiveBuffer in SerialMessageParser.");
            this.receiveBuffer.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseInput(MessageProcessor messageProcessor, byte[] receivedData, int len) throws ProtocolException {
        if (receivedData != null) {
            int data = 0;
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)len, (Object)ByteUtils.bytesToHex((byte[])receivedData, (int)len));
            ByteArrayOutputStream byteArrayOutputStream = this.receiveBuffer;
            synchronized (byteArrayOutputStream) {
                for (int index = 0; index < len; ++index) {
                    data = receivedData[index] & 0xFF;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("received data: {}", (Object)ByteUtils.byteToHex((int)data));
                    }
                    if (data == 254) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Received complete raw message: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.receiveBuffer));
                        }
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info("<< [{}] - {}", (Object)this.receiveBuffer.size(), (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.receiveBuffer));
                        }
                        try {
                            messageProcessor.processMessages(this.receiveBuffer);
                        }
                        catch (ProtocolException ex) {
                            LOGGER.warn("Process messages failed.", (Throwable)ex);
                            this.escapeHot = false;
                        }
                        continue;
                    }
                    if (data == 253) {
                        this.escapeHot = true;
                        continue;
                    }
                    if (this.escapeHot) {
                        data ^= 0x20;
                        this.escapeHot = false;
                    }
                    this.receiveBuffer.write(ByteUtils.getLowByte((int)data));
                }
                if (this.receiveBuffer.size() > 0 && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Data remaining in output: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)this.receiveBuffer));
                }
            }
        } else {
            LOGGER.error("No input available.");
        }
    }
}

