package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicInteger;

import org.bidib.jbidibc.core.AbstractRawMessageReceiver;
import org.bidib.jbidibc.core.MessageProcessor;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerialMessageParserTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageParserTest.class);

    @Test
    public void parseInputTest() throws ProtocolException {

        final AtomicInteger calledCounter = new AtomicInteger();

        final MessageProcessor messageProcessor = new AbstractRawMessageReceiver(true) {

            @Override
            public void receive(ByteArrayOutputStream data) {

            }

            @Override
            protected void processMessage(byte[] messageArray) throws ProtocolException {
                LOGGER.info("Process messages: {}", ByteUtils.bytesToHex(messageArray));
                calledCounter.incrementAndGet();
            }
        };

        final SerialMessageParser parser = new SerialMessageParser();

        // 09.02.2020 10:15:07.731: [SerialPundit DataLooper for handle 3952 and port COM5] - <<<< Serial data
        // available, len: 25, data: 0A 01 00 3A 93 03 31 32 33 01 30 E7 FE 09 01 00 3B BA 01 01 04 00 00 FA FE

        final byte[] receivedData =
            new byte[] { 0x0A, 0x01, 0x00, 0x3A, (byte) 0x93, 0x03, 0x31, 0x32, 0x33, 0x01, 0x30, (byte) 0xE7,
                (byte) 0xFE, 0x09, 0x01, 0x00, 0x3B, (byte) 0xBA, 0x01, 0x01, 0x04, 0x00, 0x00, (byte) 0xFA,
                (byte) 0xFE };
        int len = receivedData.length;

        parser.parseInput(messageProcessor, receivedData, len);

        Assert.assertEquals(calledCounter.get(), 2);

    }
}
