/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial.raw;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.bidib.jbidibc.core.AbstractRawMessageReceiver;
import org.bidib.jbidibc.core.MessageProcessor;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.message.BidibMessageInterface;
import org.bidib.jbidibc.core.message.BidibResponseFactory;
import org.bidib.jbidibc.core.message.ResponseFactory;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageParser;
import org.bidib.jbidibc.serial.raw.MessagePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialRawMessageReceiver
extends AbstractRawMessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialRawMessageReceiver.class);
    protected static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private ByteArrayOutputStream receiveBuffer = new ByteArrayOutputStream(2048);
    private SerialMessageParser messageParser;
    private ResponseFactory responseFactory;
    private final MessagePublisher toHostPublisher;

    public SerialRawMessageReceiver(boolean checkCRC, MessagePublisher toHostPublisher) {
        super(checkCRC);
        this.toHostPublisher = toHostPublisher;
    }

    public void init() {
        this.createMessageParser();
        this.responseFactory = new BidibResponseFactory();
        this.responseFactory.initialize();
        super.init();
    }

    protected void createMessageParser() {
        LOGGER.info("Create the serial message parser.");
        this.messageParser = new SerialMessageParser();
    }

    public void enable() {
        LOGGER.info("enable is called.");
        this.messageParser.setEscapeHot(false);
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        try {
            this.receiveBuffer.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        try {
            this.messageParser.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        MSG_RAW_LOGGER.info("++++ Disable the message receiver.");
        this.messageParser.setEscapeHot(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReceivedDataInBuffer() {
        LOGGER.info("Purge the received data in the message buffer before get the lock.");
        LOGGER.info("Purge the received data in the message buffer. Current escapeHot: {}", (Object)this.messageParser.isEscapeHot());
        this.messageParser.setEscapeHot(false);
        if (this.receiveBuffer.size() > 0) {
            try {
                byte[] remaining = this.receiveBuffer.toByteArray();
                String remainingValue = new String(remaining, StandardCharsets.UTF_8);
                LOGGER.info("Cleared remaining data from message output buffer: {}, text: {}", (Object)ByteUtils.bytesToHex((byte[])remaining), (Object)remainingValue);
                if (remainingValue.indexOf("I=") > -1) {
                    InvalidConfigurationException ice = new InvalidConfigurationException("An active debug interface configuration was detected.");
                    ice.setReason("debug-interface-active");
                    throw ice;
                }
            }
            finally {
                this.receiveBuffer.reset();
            }
            LOGGER.info("Finished purge output stream.");
        } else {
            LOGGER.info("The message buffer is empty.");
        }
    }

    public void receive(ByteArrayOutputStream data) {
        if (!this.isEnabled()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            try {
                byte[] rawdata = data.toByteArray();
                LOGGER.info("Receiver is stopped, number of bytes read: {}, buffer: {}", (Object)rawdata.length, (Object)ByteUtils.bytesToHex((byte[])rawdata));
            }
            catch (Exception ex) {
                LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
            }
            return;
        }
        MSG_RAW_LOGGER.info("<<<< start parse input");
        try {
            byte[] rawdata = data.toByteArray();
            this.parseInput(rawdata, rawdata.length);
        }
        catch (Exception e) {
            LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
            if (this.messageParser.isEscapeHot()) {
                LOGGER.warn("Reset the escapeHot to false.");
                this.messageParser.setEscapeHot(false);
            }
            throw new RuntimeException(e);
        }
        finally {
            MSG_RAW_LOGGER.info("<<<< finished parse input");
        }
    }

    protected void parseInput(byte[] receivedData, int len) throws ProtocolException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Parse input, len: {}, data: {}", (Object)len, (Object)ByteUtils.bytesToHex((byte[])receivedData));
        }
        this.messageParser.parseInput((MessageProcessor)this, receivedData, len);
    }

    protected void processMessage(byte[] messageArray) throws ProtocolException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Publish the message to the host publisher: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray));
        }
        BidibMessageInterface bidibMessage = this.responseFactory.createRaw(messageArray);
        this.toHostPublisher.publishMessage(bidibMessage);
    }
}

