/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.bidib.jbidibc.core.LcConfigX;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.enumeration.BoosterState;
import org.bidib.jbidibc.core.enumeration.OccupationState;
import org.bidib.jbidibc.core.enumeration.SysErrorEnum;
import org.bidib.jbidibc.core.message.BidibMessage;
import org.bidib.jbidibc.core.message.BidibResponseFactory;
import org.bidib.jbidibc.core.message.LcConfigXResponse;
import org.bidib.jbidibc.core.message.ResponseFactory;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerialMessageReceiverTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageReceiverTest.class);

    private ByteArrayOutputStream pack(byte[] data) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(data);
        return output;
    }

    private SerialMessageReceiver createSerialMessageReceiver(NodeRegistry nodeFactory) {
        BidibResponseFactory responseFactory = new BidibResponseFactory();
        responseFactory.initialize();
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory, (ResponseFactory)responseFactory);
        return receiver;
    }

    @Test
    public void receiveMessageTest() throws IOException {
        byte[] address = new byte[]{0};
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] data = new byte[]{5, 0, 1, -122, 2, 0, 70, -2};
        Mockito.when((Object)nodeFactory.findNode(address)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)1);
        receiver.receive(this.pack(data));
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).error(address, 2, address);
    }

    @Test
    public void receiveMessageLeadingMagicTest() throws IOException {
        byte[] address = new byte[]{0};
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] data = new byte[]{-2, 5, 0, 1, -122, 2, 0, 70, -2};
        Mockito.when((Object)nodeFactory.findNode(address)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)1);
        receiver.receive(this.pack(data));
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).error(address, 2, address);
    }

    @Test
    public void receiveMessageAddrStackTest() throws IOException {
        byte[] address = new byte[]{1, 2, 3};
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] data = new byte[]{11, 1, 2, 3, 0, 1, -122, SysErrorEnum.BIDIB_ERR_ADDRSTACK.getType(), 1, 2, 3, 4, 86, -2};
        Mockito.when((Object)nodeFactory.findNode(address)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)1);
        receiver.receive(this.pack(data));
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).error(address, (int)SysErrorEnum.BIDIB_ERR_ADDRSTACK.getType(), new byte[]{1, 2, 3, 4});
    }

    @Test
    public void receiveFeedbackMultipleResponseOccupiedTest() throws IOException {
        byte[] address = new byte[]{2};
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] data = new byte[]{14, 2, 0, 72, -94, 0, 64, -1, -1, -1, -1, -1, -1, -1, -1, 27, -2};
        Mockito.when((Object)nodeFactory.findNode(address)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)72);
        receiver.receive(this.pack(data));
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.never())).occupation(address, 2, OccupationState.FREE, null);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).occupation(address, 2, OccupationState.OCCUPIED, null);
    }

    @Test
    public void receiveFeedbackMultipleResponseFreeTest() throws IOException {
        byte[] address = new byte[]{2};
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] data = new byte[]{14, 2, 0, 72, -94, 0, -128, 0, -1, -1, -1, -1, -1, -1, -1, -79, -2};
        Mockito.when((Object)nodeFactory.findNode(address)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)72);
        receiver.receive(this.pack(data));
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.never())).occupation(address, 2, OccupationState.OCCUPIED, null);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).occupation(address, 0, OccupationState.FREE, null);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).occupation(address, 2, OccupationState.FREE, null);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).occupation(address, 7, OccupationState.FREE, null);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).occupation(address, 8, OccupationState.OCCUPIED, null);
    }

    @Test
    public void receive2MessagesTest() throws IOException, ProtocolException {
        BidibMessageInterface featureResponse1 = new BidibResponseFactory().create(new byte[]{6, 1, 0, 14, -112, 0, 32});
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] data = new byte[]{6, 1, 0, 14, -112, 0, 32, -89, -2, 6, 1, 0, 15, -112, 0, 32, 40, -2};
        byte[] nodeAddress = new byte[]{1};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)15);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum(featureResponse1)).thenReturn((Object)14);
        receiver.receive(this.pack(data));
        Mockito.verifyNoInteractions((Object[])new Object[]{messageListener});
    }

    @Test
    public void receiveBoostStatResponseTest() throws IOException {
        byte[] address = new byte[]{0};
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] data = new byte[]{4, 0, 58, -80, 6, 116, -2};
        byte[] nodeAddress = new byte[]{0};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)58);
        receiver.receive(this.pack(data));
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.never())).boosterState(address, BoosterState.ON);
    }

    @Test
    public void receiveNodeTabResponseTest() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] message = new byte[]{13, 1, 0, 2, -119, 1, 0, -127, 0, 13, 114, 0, 31, 0, -2};
        byte[] nodeAddress = new byte[]{1};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)2);
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(message));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response);
    }

    @Test
    public void receiveMagicResponseTest() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{5, 0, 0, -127, -3, -34, -81, -119, -2};
        byte[] message = new byte[]{5, 0, 0, -127, -2, -81};
        byte[] nodeAddress = new byte[]{0};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)0);
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.never())).offer(response);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).sysMagic((byte[])Mockito.eq((Object)nodeAddress), Mockito.eq((int)45054));
    }

    @Test
    public void receiveMagicResponses2PartsTest() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage1 = new byte[]{5, 0, 0, -127, -3, -34, -81, -119, -2, 5, 0, 1, -127};
        byte[] rawmessage2 = new byte[]{-3, -34, -81, 6, -2};
        byte[] message = new byte[]{5, 0, 0, -127, -2, -81};
        byte[] nodeAddress = new byte[]{0};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)0, (Object[])new Integer[]{1});
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage1));
        BidibMessageInterface response1 = new BidibResponseFactory().create(message);
        receiver.receive(this.pack(rawmessage2));
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.never())).offer(response1);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)2))).sysMagic((byte[])Mockito.eq((Object)nodeAddress), Mockito.eq((int)45054));
    }

    @Test
    public void receiveMagicResponses2PartsWithEscapeTest() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage1 = new byte[]{7, 1, 0, -81, -71, 19, -3};
        byte[] rawmessage2 = new byte[]{-35, -1, 56, -2};
        byte[] message = new byte[]{7, 1, 0, -81, -71, 19, -3, -1, 56, -2};
        byte[] nodeAddress = new byte[]{1};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)175, (Object[])new Integer[]{1});
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        BidibMessageInterface response1 = new BidibResponseFactory().create(message);
        receiver.receive(this.pack(rawmessage1));
        receiver.receive(this.pack(rawmessage2));
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response1);
    }

    @Test
    public void receiveLcMacroParaResponseTest() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{10, 1, 0, 46, -54, 2, 3, 63, -65, 127, -1, -61, -2};
        byte[] message = new byte[]{10, 1, 0, 46, -54, 2, 3, 63, -65, 127, -1};
        byte[] nodeAddress = new byte[]{1};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)46);
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response);
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)202));
    }

    @Test
    public void receiveLcMacroResponseTest() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{10, 1, 0, 45, -55, 2, 3, 0, 15, -1, -1, 0, -2};
        byte[] message = new byte[]{10, 1, 0, 45, -55, 2, 3, 0, 15, -1, -1};
        byte[] nodeAddress = new byte[]{1};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)45);
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response);
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)201));
    }

    @Test
    public void receiveLcConfigXResponseTest() throws IOException, ProtocolException {
        byte[] nodeAddress = new byte[]{1};
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{14, 1, 0, 21, -58, 1, 3, 4, 2, 3, 6, 2, 0, 1, -3, -34, 73, -2};
        byte[] message = new byte[]{14, 1, 0, 21, -58, 1, 3, 4, 2, 3, 6, 2, 0, 1, -2};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)21);
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        Assert.assertTrue((boolean)(response instanceof LcConfigXResponse));
        LcConfigXResponse lcConfigXResponse = (LcConfigXResponse)response;
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).lcConfigX(nodeAddress, lcConfigXResponse.getLcConfigX());
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)198));
    }

    @Test
    public void receiveAccessoryParaResponseTest() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{9, 1, 0, 113, -71, 0, -3, -35, 0, 1, -1, 46, -2};
        byte[] message = new byte[]{9, 1, 0, 113, -71, 0, -3, 0, 1, -1};
        byte[] nodeAddress = new byte[]{1};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)113);
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response);
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)185));
    }

    @Test
    public void receiveAccessoryParaResponse2Test() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{7, 2, 0, -47, -71, 7, -4, -3, -34, -3, -34, -2};
        byte[] message = new byte[]{7, 2, 0, -47, -71, 7, -4, -2};
        byte[] nodeAddress = new byte[]{2};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)209);
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response);
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)185));
    }

    @Test
    public void receive3Test() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{8, 3, 0, 23, -58, 0, 0, 0, 0, 8, 3, 0, 24, -58, 0, 1, 0, 0, 8, 3, 0, 25, -58, 0, 2, 0, 0, 8, 3, 0, 26, -58, 0, 3, 0, 0, 8, 3, 0, 27, -58, 0, 4, 0, 0, 8, 3, 0, 28, -58, 0, 5, 0, 0, 8, 3, 0, 29, -58, 0, 6, 0, 0, -15, -2};
        byte[] message = new byte[]{8, 3, 0, 23, -58, 0, 0, 0, 0};
        byte[] nodeAddress = new byte[]{3};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)23, (Object[])new Integer[]{24, 25, 26, 27, 28, 29});
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)7))).lcConfigX((byte[])Mockito.eq((Object)nodeAddress), (LcConfigX)Mockito.any());
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)198));
    }

    @Test
    public void receive4Test() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{8, 3, 0, 30, -58, 0, 7, 0, 0, 8, 3, 0, 31, -58, 0, 8, 0, 0, 8, 3, 0, 32, -58, 0, 9, 0, 0, 8, 3, 0, 33, -58, 0, 10, 0, 0, 8, 3, 0, 34, -58, 0, 11, 0, 0, 8, 3, 0, 35, -58, 0, 12, 0, 0, 8, 3, 0, 36, -58, 0, 13, 0, 0, -11, -2};
        byte[] message = new byte[]{8, 3, 0, 23, -58, 0, 0, 0, 0};
        byte[] nodeAddress = new byte[]{3};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)30, (Object[])new Integer[]{31, 32, 33, 34, 35, 36});
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)7))).lcConfigX((byte[])Mockito.eq((Object)nodeAddress), (LcConfigX)Mockito.any());
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)198));
    }

    @Test
    public void receive5Test() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{8, 3, 0, 37, -58, 0, 14, 0, 0, 8, 3, 0, 38, -58, 0, 15, 0, 0, -38, -2};
        byte[] message = new byte[]{8, 3, 0, 23, -58, 0, 0, 0, 0};
        byte[] nodeAddress = new byte[]{3};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)37, (Object[])new Integer[]{38});
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response = new BidibResponseFactory().create(message);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)2))).lcConfigX((byte[])Mockito.eq((Object)nodeAddress), (LcConfigX)Mockito.any());
        Assert.assertEquals((byte)response.getType(), (byte)ByteUtils.getLowByte((int)198));
    }

    @Test
    public void receive6Test() throws IOException, ProtocolException {
        NodeRegistry nodeFactory = (NodeRegistry)Mockito.mock(NodeRegistry.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        final BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = this.createSerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        receiver.init();
        byte[] rawmessage = new byte[]{7, 2, 1, 0, 2, -112, -3, -34, 0, 7, 2, 1, 0, 3, -112, -4, 24, 65, -2, 7, 2, 1, 0, 4, -112, 0, 0, -69, -2, 7, 2, 1, 0, 5, -112, 1, 1, -82, -2};
        byte[] message0 = new byte[]{7, 2, 1, 0, 2, -112, -2, 0};
        byte[] message1 = new byte[]{7, 2, 1, 0, 3, -112, -4, 24};
        byte[] message2 = new byte[]{7, 2, 1, 0, 4, -112, 0, 0};
        byte[] message3 = new byte[]{7, 2, 1, 0, 5, -112, 1, 1};
        byte[] nodeAddress = new byte[]{2, 1};
        Mockito.when((Object)nodeFactory.findNode(nodeAddress)).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessageInterface)Mockito.any(BidibMessage.class))).thenReturn((Object)2, (Object[])new Integer[]{3, 4, 5});
        ((BidibNode)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                LOGGER.info("addResponseToReceiveQueue is called with args: {}", args);
                receiveQueue.offer((BidibMessage)args[0]);
                return null;
            }
        }).when((Object)bidibNode)).addResponseToReceiveQueue((BidibMessageInterface)Mockito.any(BidibMessage.class));
        receiver.receive(this.pack(rawmessage));
        BidibMessageInterface response0 = new BidibResponseFactory().create(message0);
        BidibMessageInterface response1 = new BidibResponseFactory().create(message1);
        BidibMessageInterface response2 = new BidibResponseFactory().create(message2);
        BidibMessageInterface response3 = new BidibResponseFactory().create(message3);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response0);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response1);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response2);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response3);
        Assert.assertEquals((byte)response0.getType(), (byte)ByteUtils.getLowByte((int)144));
    }
}

