/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import gnu.io.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.bidib.jbidibc.MessageReceiver;
import org.bidib.jbidibc.node.NodeFactory;
import org.bidib.jbidibc.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageReceiver
extends MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageReceiver.class);
    private ByteArrayOutputStream output;

    protected SerialMessageReceiver(NodeFactory nodeFactory) {
        super(nodeFactory);
    }

    public String getErrorInformation() {
        if (this.output != null && this.output.size() > 0) {
            byte[] remaining = this.output.toByteArray();
            return new String(remaining);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(SerialPort port) {
        LOGGER.debug("Start receiving messages.");
        SerialMessageReceiver serialMessageReceiver = this;
        synchronized (serialMessageReceiver) {
            LOGGER.debug("Starting message receiver.");
            try {
                this.output = new ByteArrayOutputStream();
                InputStream input = null;
                if (port != null) {
                    input = port.getInputStream();
                }
                if (input != null) {
                    int data = 0;
                    boolean escapeHot = false;
                    StringBuilder logRecord = new StringBuilder();
                    while (this.running.get() && (data = input.read()) != -1) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("received data: {}", (Object)ByteUtils.byteToHex((int)data));
                        }
                        logRecord.append(ByteUtils.byteToHex((int)data)).append(" ");
                        if (data == 254 && this.output.size() > 0) {
                            LOGGER.debug("Received raw message: {}", (Object)logRecord);
                            if (MSG_RAW_LOGGER.isInfoEnabled()) {
                                MSG_RAW_LOGGER.info("<< {}", (Object)logRecord);
                            }
                            logRecord.setLength(0);
                            this.processMessages(this.output);
                            continue;
                        }
                        if (data == 253) {
                            escapeHot = true;
                            continue;
                        }
                        if (data == 254) continue;
                        if (escapeHot) {
                            data ^= 0x20;
                            escapeHot = false;
                        }
                        this.output.write((byte)data);
                    }
                    LOGGER.debug("Leaving receive loop, RUNNING: {}", (Object)this.running);
                    if (this.output != null && this.output.size() > 0) {
                        byte[] remaining = this.output.toByteArray();
                        String remainingString = ByteUtils.bytesToHex((byte[])remaining);
                        LOGGER.warn("Data remaining in output: {}", (Object)remainingString);
                    }
                    if (logRecord != null && logRecord.length() > 0) {
                        LOGGER.warn("Data remaining in logRecord: {}", (Object)logRecord);
                    }
                } else {
                    LOGGER.error("No input available.");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

