/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import gnu.io.SerialPort;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.Node;
import org.bidib.jbidibc.core.enumeration.BoosterState;
import org.bidib.jbidibc.core.enumeration.SysErrorEnum;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.message.BidibMessage;
import org.bidib.jbidibc.core.message.ResponseFactory;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.NodeFactory;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

public class MessageReceiverTest {
    @Test
    public void receiveMessageTest() throws IOException {
        byte[] address = new byte[]{0};
        NodeFactory nodeFactory = (NodeFactory)Mockito.mock(NodeFactory.class);
        SerialPort serialPort = (SerialPort)Mockito.mock(SerialPort.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{5, 0, 1, -122, 2, 0, 70, -2});
        Mockito.when((Object)serialPort.getInputStream()).thenReturn((Object)is);
        Mockito.when((Object)nodeFactory.getNode((Node)Mockito.any(Node.class))).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessage)Mockito.any(BidibMessage.class))).thenReturn((Object)1);
        receiver.receive(serialPort);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).error(address, 2, address);
    }

    @Test
    public void receiveMessageAddrStackTest() throws IOException {
        byte[] address = new byte[]{1, 2, 3};
        NodeFactory nodeFactory = (NodeFactory)Mockito.mock(NodeFactory.class);
        SerialPort serialPort = (SerialPort)Mockito.mock(SerialPort.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{11, 1, 2, 3, 0, 1, -122, SysErrorEnum.BIDIB_ERR_ADDRSTACK.getType(), 1, 2, 3, 4, 86, -2});
        Mockito.when((Object)serialPort.getInputStream()).thenReturn((Object)is);
        Mockito.when((Object)nodeFactory.getNode((Node)Mockito.any(Node.class))).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessage)Mockito.any(BidibMessage.class))).thenReturn((Object)1);
        receiver.receive(serialPort);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).error(address, (int)SysErrorEnum.BIDIB_ERR_ADDRSTACK.getType(), new byte[]{1, 2, 3, 4});
    }

    @Test
    public void receiveFeedbackMultipleResponseOccupiedTest() throws IOException {
        byte[] address = new byte[]{1};
        NodeFactory nodeFactory = (NodeFactory)Mockito.mock(NodeFactory.class);
        SerialPort serialPort = (SerialPort)Mockito.mock(SerialPort.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{-2, 22, 1, 0, 6, -94, 0, -128, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2});
        Mockito.when((Object)serialPort.getInputStream()).thenReturn((Object)is);
        Mockito.when((Object)nodeFactory.getNode((Node)Mockito.any(Node.class))).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessage)Mockito.any(BidibMessage.class))).thenReturn((Object)6);
        receiver.receive(serialPort);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.never())).free(address, 2);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).occupied(address, 2);
    }

    @Test
    public void receiveFeedbackMultipleResponseFreeTest() throws IOException {
        byte[] address = new byte[]{1};
        NodeFactory nodeFactory = (NodeFactory)Mockito.mock(NodeFactory.class);
        SerialPort serialPort = (SerialPort)Mockito.mock(SerialPort.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{-2, 22, 1, 0, 6, -94, 0, -128, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2});
        Mockito.when((Object)serialPort.getInputStream()).thenReturn((Object)is);
        Mockito.when((Object)nodeFactory.getNode((Node)Mockito.any(Node.class))).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessage)Mockito.any(BidibMessage.class))).thenReturn((Object)6);
        receiver.receive(serialPort);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.never())).occupied(address, 2);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).free(address, 0);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).free(address, 2);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).free(address, 7);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.times((int)1))).occupied(address, 8);
    }

    @Test
    public void receive2MessagesTest() throws IOException, ProtocolException {
        BidibMessage featureResponse1 = ResponseFactory.create((byte[])new byte[]{6, 1, 0, 14, -112, 0, 32});
        NodeFactory nodeFactory = (NodeFactory)Mockito.mock(NodeFactory.class);
        SerialPort serialPort = (SerialPort)Mockito.mock(SerialPort.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{6, 1, 0, 14, -112, 0, 32, -89, -2, 6, 1, 0, 15, -112, 0, 32, 40, -2});
        Mockito.when((Object)serialPort.getInputStream()).thenReturn((Object)is);
        Mockito.when((Object)nodeFactory.getNode((Node)Mockito.any(Node.class))).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessage)Mockito.any(BidibMessage.class))).thenReturn((Object)15);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum(featureResponse1)).thenReturn((Object)14);
        Mockito.when((Object)bidibNode.getReceiveQueue()).thenReturn((Object)receiveQueue);
        receiver.receive(serialPort);
        Mockito.verifyZeroInteractions((Object[])new Object[]{messageListener});
    }

    @Test
    public void receiveBoostStatResponseTest() throws IOException {
        byte[] address = new byte[]{0};
        NodeFactory nodeFactory = (NodeFactory)Mockito.mock(NodeFactory.class);
        SerialPort serialPort = (SerialPort)Mockito.mock(SerialPort.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{4, 0, 58, -80, 6, 116, -2});
        Mockito.when((Object)serialPort.getInputStream()).thenReturn((Object)is);
        Mockito.when((Object)nodeFactory.getNode((Node)Mockito.any(Node.class))).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessage)Mockito.any(BidibMessage.class))).thenReturn((Object)58);
        receiver.receive(serialPort);
        ((MessageListener)Mockito.verify((Object)messageListener, (VerificationMode)Mockito.never())).boosterState(address, BoosterState.ON);
    }

    @Test
    public void receiveNodeTabResponseTest() throws IOException, ProtocolException {
        NodeFactory nodeFactory = (NodeFactory)Mockito.mock(NodeFactory.class);
        SerialPort serialPort = (SerialPort)Mockito.mock(SerialPort.class);
        BidibNode bidibNode = (BidibNode)Mockito.mock(BidibNode.class);
        MessageListener messageListener = (MessageListener)Mockito.mock(MessageListener.class);
        BlockingQueue receiveQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        SerialMessageReceiver receiver = new SerialMessageReceiver(nodeFactory);
        receiver.addMessageListener(messageListener);
        byte[] message = new byte[]{13, 1, 0, 2, -119, 1, 0, -127, 0, 13, 114, 0, 31, 0, -2};
        ByteArrayInputStream is = new ByteArrayInputStream(message);
        Mockito.when((Object)serialPort.getInputStream()).thenReturn((Object)is);
        Mockito.when((Object)nodeFactory.getNode((Node)Mockito.any(Node.class))).thenReturn((Object)bidibNode);
        Mockito.when((Object)bidibNode.getNextReceiveMsgNum((BidibMessage)Mockito.any(BidibMessage.class))).thenReturn((Object)2);
        Mockito.when((Object)bidibNode.getReceiveQueue()).thenReturn((Object)receiveQueue);
        receiver.receive(serialPort);
        BidibMessage response = ResponseFactory.create((byte[])message);
        ((BlockingQueue)Mockito.verify((Object)receiveQueue, (VerificationMode)Mockito.times((int)1))).offer(response);
    }
}

