/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.Semaphore;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.NoAnswerException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeFactory;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.core.utils.LogFileAnalyzer;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.bidib.jbidibc.serial.exception.InvalidLibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bidib.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private SerialPort port;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);
    private String logFile;
    private static Bidib INSTANCE;
    private String requestedPortName;

    private Bidib() {
    }

    protected BidibMessageProcessor createMessageReceiver(NodeFactory nodeFactory) {
        return new SerialMessageReceiver(nodeFactory);
    }

    private SerialMessageReceiver getSerialMessageReceiver() {
        return (SerialMessageReceiver)this.getMessageReceiver();
    }

    public static synchronized BidibInterface getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Bidib();
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    public void close() {
        if (this.port != null) {
            LOGGER.debug("Close the port.");
            long start = System.currentTimeMillis();
            this.getSerialMessageReceiver().disable();
            try {
                this.port.removeEventListener();
                this.port.enableReceiveTimeout(200);
            }
            catch (UnsupportedCommOperationException e) {
            }
            catch (Exception e) {
                LOGGER.warn("Remove event listener and set receive timeout failed.", (Throwable)e);
            }
            try {
                this.port.close();
            }
            catch (Exception e) {
                LOGGER.warn("Close port failed.", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            LOGGER.debug("Closed the port. duration: {}", (Object)(end - start));
            this.port = null;
            if (this.getNodeFactory() != null) {
                this.getNodeFactory().reset();
            }
            if (this.getMessageReceiver() != null) {
                this.getSerialMessageReceiver().clearMessageListeners();
                this.getSerialMessageReceiver().clearNodeListeners();
            }
            if (this.getConnectionListener() != null) {
                this.getConnectionListener().closed(this.requestedPortName);
            }
            this.requestedPortName = null;
        }
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
                LOGGER.debug("Process current CommPortIdentifier, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
                if (id.getPortType() == 1) {
                    portIdentifiers.add(id.getName());
                    continue;
                }
                LOGGER.debug("Skip port because no serial port, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }

    private void clearInputStream(SerialPort serialPort) {
        try {
            InputStream serialStream = serialPort.getInputStream();
            int count = serialStream.available();
            LOGGER.debug("input stream shows {} bytes available", (Object)count);
            while (count > 0) {
                serialStream.skip(count);
                count = serialStream.available();
            }
            LOGGER.debug("input stream shows {} bytes available after purge.", (Object)count);
        }
        catch (Exception e) {
            LOGGER.warn("Clear input stream failed.", (Throwable)e);
        }
    }

    private SerialPort internalOpen(CommPortIdentifier commPort, int baudRate, Context context) throws PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        RXTXPort serialPort = commPort.open(Bidib.class.getName(), 2000);
        LOGGER.info("Set flow control mode to SerialPort.FLOWCONTROL_RTSCTS_IN | SerialPort.FLOWCONTROL_RTSCTS_OUT!");
        serialPort.setFlowControlMode(3);
        serialPort.enableReceiveTimeout(300);
        serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        this.clearInputStream((SerialPort)serialPort);
        serialPort.notifyOnCTS(true);
        if (context != null) {
            Boolean ignoreWrongMessageNumber = (Boolean)context.get("ignoreWrongReceiveMessageNumber", Boolean.class, (Object)Boolean.FALSE);
            this.getSerialMessageReceiver().setIgnoreWrongMessageNumber(ignoreWrongMessageNumber);
        }
        try {
            LOGGER.info("Activate DTR.");
            serialPort.setDTR(true);
        }
        catch (Exception e) {
            LOGGER.warn("Set DTR true failed.", (Throwable)e);
        }
        this.getSerialMessageReceiver().enable();
        serialPort.addEventListener(new SerialPortEventListener(){
            {
                if (Bidib.this.logFile != null) {
                    LOGGER.warn("Logfile is set: {}", (Object)Bidib.this.logFile);
                    try {
                        new LogFileAnalyzer(new File(Bidib.this.logFile), (MessageReceiver)Bidib.this.getSerialMessageReceiver());
                    }
                    catch (IOException e) {
                        LOGGER.warn("Create LogFileAnalyzer failed.", (Throwable)e);
                    }
                }
            }

            public void serialEvent(SerialPortEvent event) {
                LOGGER.trace("serialEvent received: {}", (Object)event);
                switch (event.getEventType()) {
                    case 1: {
                        try {
                            ((SerialMessageReceiver)Bidib.this.getMessageReceiver()).receive(Bidib.this.port);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Message receiver has terminated with an exception!", (Throwable)ex);
                        }
                        break;
                    }
                    case 2: {
                        LOGGER.trace("The output buffer is empty.");
                        break;
                    }
                    case 3: {
                        LOGGER.warn("The CTS value has changed, old value: {}, new value: {}", new Object[]{event.getOldValue(), event.getNewValue()});
                        if (event.getNewValue()) break;
                        LOGGER.warn("Close the port.");
                        Thread worker = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                LOGGER.info("Start close port because error was detected.");
                                try {
                                    Bidib.this.close();
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Close after error failed.", (Throwable)ex);
                                }
                                LOGGER.warn("The port was closed.");
                            }
                        });
                        worker.start();
                        break;
                    }
                    default: {
                        LOGGER.warn("SerialPortEvent was triggered, type: {}, old value: {}, new value: {}", new Object[]{event.getEventType(), event.getOldValue(), event.getNewValue()});
                    }
                }
            }
        });
        serialPort.notifyOnDataAvailable(true);
        return serialPort;
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        if (this.port == null) {
            if (portName == null || portName.trim().isEmpty()) {
                throw new PortNotFoundException("");
            }
            LOGGER.info("Open port with name: {}", (Object)portName);
            File file = new File(portName);
            if (file.exists()) {
                try {
                    portName = file.getCanonicalPath();
                    LOGGER.info("Changed port name to: {}", (Object)portName);
                }
                catch (IOException ex) {
                    throw new PortNotFoundException(portName);
                }
            }
            CommPortIdentifier commPort = null;
            try {
                commPort = CommPortIdentifier.getPortIdentifier((String)portName);
            }
            catch (NoSuchPortException ex) {
                LOGGER.warn("Requested port is not available: {}", (Object)portName, (Object)ex);
                throw new PortNotFoundException(portName);
            }
            this.requestedPortName = portName;
            try {
                this.portSemaphore.acquire();
                try {
                    this.close();
                    this.port = this.internalOpen(commPort, 115200, context);
                    LOGGER.info("The port was opened internally, get the magic.");
                    int magic = this.sendMagic();
                    LOGGER.info("The root node returned the magic: {}", (Object)ByteUtils.magicToHex((int)magic));
                }
                catch (PortInUseException ex) {
                    LOGGER.warn("Open communication failed  because port is in use.", (Throwable)ex);
                    try {
                        this.close();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    throw new PortNotOpenedException(portName, "portInUse");
                }
                catch (NoAnswerException naex) {
                    LOGGER.warn("Open communication failed.", (Throwable)naex);
                    try {
                        this.close();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    throw naex;
                }
                catch (ProtocolNoAnswerException naex) {
                    LOGGER.warn("Open communication failed.", (Throwable)naex);
                    try {
                        this.close();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    throw new NoAnswerException(naex.getMessage());
                }
                catch (Exception e2) {
                    LOGGER.info("Open port failed. Try again with 19200 baud.");
                    try {
                        this.close();
                        this.port = this.internalOpen(commPort, 19200, context);
                        this.sendMagic();
                    }
                    catch (Exception e3) {
                        try {
                            this.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                throw new PortNotOpenedException(portName, "unknown");
            }
            finally {
                this.portSemaphore.release();
            }
        } else {
            LOGGER.warn("Port is already opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        boolean isOpened = false;
        try {
            this.portSemaphore.acquire();
            LOGGER.debug("Check if port is opened: {}", (Object)this.port);
            isOpened = this.port != null && this.port.getOutputStream() != null;
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("OutputStream is not available.", (Throwable)ex);
        }
        finally {
            this.portSemaphore.release();
        }
        return isOpened;
    }

    public void send(byte[] bytes) {
        if (this.port != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> {}", (Object)ByteUtils.bytesToHex((byte[])bytes));
                }
                OutputStream output = this.port.getOutputStream();
                output.write(bytes);
                output.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    private int sendMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Get the magic from the rootNode.");
        int magic = rootNode.getMagic();
        LOGGER.debug("The node returned magic: {}", (Object)magic);
        return magic;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setResponseTimeout(int timeout) {
        if (this.port != null) {
            LOGGER.info("Set the response timeout for the serial port: {}", (Object)timeout);
            try {
                this.port.enableReceiveTimeout(timeout);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Close the communication ports and perform cleanup.");
                    Bidib.getInstance().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

