/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.exception.NoAnswerException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeFactory;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.bidib.jbidibc.serial.exception.InvalidLibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bidib.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private static final Logger MSG_OUTPUTSTREAM_LOGGER = LoggerFactory.getLogger((String)"OPS");
    private SerialPort port;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);
    private static Bidib instance;
    private String requestedPortName;
    private CommPortOwnershipListener commPortOwnershipListener;
    private CommPortIdentifier commPort;
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 8192;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 4096;
    private BlockingQueue<byte[]> sendQueue = new LinkedBlockingQueue<byte[]>();
    private Thread sendQueueWorker;
    private AtomicBoolean running = new AtomicBoolean();
    private AtomicLong sendQueueWorkerThreadId = new AtomicLong();
    private long totalMessagesSentCounter;

    private Bidib() {
    }

    protected BidibMessageProcessor createMessageReceiver(NodeFactory nodeFactory) {
        return new SerialMessageReceiver(nodeFactory);
    }

    private SerialMessageReceiver getSerialMessageReceiver() {
        return (SerialMessageReceiver)this.getMessageReceiver();
    }

    public static synchronized BidibInterface getInstance() {
        if (instance == null) {
            instance = new Bidib();
            instance.initialize();
        }
        return instance;
    }

    public void close() {
        if (this.port != null) {
            InvalidConfigurationException ice;
            block18: {
                LOGGER.info("Close the port.");
                long start = System.currentTimeMillis();
                this.getSerialMessageReceiver().disable();
                try {
                    this.port.removeEventListener();
                }
                catch (Exception e) {
                    LOGGER.warn("Remove event listener failed.", (Throwable)e);
                }
                this.stopSendQueueWorker();
                try {
                    this.port.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Close port failed.", (Throwable)e);
                }
                try {
                    this.port.getInputStream().close();
                }
                catch (Exception e) {
                    LOGGER.warn("Close input stream on port failed.", (Throwable)e);
                }
                try {
                    this.port.getOutputStream().close();
                }
                catch (Exception e) {
                    LOGGER.warn("Close output stream on port failed.", (Throwable)e);
                }
                long end = System.currentTimeMillis();
                LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
                if (this.commPortOwnershipListener != null) {
                    LOGGER.info("Remove the PortOwnershipListener from commPort: {}", (Object)this.commPort);
                    try {
                        this.commPort.removePortOwnershipListener(this.commPortOwnershipListener);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remove port ownership listener failed.", (Throwable)ex);
                    }
                    this.commPortOwnershipListener = null;
                }
                this.port = null;
                this.commPort = null;
                if (this.getNodeFactory() != null) {
                    this.getNodeFactory().reset();
                }
                ice = null;
                if (this.getMessageReceiver() != null) {
                    this.getSerialMessageReceiver().clearMessageListeners();
                    this.getSerialMessageReceiver().clearNodeListeners();
                    try {
                        this.getSerialMessageReceiver().purgeOutputStream();
                    }
                    catch (InvalidConfigurationException ex) {
                        LOGGER.warn("Purge output stream has signaled an error.", (Throwable)ex);
                        if (!"debug-interface-active".equals(ex.getReason())) break block18;
                        ice = ex;
                    }
                }
            }
            if (this.getConnectionListener() != null) {
                this.getConnectionListener().closed(this.requestedPortName);
            }
            this.requestedPortName = null;
            if (ice != null) {
                LOGGER.warn("Signal the invalid configuration exception to the caller.");
                throw ice;
            }
        }
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
                LOGGER.debug("Process current CommPortIdentifier, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
                if (id.getPortType() == 1) {
                    portIdentifiers.add(id.getName());
                    continue;
                }
                LOGGER.debug("Skip port because no serial port, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }

    private void clearInputStream(SerialPort serialPort) {
        byte[] inputBuffer = new byte[1024];
        LOGGER.info("Clear the input stream of port: {}", (Object)serialPort);
        try {
            InputStream serialStream = serialPort.getInputStream();
            int count = serialStream.available();
            LOGGER.info("The input stream shows {} bytes available.", (Object)count);
            while (count > 0) {
                count = serialStream.read(inputBuffer);
                if (count <= 0) continue;
                LOGGER.info("Cleared data from input stream: {}", (Object)ByteUtils.bytesToHex((byte[])inputBuffer, (int)count));
            }
            LOGGER.info("The input stream shows {} bytes available after purge.", (Object)count);
        }
        catch (Exception e) {
            LOGGER.warn("Clear input stream failed.", (Throwable)e);
        }
    }

    private SerialPort internalOpen(CommPortIdentifier commPort, int baudRate, Context context) throws PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        if (this.commPortOwnershipListener == null) {
            this.commPortOwnershipListener = new CommPortOwnershipListener(){

                public void ownershipChange(int type) {
                    LOGGER.info("Ownership changed, type: {}", (Object)type);
                }
            };
        }
        commPort.addPortOwnershipListener(this.commPortOwnershipListener);
        this.startSendQueueWorker();
        RXTXPort serialPort = commPort.open(Bidib.class.getName(), 2000);
        LOGGER.info("Set flow control mode to SerialPort.FLOWCONTROL_RTSCTS_IN | SerialPort.FLOWCONTROL_RTSCTS_OUT!");
        serialPort.setFlowControlMode(3);
        serialPort.setInputBufferSize(8192);
        serialPort.setOutputBufferSize(4096);
        serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        this.clearInputStream((SerialPort)serialPort);
        if (context != null) {
            Boolean ignoreWrongMessageNumber = (Boolean)context.get("ignoreWrongReceiveMessageNumber", Boolean.class, (Object)Boolean.FALSE);
            this.getSerialMessageReceiver().setIgnoreWrongMessageNumber(ignoreWrongMessageNumber);
        }
        try {
            LOGGER.info("Activate DTR.");
            serialPort.setDTR(true);
        }
        catch (Exception e) {
            LOGGER.warn("Set DTR true failed.", (Throwable)e);
        }
        this.getSerialMessageReceiver().enable();
        SerialPortEventListener eventListener = new SerialPortEventListener((SerialPort)serialPort){
            final /* synthetic */ SerialPort val$serialPort;
            {
                this.val$serialPort = serialPort;
            }

            public void serialEvent(SerialPortEvent event) {
                LOGGER.trace("serialEvent received: {}", (Object)event);
                switch (event.getEventType()) {
                    case 1: {
                        MSG_OUTPUTSTREAM_LOGGER.info("<<<<");
                        try {
                            ((SerialMessageReceiver)Bidib.this.getMessageReceiver()).receive(this.val$serialPort.getInputStream());
                        }
                        catch (Exception ex) {
                            LOGGER.error("Message receiver has terminated with an exception!", (Throwable)ex);
                        }
                        break;
                    }
                    case 2: {
                        LOGGER.trace("The output buffer is empty.");
                        if (Bidib.this.sendQueueWorkerThreadId.get() != Thread.currentThread().getId()) break;
                        MSG_OUTPUTSTREAM_LOGGER.info(">>>> OBE");
                        Bidib.this.sendSemaphore.release();
                        break;
                    }
                    case 6: {
                        LOGGER.warn("CD is signalled.");
                        break;
                    }
                    case 3: {
                        LOGGER.warn("The CTS value has changed, old value: {}, new value: {}", new Object[]{event.getOldValue(), event.getNewValue()});
                        if (event.getNewValue()) break;
                        LOGGER.warn("Close the port.");
                        Thread worker = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                LOGGER.info("Start close port because error was detected.");
                                try {
                                    Bidib.this.close();
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Close after error failed.", (Throwable)ex);
                                }
                                LOGGER.warn("The port was closed.");
                            }
                        });
                        worker.start();
                        break;
                    }
                    case 7: {
                        LOGGER.warn("OE (overrun error) is signalled.");
                        break;
                    }
                    case 4: {
                        LOGGER.warn("DSR is signalled.");
                        break;
                    }
                    default: {
                        LOGGER.warn("SerialPortEvent was triggered, type: {}, old value: {}, new value: {}", new Object[]{event.getEventType(), event.getOldValue(), event.getNewValue()});
                    }
                }
            }
        };
        serialPort.addEventListener(eventListener);
        LOGGER.info("Let the serial port notify data available.");
        serialPort.notifyOnDataAvailable(true);
        serialPort.notifyOnCTS(true);
        serialPort.notifyOnCarrierDetect(true);
        serialPort.notifyOnBreakInterrupt(true);
        serialPort.notifyOnDSR(true);
        serialPort.notifyOnOverrunError(true);
        serialPort.notifyOnOutputEmpty(true);
        serialPort.setRTS(true);
        return serialPort;
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        block26: {
            this.setConnectionListener(connectionListener);
            this.registerListeners(nodeListeners, messageListeners, transferListeners);
            if (this.port == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}", (Object)portName);
                File file = new File(portName);
                if (file.exists()) {
                    try {
                        portName = file.getCanonicalPath();
                        LOGGER.info("Changed port name to: {}", (Object)portName);
                    }
                    catch (IOException ex) {
                        throw new PortNotFoundException(portName);
                    }
                }
                try {
                    this.commPort = CommPortIdentifier.getPortIdentifier((String)portName);
                }
                catch (NoSuchPortException ex) {
                    LOGGER.warn("Requested port is not available: {}", (Object)portName, (Object)ex);
                    throw new PortNotFoundException(portName);
                }
                this.requestedPortName = portName;
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.port = this.internalOpen(this.commPort, 115200, context);
                        LOGGER.info("The port was opened internally, get the magic.");
                        int magic = this.sendResetAndMagic();
                        LOGGER.info("The root node returned the magic: {}", (Object)ByteUtils.magicToHex((int)magic));
                        break block26;
                    }
                    catch (PortInUseException ex) {
                        LOGGER.warn("Open communication failed  because port is in use.", (Throwable)ex);
                        try {
                            this.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        throw new PortNotOpenedException(portName, "portInUse");
                    }
                    catch (NoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        throw naex;
                    }
                    catch (ProtocolNoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (InvalidConfigurationException e4) {
                            LOGGER.info("Rethrow the InvalidConfigurationException.", (Throwable)e4);
                            throw e4;
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        throw new NoAnswerException(naex.getMessage());
                    }
                    catch (Exception e2) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                        try {
                            this.close();
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        boolean isOpened = false;
        try {
            this.portSemaphore.acquire();
            LOGGER.debug("Check if port is opened: {}", (Object)this.port);
            isOpened = this.port != null && this.port.getOutputStream() != null;
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("OutputStream is not available.", (Throwable)ex);
        }
        finally {
            this.portSemaphore.release();
        }
        return isOpened;
    }

    public void send(byte[] bytes) {
        boolean added = this.sendQueue.offer(bytes);
        if (!added) {
            LOGGER.error("The message was not added to the send queue: {}", (Object)ByteUtils.bytesToHex((byte[])bytes));
        }
    }

    private void startSendQueueWorker() {
        this.running.set(true);
        LOGGER.info("Start the sendQueueWorker. Current sendQueueWorker: {}", (Object)this.sendQueueWorker);
        this.sendQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Bidib.this.processSendQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the send queue was terminated with an exception!", (Throwable)ex);
                    Bidib.this.running.set(false);
                }
                LOGGER.info("Process send queue has finished.");
            }
        }, "sendQueueWorker");
        try {
            this.sendQueueWorkerThreadId.set(this.sendQueueWorker.getId());
            this.sendQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the sendQueueWorker failed.", (Throwable)ex);
        }
    }

    private void stopSendQueueWorker() {
        LOGGER.info("Stop the send queue worker.");
        this.running.set(false);
        try {
            this.sendQueueWorker.interrupt();
            this.sendQueueWorker.join(1000L);
            LOGGER.info("sendQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt sendQueueWorker failed.", (Throwable)ex);
        }
        this.sendQueueWorker = null;
        int availablePermits = this.sendSemaphore.availablePermits();
        LOGGER.info("The number of availablePermits after stop send queue worker: {}", (Object)availablePermits);
        if (availablePermits < 1) {
            this.sendSemaphore.release();
        }
    }

    private void processSendQueue() {
        byte[] bytes = null;
        LOGGER.info("The sendQueueWorker is ready for processing.");
        while (this.running.get()) {
            try {
                bytes = this.sendQueue.take();
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Get message from sendQueue failed because thread was interrupted.");
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from sendQueue failed.", (Throwable)ex);
            }
            if (this.port == null || bytes == null) continue;
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)bytes.length, (Object)ByteUtils.bytesToHex((byte[])bytes));
                }
                ++this.totalMessagesSentCounter;
                MSG_OUTPUTSTREAM_LOGGER.info(">>>> {}", (Object)this.totalMessagesSentCounter);
                DataOutputStream output = new DataOutputStream(this.port.getOutputStream());
                output.write(bytes);
                output.flush();
            }
            catch (Exception ex) {
                LOGGER.warn("Send message to output stream failed: [{}] - {}", (Object)bytes.length, (Object)ByteUtils.bytesToHex((byte[])bytes));
                this.sendSemaphore.release();
                throw new RuntimeException("Send message to output stream failed: " + ByteUtils.bytesToHex((byte[])bytes), ex);
            }
        }
        LOGGER.info("The sendQueueWorker has finished processing.");
        this.sendQueueWorkerThreadId.set(0L);
    }

    private int sendResetAndMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send reset to the rootNode.");
        rootNode.reset();
        try {
            LOGGER.info("Wait 500ms before send the magic request.");
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before send the magic request failed.", (Throwable)ex);
        }
        int magic = rootNode.getMagic();
        LOGGER.debug("The node returned magic: {}", (Object)magic);
        return magic;
    }

    public void setResponseTimeout(int timeout) {
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Close the communication ports and perform cleanup.");
                    Bidib.getInstance().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

