/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.node.NodeFactory;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageReceiver
extends MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageReceiver.class);
    private byte[] inputBuffer = new byte[1024];
    boolean escapeHot = false;
    private final Object accessLock = new Object();
    private ByteArrayOutputStream output = new ByteArrayOutputStream(1024);

    public SerialMessageReceiver(NodeFactory nodeFactory) {
        super(nodeFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        LOGGER.info("enable is called.");
        Object object = this.accessLock;
        synchronized (object) {
            this.escapeHot = false;
        }
        super.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        Object object = this.accessLock;
        synchronized (object) {
            this.escapeHot = false;
        }
    }

    public String getErrorInformation() {
        if (this.output != null && this.output.size() > 0) {
            byte[] remaining = this.output.toByteArray();
            return new String(remaining);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeOutputStream() {
        Object object = this.accessLock;
        synchronized (object) {
            LOGGER.info("Purge the output stream. Current escapeHot: {}", (Object)this.escapeHot);
            this.escapeHot = false;
            if (this.output != null && this.output.size() > 0) {
                try {
                    byte[] remaining = this.output.toByteArray();
                    String remainingValue = new String(remaining, Charset.forName("UTF-8"));
                    LOGGER.info("Cleared remaining data from message output buffer: {}, text: {}", (Object)ByteUtils.bytesToHex((byte[])remaining), (Object)remainingValue);
                    if (remainingValue.indexOf("I=") > -1) {
                        InvalidConfigurationException ice = new InvalidConfigurationException("An active debug interface configuration was detected.");
                        ice.setReason("debug-interface-active");
                        throw ice;
                    }
                }
                catch (UnsupportedCharsetException ex) {
                    LOGGER.warn("Clear remaining data from message output buffer failed.", (Throwable)ex);
                }
                finally {
                    this.output.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(InputStream input) {
        LOGGER.debug("Start receiving messages from port.");
        if (!this.running.get()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            return;
        }
        Object object = this.accessLock;
        synchronized (object) {
            LOGGER.debug("Start processing input stream.");
            try {
                if (input != null) {
                    this.parseInput(input);
                } else {
                    LOGGER.warn("Inside receive, port is not available");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
                if (this.escapeHot) {
                    LOGGER.warn("Reset the escapeHot to false.");
                    this.escapeHot = false;
                }
                throw new RuntimeException(e);
            }
        }
    }

    protected void parseInput(InputStream input) throws IOException, ProtocolException {
        if (input != null) {
            int data = 0;
            StringBuilder logRecord = new StringBuilder();
            int len = 0;
            while (this.running.get() && (len = input.read(this.inputBuffer, 0, this.inputBuffer.length)) > 0) {
                LOGGER.debug("Number of bytes read: {}", (Object)len);
                MSG_RAW_LOGGER.info("<<<< len: {}", (Object)len);
                for (int index = 0; index < len; ++index) {
                    data = this.inputBuffer[index] & 0xFF;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("received data: {}", (Object)ByteUtils.byteToHex((int)data));
                    }
                    logRecord.append(ByteUtils.byteToHex((int)data)).append(" ");
                    if (data == 254 && this.output.size() > 0) {
                        LOGGER.debug("Received raw message: {}", (Object)logRecord);
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info("<< [{}] - {}", (Object)(logRecord.length() / 3), (Object)logRecord);
                        }
                        logRecord.setLength(0);
                        try {
                            this.processMessages(this.output);
                        }
                        catch (ProtocolException ex) {
                            LOGGER.warn("Process messages failed.", (Throwable)ex);
                            this.escapeHot = false;
                        }
                        continue;
                    }
                    if (data == 253) {
                        this.escapeHot = true;
                        continue;
                    }
                    if (data == 254) continue;
                    if (this.escapeHot) {
                        data ^= 0x20;
                        this.escapeHot = false;
                    }
                    this.output.write(ByteUtils.getLowByte((int)data));
                }
            }
            LOGGER.debug("Leaving receive loop, RUNNING: {}", (Object)this.running);
            if (this.output != null && this.output.size() > 0) {
                byte[] remaining = this.output.toByteArray();
                String remainingString = ByteUtils.bytesToHex((byte[])remaining);
                LOGGER.debug("Data remaining in output: {}", (Object)remainingString);
            }
            if (logRecord != null && logRecord.length() > 0) {
                LOGGER.debug("Data remaining in logRecord: {}", (Object)logRecord);
            }
        } else {
            LOGGER.error("No input available.");
        }
    }
}

