/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial.scm;

import com.embeddedunveiled.serial.ISerialComDataListener;
import com.embeddedunveiled.serial.ISerialComEventListener;
import com.embeddedunveiled.serial.SerialComDataEvent;
import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComLineEvent;
import com.embeddedunveiled.serial.SerialComManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.NoAnswerException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeFactory;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.bidib.jbidibc.serial.exception.InvalidLibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScmSerialBidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmSerialBidib.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private SerialComManager scm;
    private long handle = -1L;
    private ISerialComDataListener dataListener;
    private Semaphore portSemaphore = new Semaphore(1);
    private static ScmSerialBidib instance;
    private String requestedPortName;
    private ISerialComEventListener eventListener;
    private boolean addEventListener = false;
    private BlockingQueue<byte[]> sendQueue = new LinkedBlockingQueue<byte[]>();
    private Thread sendQueueWorker;
    private AtomicBoolean running = new AtomicBoolean();
    private AtomicLong sendQueueWorkerThreadId = new AtomicLong();

    private ScmSerialBidib() {
    }

    protected BidibMessageProcessor createMessageReceiver(NodeFactory nodeFactory) {
        return new SerialMessageReceiver(nodeFactory);
    }

    private SerialMessageReceiver getSerialMessageReceiver() {
        return (SerialMessageReceiver)this.getMessageReceiver();
    }

    public static synchronized BidibInterface getInstance() {
        if (instance == null) {
            instance = new ScmSerialBidib();
            instance.initialize();
        }
        return instance;
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        block21: {
            this.setConnectionListener(connectionListener);
            this.registerListeners(nodeListeners, messageListeners, transferListeners);
            if (this.scm == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}", (Object)portName);
                File file = new File(portName);
                if (file.exists()) {
                    try {
                        portName = file.getCanonicalPath();
                        LOGGER.info("Changed port name to: {}", (Object)portName);
                    }
                    catch (IOException ex) {
                        throw new PortNotFoundException(portName);
                    }
                }
                this.requestedPortName = portName;
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.scm = new SerialComManager();
                        this.internalOpen(portName, SerialComManager.BAUDRATE.B115200, context);
                        LOGGER.info("The port was opened internally, get the magic.");
                        int magic = this.sendResetAndMagic();
                        LOGGER.info("The root node returned the magic: {}", (Object)ByteUtils.magicToHex((int)magic));
                        break block21;
                    }
                    catch (NoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        throw naex;
                    }
                    catch (ProtocolNoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        throw new NoAnswerException(naex.getMessage());
                    }
                    catch (Exception e2) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                        try {
                            this.close();
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                    catch (UnsatisfiedLinkError err) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    public void close() {
        if (this.scm != null && this.handle > 0L) {
            LOGGER.info("Close the port.");
            long start = System.currentTimeMillis();
            LOGGER.info("Unregister data listener: {}", (Object)this.dataListener);
            if (this.dataListener != null) {
                try {
                    this.scm.unregisterDataListener(this.dataListener);
                }
                catch (SerialComException ex) {
                    LOGGER.warn("Unregister dataListener failed.", (Throwable)ex);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Sleep after unregister data listener failed.", (Throwable)ex);
                }
                this.dataListener = null;
            }
            if (this.eventListener != null) {
                LOGGER.info("Unregister line event listener.");
                try {
                    this.scm.unregisterLineEventListener(this.eventListener);
                }
                catch (SerialComException ex) {
                    LOGGER.warn("Unregister lineEventListener failed.", (Throwable)ex);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Sleep after unregister line event listener failed.", (Throwable)ex);
                }
            }
            this.eventListener = null;
            this.getSerialMessageReceiver().disable();
            this.stopSendQueueWorker();
            try {
                LOGGER.info("Close the COM port: {}", (Object)this.handle);
                this.scm.closeComPort(this.handle);
            }
            catch (Exception e) {
                LOGGER.warn("Close port failed.", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.scm = null;
            this.handle = -1L;
            if (this.getNodeFactory() != null) {
                this.getNodeFactory().reset();
            }
            if (this.getMessageReceiver() != null) {
                this.getSerialMessageReceiver().clearMessageListeners();
                this.getSerialMessageReceiver().clearNodeListeners();
                this.getSerialMessageReceiver().purgeOutputStream();
            }
            if (this.getConnectionListener() != null) {
                this.getConnectionListener().closed(this.requestedPortName);
            }
            this.requestedPortName = null;
        } else {
            LOGGER.info("No port to close available.");
        }
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            String[] ports;
            SerialComManager scm = new SerialComManager();
            for (String portIdentifier : ports = scm.listAvailableComPorts()) {
                portIdentifiers.add(portIdentifier);
            }
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        catch (SerialComException ex) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ex);
            throw new InvalidLibraryException(ex.getMessage(), ex.getCause());
        }
        return portIdentifiers;
    }

    private long internalOpen(String portName, SerialComManager.BAUDRATE baudRate, Context context) throws SerialComException {
        this.startSendQueueWorker();
        this.handle = this.scm.openComPort(portName, true, true, true);
        LOGGER.info("Opened serial port, handle: {}", (Object)this.handle);
        this.scm.configureComPortControl(this.handle, SerialComManager.FLOWCONTROL.NONE, 'x', 'x', false, true);
        this.scm.configureComPortData(this.handle, SerialComManager.DATABITS.DB_8, SerialComManager.STOPBITS.SB_1, SerialComManager.PARITY.P_NONE, baudRate, 0);
        if (context != null) {
            Boolean ignoreWrongMessageNumber = (Boolean)context.get("ignoreWrongReceiveMessageNumber", Boolean.class, (Object)Boolean.FALSE);
            this.getSerialMessageReceiver().setIgnoreWrongMessageNumber(ignoreWrongMessageNumber);
        }
        if (this.addEventListener) {
            this.eventListener = new ISerialComEventListener(){

                public void onNewSerialEvent(SerialComLineEvent lineEvent) {
                    LOGGER.error("eventCTS : {}, eventDSR : {}", (Object)lineEvent.getCTS(), (Object)lineEvent.getDSR());
                }
            };
            this.scm.registerLineEventListener(this.handle, this.eventListener);
        }
        this.getSerialMessageReceiver().enable();
        this.dataListener = new ISerialComDataListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNewSerialDataAvailable(SerialComDataEvent dataEvent) {
                ByteArrayInputStream bis = null;
                try {
                    bis = new ByteArrayInputStream(dataEvent.getDataBytes());
                    ((SerialMessageReceiver)ScmSerialBidib.this.getMessageReceiver()).receive(bis);
                }
                catch (Exception ex) {
                    LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ex) {
                            LOGGER.warn("Close bis failed.", (Throwable)ex);
                        }
                    }
                }
            }

            public void onDataListenerError(int errorNum) {
                LOGGER.error("Data listener notified an error: {}", (Object)errorNum);
                Thread t1 = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.info("Error detected. Close the port.");
                        try {
                            ScmSerialBidib.this.scm.unregisterDataListener(ScmSerialBidib.this.dataListener);
                            ScmSerialBidib.this.dataListener = null;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Unregister data listener after error detection failed.", (Throwable)ex);
                        }
                        ScmSerialBidib.this.close();
                    }
                });
                t1.start();
            }
        };
        LOGGER.info("Registering data listener fro handle: {}.", (Object)this.handle);
        this.scm.registerDataListener(this.handle, this.dataListener);
        LOGGER.info("Registered data listener.");
        try {
            LOGGER.info("Activate DTR.");
            this.scm.setDTR(this.handle, true);
        }
        catch (Exception e) {
            LOGGER.warn("Set DTR true failed.", (Throwable)e);
        }
        try {
            LOGGER.info("Activate RTS.");
            this.scm.setRTS(this.handle, true);
        }
        catch (Exception e) {
            LOGGER.warn("Set RTS true failed.", (Throwable)e);
        }
        return this.handle;
    }

    public boolean isOpened() {
        boolean isOpened = this.handle > 0L;
        return isOpened;
    }

    public void send(byte[] bytes) {
        boolean added = this.sendQueue.offer(bytes);
        if (!added) {
            LOGGER.error("The message was not added to the send queue: {}", (Object)ByteUtils.bytesToHex((byte[])bytes));
        }
    }

    private void startSendQueueWorker() {
        this.running.set(true);
        LOGGER.info("Start the sendQueueWorker. Current sendQueueWorker: {}", (Object)this.sendQueueWorker);
        this.sendQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ScmSerialBidib.this.processSendQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the sendQueue was terminated.", (Throwable)ex);
                }
                LOGGER.info("Process send queue has finished.");
            }
        }, "sendQueueWorker");
        try {
            this.sendQueueWorkerThreadId.set(this.sendQueueWorker.getId());
            this.sendQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the sendQueueWorker failed.", (Throwable)ex);
        }
    }

    private void stopSendQueueWorker() {
        LOGGER.info("Stop the send queue worker.");
        this.running.set(false);
        try {
            this.sendQueueWorker.interrupt();
            this.sendQueueWorker.join(1000L);
            LOGGER.info("sendQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt sendQueueWorker failed.", (Throwable)ex);
        }
        this.sendQueueWorker = null;
    }

    private void processSendQueue() {
        byte[] bytes = null;
        LOGGER.info("The sendQueueWorker is ready for processing.");
        while (this.running.get()) {
            try {
                bytes = this.sendQueue.take();
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from sendQueue failed.", (Throwable)ex);
            }
            if (this.handle <= 0L || bytes == null) continue;
            try {
                boolean sent;
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)bytes.length, (Object)ByteUtils.bytesToHex((byte[])bytes));
                }
                if (!(sent = this.scm.writeBytes(this.handle, bytes))) {
                    MSG_RAW_LOGGER.warn(">> sent: {}", (Object)sent);
                    LOGGER.error("The message has not been sent to handle: {}, message: {}", (Object)this.handle, (Object)ByteUtils.bytesToHex((byte[])bytes));
                    throw new RuntimeException("Write message to output failed: " + ByteUtils.bytesToHex((byte[])bytes));
                }
                MSG_RAW_LOGGER.info(">> sent: {}", (Object)sent);
            }
            catch (Exception ex) {
                LOGGER.warn("Send message to output stream failed: [{}] - {}", new Object[]{bytes.length, ByteUtils.bytesToHex((byte[])bytes), ex});
                throw new RuntimeException("Send message to output stream failed: " + ByteUtils.bytesToHex((byte[])bytes), ex);
            }
        }
        LOGGER.info("The sendQueueWorker has finished processing.");
        this.sendQueueWorkerThreadId.set(0L);
    }

    private int sendResetAndMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send reset to the rootNode.");
        rootNode.reset();
        try {
            LOGGER.info("Wait 500ms before send the magic request.");
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before send the magic request failed.", (Throwable)ex);
        }
        int magic = rootNode.getMagic();
        LOGGER.debug("The node returned magic: {}", (Object)magic);
        return magic;
    }

    public void setResponseTimeout(int timeout) {
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Close the communication ports and perform cleanup.");
                    ScmSerialBidib.getInstance().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

