/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial.scm;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComManager;
import java.util.ArrayList;
import java.util.List;
import org.bidib.jbidibc.serial.exception.InvalidLibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmPortIdentifierUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmPortIdentifierUtils.class);

    public static List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            String[] ports;
            SerialComManager scm = new SerialComManager();
            for (String port : ports = scm.listAvailableComPorts()) {
                portIdentifiers.add(port);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        catch (SerialComException ex) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
        return portIdentifiers;
    }
}

