/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.exception.NoAnswerException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.node.NodeFactory;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialBidib
extends AbstractBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerialBidib.class);
    protected Semaphore portSemaphore = new Semaphore(1);
    private static AbstractSerialBidib instance;
    protected String requestedPortName;
    private BlockingQueue<byte[]> sendQueue = new LinkedBlockingQueue<byte[]>();
    private Thread sendQueueWorker;
    private AtomicBoolean running = new AtomicBoolean();
    private AtomicLong sendQueueWorkerThreadId = new AtomicLong();
    private BlockingQueue<byte[]> receiveQueue = new LinkedBlockingQueue<byte[]>();
    private Thread receiveQueueWorker;
    private AtomicBoolean receiverRunning = new AtomicBoolean();
    private AtomicLong receiveQueueWorkerThreadId = new AtomicLong();
    private AtomicBoolean isConnected = new AtomicBoolean();

    protected BidibMessageProcessor createMessageReceiver(NodeFactory nodeFactory) {
        return new SerialMessageReceiver(nodeFactory);
    }

    protected SerialMessageReceiver getSerialMessageReceiver() {
        SerialMessageReceiver serialMessageReceiver = (SerialMessageReceiver)this.getMessageReceiver();
        LOGGER.debug("Get the serial message receiver: {}", (Object)serialMessageReceiver);
        return serialMessageReceiver;
    }

    public static synchronized boolean isInstanceAvailable() {
        return instance != null;
    }

    protected void stopReceiverAndQueues(SerialMessageReceiver serialMessageReceiver) {
        if (serialMessageReceiver != null) {
            serialMessageReceiver.disable();
        } else {
            LOGGER.warn("No message receiver to disable available.");
        }
        this.stopSendQueueWorker();
        this.stopReceiveQueueWorker();
    }

    protected void cleanupAfterClose(SerialMessageReceiver serialMessageReceiver) {
        this.releaseRootNode();
        InvalidConfigurationException ice = null;
        if (serialMessageReceiver != null) {
            serialMessageReceiver.clearMessageListeners();
            serialMessageReceiver.clearNodeListeners();
            LOGGER.info("Purge the received data in the message buffer.");
            try {
                serialMessageReceiver.purgeReceivedDataInBuffer();
            }
            catch (InvalidConfigurationException ex) {
                LOGGER.warn("Purge output stream has signaled an error.", (Throwable)ex);
                if ("debug-interface-active".equals(ex.getReason())) {
                    ice = ex;
                }
            }
        } else {
            LOGGER.warn("No message receiver to purge received data buffer available.");
        }
        if (this.getConnectionListener() != null) {
            this.getConnectionListener().closed(this.requestedPortName);
        }
        this.requestedPortName = null;
        if (ice != null) {
            LOGGER.warn("Signal the invalid configuration exception to the caller.");
            throw ice;
        }
    }

    protected void startReceiverAndQueues(SerialMessageReceiver serialMessageReceiver, Context context) {
        this.startSendQueueWorker();
        this.startReceiveQueueWorker();
        if (serialMessageReceiver != null && context != null) {
            Boolean ignoreWrongMessageNumber = (Boolean)context.get("ignoreWrongReceiveMessageNumber", Boolean.class, (Object)Boolean.FALSE);
            serialMessageReceiver.setIgnoreWrongMessageNumber(ignoreWrongMessageNumber);
        } else {
            LOGGER.warn("No message receiver available.");
        }
        if (serialMessageReceiver != null) {
            serialMessageReceiver.enable();
        } else {
            LOGGER.warn("No message receiver to enable available.");
        }
    }

    protected abstract boolean isImplAvaiable();

    protected abstract void internalOpen(String var1, int var2, Context var3) throws Exception;

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        block24: {
            this.setConnectionListener(connectionListener);
            this.registerListeners(nodeListeners, messageListeners, transferListeners);
            if (!this.isImplAvaiable()) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}", (Object)portName);
                File file = new File(portName);
                if (file.exists()) {
                    try {
                        portName = file.getCanonicalPath();
                        LOGGER.info("Changed port name to: {}", (Object)portName);
                    }
                    catch (IOException ex) {
                        throw new PortNotFoundException(portName);
                    }
                }
                this.requestedPortName = portName;
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.internalOpen(portName, 115200, context);
                        LOGGER.info("The port was opened internally, get the magic.");
                        int magic = this.sendResetAndMagic();
                        LOGGER.info("The root node returned the magic: {}", (Object)ByteUtils.magicToHex((int)magic));
                        break block24;
                    }
                    catch (NoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw naex;
                    }
                    catch (ProtocolNoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new NoAnswerException(naex.getMessage());
                    }
                    catch (PortNotFoundException pnfEx) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)pnfEx);
                        try {
                            this.close();
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "portNotFound");
                    }
                    catch (Exception e2) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                        try {
                            this.close();
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                    catch (UnsatisfiedLinkError err) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    protected boolean isConnected() {
        return this.isConnected.get();
    }

    protected void setConnected(boolean connected) {
        this.isConnected.set(connected);
    }

    public abstract boolean isOpened();

    public void send(byte[] bytes) {
        boolean added = this.sendQueue.offer(bytes);
        if (!added) {
            LOGGER.error("The message was not added to the send queue: {}", (Object)ByteUtils.bytesToHex((byte[])bytes));
        }
    }

    private void startSendQueueWorker() {
        this.running.set(true);
        LOGGER.info("Start the sendQueueWorker. Current sendQueueWorker: {}", (Object)this.sendQueueWorker);
        this.sendQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSerialBidib.this.processSendQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the send queue was terminated with an exception!", (Throwable)ex);
                    AbstractSerialBidib.this.running.set(false);
                }
                LOGGER.info("Process send queue has finished.");
            }
        }, "sendQueueWorker");
        try {
            this.sendQueueWorkerThreadId.set(this.sendQueueWorker.getId());
            this.sendQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the sendQueueWorker failed.", (Throwable)ex);
        }
    }

    private void stopSendQueueWorker() {
        LOGGER.info("Stop the send queue worker.");
        this.running.set(false);
        try {
            this.sendQueueWorker.interrupt();
            this.sendQueueWorker.join(1000L);
            LOGGER.info("sendQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt sendQueueWorker failed.", (Throwable)ex);
        }
        this.sendQueueWorker = null;
    }

    protected abstract void sendData(byte[] var1);

    private void processSendQueue() {
        byte[] bytes = null;
        LOGGER.info("The sendQueueWorker is ready for processing.");
        while (this.running.get()) {
            try {
                bytes = this.sendQueue.take();
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Get message from sendQueue failed because thread was interrupted.");
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from sendQueue failed.", (Throwable)ex);
                bytes = null;
            }
            this.sendData(bytes);
            bytes = null;
        }
        LOGGER.info("The sendQueueWorker has finished processing.");
        this.sendQueueWorkerThreadId.set(0L);
    }

    private int sendResetAndMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send sysDisable to the rootNode.");
        rootNode.sysDisable();
        try {
            LOGGER.info("Wait 300ms before send the magic request.");
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before send the magic request failed.", (Throwable)ex);
        }
        SerialMessageReceiver serialMessageReceiver = this.getSerialMessageReceiver();
        LOGGER.info("Enable the message receiver before send magic: {}", (Object)serialMessageReceiver);
        serialMessageReceiver.enable();
        LOGGER.info("Send the magic request.");
        int magic = rootNode.getMagic(Integer.valueOf(1500));
        LOGGER.debug("The node returned magic: {}", (Object)magic);
        return magic;
    }

    protected void receive(byte[] data) {
        this.receive(data, data.length);
    }

    protected void receive(byte[] data, int len) {
        byte[] buffer = new byte[len];
        System.arraycopy(data, 0, buffer, 0, len);
        boolean added = this.receiveQueue.offer(buffer);
        if (!added) {
            LOGGER.error("The message was not added to the receive queue: {}", (Object)ByteUtils.bytesToHex((byte[])buffer));
        }
    }

    private void startReceiveQueueWorker() {
        this.receiverRunning.set(true);
        LOGGER.info("Start the receiveQueueWorker. Current receiveQueueWorker: {}", (Object)this.receiveQueueWorker);
        this.receiveQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSerialBidib.this.processReceiveQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the receive queue was terminated with an exception!", (Throwable)ex);
                }
                LOGGER.info("Process receive queue has finished.");
            }
        }, "receiveQueueWorker");
        try {
            this.receiveQueueWorkerThreadId.set(this.receiveQueueWorker.getId());
            this.receiveQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the receiveQueueWorker failed.", (Throwable)ex);
        }
    }

    private void stopReceiveQueueWorker() {
        LOGGER.info("Stop the receive queue worker.");
        this.receiverRunning.set(false);
        try {
            this.receiveQueueWorker.interrupt();
            this.receiveQueueWorker.join(1000L);
            LOGGER.info("receiveQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt receiveQueueWorker failed.", (Throwable)ex);
        }
        this.receiveQueueWorker = null;
    }

    private void processReceiveQueue() {
        byte[] bytes = null;
        LOGGER.info("The receiveQueueWorker is ready for processing.");
        SerialMessageReceiver serialMessageReceiver = this.getSerialMessageReceiver();
        while (this.receiverRunning.get()) {
            try {
                bytes = this.receiveQueue.take();
                if (bytes == null) continue;
                try {
                    serialMessageReceiver.receive(bytes, bytes.length);
                }
                catch (Exception ex) {
                    LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Get message from receiveQueue failed because thread was interrupted.");
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from receiveQueue failed.", (Throwable)ex);
                bytes = null;
            }
        }
        LOGGER.info("The receiveQueueWorker has finished processing.");
        this.receiveQueueWorkerThreadId.set(0L);
    }
}

