/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.core.exception.ProtocolException;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageReceiver
extends MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageReceiver.class);
    private AtomicBoolean escapeHot = new AtomicBoolean();
    private ByteArrayOutputStream output = new ByteArrayOutputStream(2048);

    public SerialMessageReceiver(NodeRegistry nodeFactory) {
        super(nodeFactory);
    }

    public void enable() {
        LOGGER.info("enable is called.");
        this.escapeHot.set(false);
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        try {
            this.output.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        MSG_RAW_LOGGER.info("++++ Disable the message receiver.");
        this.escapeHot.set(false);
    }

    public String getErrorInformation() {
        if (this.output != null && this.output.size() > 0) {
            byte[] remaining = this.output.toByteArray();
            return new String(remaining);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReceivedDataInBuffer() {
        LOGGER.info("Purge the received data in the message buffer before get the lock.");
        LOGGER.info("Purge the received data in the message buffer. Current escapeHot: {}", (Object)this.escapeHot);
        this.escapeHot.set(false);
        if (this.output != null && this.output.size() > 0) {
            try {
                byte[] remaining = this.output.toByteArray();
                String remainingValue = new String(remaining, StandardCharsets.UTF_8);
                LOGGER.info("Cleared remaining data from message output buffer: {}, text: {}", (Object)ByteUtils.bytesToHex((byte[])remaining), (Object)remainingValue);
                if (remainingValue.indexOf("I=") > -1) {
                    InvalidConfigurationException ice = new InvalidConfigurationException("An active debug interface configuration was detected.");
                    ice.setReason("debug-interface-active");
                    throw ice;
                }
            }
            finally {
                this.output.reset();
            }
            LOGGER.info("Finished purge output stream.");
        } else {
            LOGGER.info("The message buffer is empty.");
        }
    }

    public void receive(ByteArrayOutputStream data) {
        if (!this.running.get()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            try {
                byte[] rawdata = data.toByteArray();
                LOGGER.info("Receiver is stopped, number of bytes read: {}, buffer: {}", (Object)rawdata.length, (Object)ByteUtils.bytesToHex((byte[])rawdata));
            }
            catch (Exception ex) {
                LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
            }
            return;
        }
        MSG_RAW_LOGGER.info("<<<< start parse input");
        try {
            byte[] rawdata = data.toByteArray();
            this.parseInput(rawdata, rawdata.length);
        }
        catch (Exception e) {
            LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
            if (this.escapeHot.get()) {
                LOGGER.warn("Reset the escapeHot to false.");
                this.escapeHot.set(false);
            }
            throw new RuntimeException(e);
        }
        finally {
            MSG_RAW_LOGGER.info("<<<< finished parse input");
        }
    }

    protected void parseInput(byte[] receivedData, int len) throws ProtocolException {
        if (receivedData != null) {
            int data = 0;
            StringBuilder logRecord = new StringBuilder();
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)len, (Object)ByteUtils.bytesToHex((byte[])receivedData, (int)len));
            for (int index = 0; index < len; ++index) {
                data = receivedData[index] & 0xFF;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("received data: {}", (Object)ByteUtils.byteToHex((int)data));
                }
                logRecord.append(ByteUtils.byteToHex((int)data)).append(" ");
                if (data == 254) {
                    LOGGER.debug("Received raw message: {}", (Object)logRecord);
                    if (MSG_RAW_LOGGER.isInfoEnabled()) {
                        MSG_RAW_LOGGER.info("<< [{}] - {}", (Object)(logRecord.length() / 3), (Object)logRecord);
                    }
                    logRecord.setLength(0);
                    try {
                        this.processMessages(this.output);
                    }
                    catch (ProtocolException ex) {
                        LOGGER.warn("Process messages failed.", (Throwable)ex);
                        this.escapeHot.set(false);
                    }
                    continue;
                }
                if (data == 253) {
                    this.escapeHot.set(true);
                    continue;
                }
                if (this.escapeHot.get()) {
                    data ^= 0x20;
                    this.escapeHot.set(false);
                }
                this.output.write(ByteUtils.getLowByte((int)data));
            }
            LOGGER.debug("Leaving receive loop, RUNNING: {}", (Object)this.running);
            if (this.output != null && this.output.size() > 0) {
                byte[] remaining = this.output.toByteArray();
                String remainingString = ByteUtils.bytesToHex((byte[])remaining);
                LOGGER.debug("Data remaining in output: {}", (Object)remainingString);
            }
            if (logRecord != null && logRecord.length() > 0) {
                LOGGER.debug("Data remaining in logRecord: {}", (Object)logRecord);
            }
        } else {
            LOGGER.error("No input available.");
        }
    }
}

