/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageEncoderTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageEncoderTest.class);

    @Test
    public void encodeSingleMessage() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(new byte[]{3, 0, 0, 4});
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)output);
        LOGGER.info("Data in output: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        Assertions.assertThat((byte[])new byte[]{-2, 3, 0, 0, 4, -23, -2}).isEqualTo((Object)output.toByteArray());
    }

    @Test
    public void encodeSingleMessage2() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(new byte[]{6, 6, 0, -3, 76, 11, 3});
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)output);
        LOGGER.info("Data in output: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        Assertions.assertThat((byte[])new byte[]{-2, 6, 6, 0, -3, -35, 76, 11, 3, -101, -2}).isEqualTo((Object)output.toByteArray());
    }

    @Test
    public void encodeMultipleMessages() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(new byte[]{3, 0, 0, 4, 5, 0, 1, 25, 0, 0});
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)output);
        LOGGER.info("Data in output: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        Assertions.assertThat((byte[])new byte[]{-2, 3, 0, 0, 4, 5, 0, 1, 25, 0, 0, 31, -2}).isEqualTo((Object)output.toByteArray());
    }
}

