/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.bidib.jbidibc.core.AbstractMessageReceiver;
import org.bidib.jbidibc.core.MessageParser;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageReceiver
extends AbstractMessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageReceiver.class);
    private ByteArrayOutputStream receiveBuffer = new ByteArrayOutputStream(2048);
    private SerialMessageParser serialMessageParser;

    public SerialMessageReceiver(NodeRegistry nodeFactory, ResponseFactory responseFactory) {
        super(nodeFactory, responseFactory, true);
    }

    public void init(Context context) {
        super.init(context);
        this.serialMessageParser = (SerialMessageParser)this.getMessageParser();
        LOGGER.info("Keep the messageParser as serialMessageParser: {}", (Object)this.serialMessageParser);
    }

    protected MessageParser createMessageParser() {
        LOGGER.info("Create the serial message parser.");
        SerialMessageParser messageParser = new SerialMessageParser();
        return messageParser;
    }

    public void enable() {
        LOGGER.info("enable is called.");
        this.serialMessageParser.setEscapeHot(false);
        MSG_RAW_LOGGER.info("++++ Enable the serial message receiver.");
        try {
            this.receiveBuffer.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        try {
            this.serialMessageParser.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    public void disable() {
        LOGGER.info("Disable is called.");
        super.disable();
        MSG_RAW_LOGGER.info("++++ Disable the serial message receiver.");
        this.serialMessageParser.setEscapeHot(false);
    }

    public String getErrorInformation() {
        if (this.receiveBuffer.size() > 0) {
            byte[] remaining = this.receiveBuffer.toByteArray();
            return new String(remaining);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReceivedDataInBuffer() {
        LOGGER.info("Purge the received data in the message buffer before get the lock.");
        LOGGER.info("Purge the received data in the message buffer. Current escapeHot: {}", (Object)this.serialMessageParser.isEscapeHot());
        this.serialMessageParser.setEscapeHot(false);
        if (this.receiveBuffer.size() > 0) {
            try {
                byte[] remaining = this.receiveBuffer.toByteArray();
                String remainingValue = new String(remaining, StandardCharsets.UTF_8);
                LOGGER.info("Cleared remaining data from message output buffer: {}, text: {}", (Object)ByteUtils.bytesToHex((byte[])remaining), (Object)remainingValue);
                if (remainingValue.indexOf("I=") > -1) {
                    InvalidConfigurationException ice = new InvalidConfigurationException("An active debug interface configuration was detected.");
                    ice.setReason("debug-interface-active");
                    throw ice;
                }
            }
            finally {
                this.receiveBuffer.reset();
            }
            LOGGER.info("Finished purge output stream.");
        } else {
            LOGGER.info("The message buffer is empty.");
        }
    }

    public void receive(ByteArrayOutputStream data) {
        if (!this.isEnabled()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            try {
                byte[] rawdata = data.toByteArray();
                LOGGER.info("Receiver is stopped, number of bytes read: {}, buffer: {}", (Object)rawdata.length, (Object)ByteUtils.bytesToHex((byte[])rawdata));
            }
            catch (Exception ex) {
                LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
            }
            return;
        }
        MSG_RAW_LOGGER.info("<<<< start parse input");
        try {
            byte[] rawdata = data.toByteArray();
            this.parseInput(rawdata, rawdata.length);
        }
        catch (Exception e) {
            LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
            if (this.serialMessageParser.isEscapeHot()) {
                LOGGER.warn("Reset the escapeHot to false.");
                this.serialMessageParser.setEscapeHot(false);
            }
            throw new RuntimeException(e);
        }
        finally {
            MSG_RAW_LOGGER.info("<<<< finished parse input");
        }
    }

    protected void parseInput(byte[] receivedData, int len) throws ProtocolException {
        this.serialMessageParser.parseInput((MessageProcessor)this, receivedData, len);
    }
}

