/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.core.AbstractRawMessageReceiver;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageParser;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageParserTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageParserTest.class);

    @Test
    public void parseInputTest() throws ProtocolException {
        final AtomicInteger calledCounter = new AtomicInteger();
        AbstractRawMessageReceiver messageProcessor = new AbstractRawMessageReceiver(true){

            public void receive(ByteArrayOutputStream data) {
            }

            protected void processMessage(byte[] messageArray) throws ProtocolException {
                LOGGER.info("Process messages: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray));
                calledCounter.incrementAndGet();
            }
        };
        SerialMessageParser parser = new SerialMessageParser();
        byte[] receivedData = new byte[]{10, 1, 0, 58, -109, 3, 49, 50, 51, 1, 48, -25, -2, 9, 1, 0, 59, -70, 1, 1, 4, 0, 0, -6, -2};
        int len = receivedData.length;
        parser.parseInput((MessageProcessor)messageProcessor, receivedData, len);
        Assertions.assertThat((int)calledCounter.get()).isEqualTo(2);
    }
}

