/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bidib.jbidibc.messages.CRC8;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessageEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialMessageEncoder.class);

    public static void encodeMessage(ByteArrayOutputStream data, OutputStream output) throws IOException {
        byte[] message = data.toByteArray();
        SerialMessageEncoder.encodeMessage(message, output);
    }

    public static void encodeMessage(byte[] message, OutputStream output) throws IOException {
        byte length;
        if (message.length < 1) {
            LOGGER.warn("No data in message!");
            throw new IllegalArgumentException("No data in message!");
        }
        SerialMessageEncoder.sendDelimiter(output);
        int totalLen = message.length;
        int txCrc = 0;
        for (int index = 0; index < totalLen; index += length) {
            length = message[index++];
            SerialMessageEncoder.escape(output, length);
            txCrc = CRC8.getCrcValue((int)((length ^ txCrc) & 0xFF));
            for (int i = index; i <= length + index - 1; ++i) {
                SerialMessageEncoder.escape(output, message[i]);
                txCrc = CRC8.getCrcValue((int)((message[i] ^ txCrc) & 0xFF));
            }
        }
        SerialMessageEncoder.escape(output, ByteUtils.getLowByte((int)txCrc));
        SerialMessageEncoder.sendDelimiter(output);
    }

    private static void sendDelimiter(OutputStream output) throws IOException {
        output.write(ByteUtils.MAGIC);
    }

    private static void escape(OutputStream output, byte c) throws IOException {
        if (c == ByteUtils.MAGIC || c == ByteUtils.ESCAPE) {
            output.write(ByteUtils.ESCAPE);
            c = (byte)(c ^ 0x20);
        }
        output.write(c);
    }
}

