/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.serial;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.AbstractMessageReceiver;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.RequestFactory;
import org.bidib.jbidibc.serial.SerialMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialBidib
extends AbstractBidib<MessageReceiver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerialBidib.class);
    protected Semaphore portSemaphore = new Semaphore(1);
    protected String requestedPortName;
    protected Object receiveLock = new Object();
    private int[] baudRates = new int[]{115200, 19200};
    private int baudRateIndex;

    public void setDelayAfterSend(long delay) {
        this.getConnector().setDelayAfterSend(delay);
    }

    protected abstract AbstractBaseBidib<MessageReceiver> getConnector();

    protected SerialMessageReceiver createMessageReceiver(NodeRegistry nodeRegistry, RawMessageListener rawMessageListener, Context context) {
        SerialMessageReceiver messageReceiver = new SerialMessageReceiver(nodeRegistry, (RequestFactory)nodeRegistry.getRequestFactory());
        messageReceiver.setRawMessageListener(rawMessageListener);
        messageReceiver.init(context);
        return messageReceiver;
    }

    protected void cleanupAfterClose(MessageReceiver bidibMessageProcessor) {
        this.releaseRootNode();
        InvalidConfigurationException ice = null;
        if (bidibMessageProcessor instanceof SerialMessageReceiver) {
            SerialMessageReceiver serialMessageReceiver = (SerialMessageReceiver)bidibMessageProcessor;
            if (!this.hasMoreRetryAvailable()) {
                LOGGER.info("Clear message and node listeners from serial message receiver.");
                serialMessageReceiver.clearMessageListeners();
                serialMessageReceiver.clearNodeListeners();
            } else {
                LOGGER.info("Do not clear message and node listeners from serial message receiver in cleanupAfterClose because more retry is available.");
            }
            LOGGER.info("Purge the received data in the message buffer.");
            try {
                serialMessageReceiver.purgeReceivedDataInBuffer();
            }
            catch (InvalidConfigurationException ex) {
                LOGGER.warn("Purge output stream has signaled an error.", (Throwable)ex);
                if ("debug-interface-active".equals(ex.getReason())) {
                    ice = ex;
                }
            }
        } else {
            LOGGER.warn("No message receiver to purge received data buffer available.");
        }
        if (ice == null && this.hasMoreRetryAvailable()) {
            LOGGER.info("Do not signal the connection was closed in cleanupAfterClose because more retry is available.");
        } else {
            LOGGER.info("No more retry available.");
            if (this.getConnectionListener() != null) {
                LOGGER.info("Notify that the port was closed: {}", (Object)this.requestedPortName);
                this.getConnectionListener().closed(this.requestedPortName);
            } else {
                LOGGER.info("No connection listener available to publish the closed report for port: {}", (Object)this.requestedPortName);
            }
            this.requestedPortName = null;
            super.cleanupAfterClose(bidibMessageProcessor);
        }
        if (ice != null) {
            LOGGER.warn("Signal the invalid configuration exception to the caller.");
            throw ice;
        }
    }

    protected abstract boolean isImplAvaiable();

    protected abstract void internalOpen(String var1, Context var2) throws Exception;

    protected void notifyStatusKey(String messageKey, Context context) {
        if (this.getConnectionListener() != null) {
            this.getConnectionListener().status(messageKey, context);
        } else {
            LOGGER.info("No connection listener available.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners, context);
        if (this.isImplAvaiable()) {
            LOGGER.warn("Port is already opened.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)portName)) {
            throw new PortNotFoundException("No portName to open provided!");
        }
        LOGGER.info("Open port with name: {}", (Object)portName);
        File file = new File(portName);
        if (file.exists()) {
            Boolean symlink = (Boolean)context.get("symlink", Boolean.class, (Object)Boolean.FALSE);
            if (!symlink.booleanValue()) {
                try {
                    portName = file.getCanonicalPath();
                    LOGGER.info("Changed port name to: {}", (Object)portName);
                }
                catch (IOException ex) {
                    throw new PortNotFoundException(portName);
                }
            } else {
                LOGGER.info("Do not replace symlink name.");
            }
        }
        this.requestedPortName = portName;
        boolean openPassed = false;
        try {
            this.portSemaphore.acquire();
            while (this.baudRateIndex < this.baudRates.length) {
                String reason;
                DefaultContext statusContext3;
                Integer baudRate = this.baudRates[this.baudRateIndex];
                try {
                    this.close();
                    context.register("serial.baudrate", (Object)baudRate);
                    LOGGER.info("Try to connect with baudRate: {}", context.get("serial.baudrate"));
                    DefaultContext statusContext2 = new DefaultContext();
                    statusContext2.register("baudrate", (Object)this.baudRates[this.baudRateIndex]);
                    this.notifyStatusKey("bidib-connect-with-baudrate", (Context)statusContext2);
                    this.internalOpen(portName, context);
                    openPassed = true;
                    break;
                }
                catch (ProtocolNoAnswerException naex) {
                    LOGGER.warn("Open communication failed because the interface did not send an answer.", (Throwable)naex);
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.baudRateIndex >= this.baudRates.length - 1) throw new NoAnswerException(naex.getMessage());
                    ++this.baudRateIndex;
                    LOGGER.info("Try to connect with the next baudRate: {}", (Object)this.baudRates[this.baudRateIndex]);
                    statusContext3 = new DefaultContext();
                    statusContext3.register("baudrate", (Object)this.baudRates[this.baudRateIndex]);
                    this.notifyStatusKey("bidib-reconnect-with-next-baudrate", (Context)statusContext3);
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.warn("Wait to display status message was interrupted.", (Throwable)ie);
                    }
                }
                catch (NoAnswerException naex) {
                    LOGGER.warn("Open communication failed because no answer from interface was received. Current baudRate: {}", (Object)baudRate, (Object)naex);
                    try {
                        this.close();
                    }
                    catch (Exception statusContext3) {
                        // empty catch block
                    }
                    if (this.baudRateIndex >= this.baudRates.length - 1) throw new NoAnswerException(naex.getMessage());
                    ++this.baudRateIndex;
                    LOGGER.info("Try to connect with the next baudRate: {}", (Object)this.baudRates[this.baudRateIndex]);
                    statusContext3 = new DefaultContext();
                    statusContext3.register("baudrate", (Object)this.baudRates[this.baudRateIndex]);
                    this.notifyStatusKey("bidib-reconnect-with-next-baudrate", (Context)statusContext3);
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.warn("Wait to display status message was interrupted.", (Throwable)ie);
                    }
                }
                catch (PortNotFoundException pnfEx) {
                    LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)pnfEx);
                    try {
                        this.close();
                        throw new PortNotOpenedException(portName, "portNotFound");
                    }
                    catch (Exception e3) {
                        LOGGER.warn("Close port failed.", (Throwable)e3);
                    }
                    throw new PortNotOpenedException(portName, "portNotFound");
                }
                catch (PortNotOpenedException pnoEx) {
                    String string;
                    LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)pnoEx);
                    reason = pnoEx.getReason();
                    try {
                        this.close();
                    }
                    catch (Exception e3) {
                        LOGGER.warn("Close port failed.", (Throwable)e3);
                    }
                    if (StringUtils.isNotBlank((CharSequence)reason)) {
                        string = reason;
                        throw new PortNotOpenedException(portName, string);
                    }
                    string = "unknown";
                    throw new PortNotOpenedException(portName, string);
                }
                catch (IOException e2) {
                    String string;
                    LOGGER.info("Open port failed with IOException. Close port and throw exception.", (Throwable)e2);
                    reason = e2.getMessage();
                    try {
                        this.close();
                    }
                    catch (Exception e3) {
                        LOGGER.warn("Close port failed but this is ignored.", (Throwable)e3);
                    }
                    if (StringUtils.isNotBlank((CharSequence)reason)) {
                        string = reason;
                        throw new PortNotOpenedException(portName, string);
                    }
                    string = "unknown";
                    throw new PortNotOpenedException(portName, string);
                }
                catch (Exception e2) {
                    LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                    try {
                        this.close();
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                    catch (Exception e3) {
                        LOGGER.warn("Close port failed.", (Throwable)e3);
                    }
                    throw new PortNotOpenedException(portName, "unknown");
                }
                catch (UnsatisfiedLinkError err) {
                    LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                catch (NoSuchMethodError err) {
                    LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                    throw new PortNotOpenedException(portName, "unknown");
                }
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
            throw new PortNotOpenedException(portName, "unknown");
        }
        finally {
            this.portSemaphore.release();
        }
        if (openPassed) return;
        LOGGER.warn("The connection was not established successfully. Configured portName: {}", (Object)portName);
        throw new NoAnswerException("The connection was not established successfully.");
    }

    protected boolean hasMoreRetryAvailable() {
        boolean hasMoreRetryAvailable = this.baudRateIndex < this.baudRates.length - 1;
        LOGGER.info("Current hasMoreRetryAvailable: {}", (Object)hasMoreRetryAvailable);
        return hasMoreRetryAvailable;
    }

    public abstract boolean isOpened();

    protected void contactInterface() {
        LOGGER.info("Contact the interface node.");
        try {
            this.sendDisableAndEnableMessageReceiver();
            this.baudRateIndex = this.baudRates.length + 1;
        }
        catch (ProtocolException ex) {
            throw new NoAnswerException("Contact the interface node failed.", (Throwable)ex);
        }
    }

    private void sendDisableAndEnableMessageReceiver() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send sysDisable to the rootNode: {}", (Object)rootNode);
        rootNode.sysDisable();
        try {
            LOGGER.info("Wait 300ms before enable the message receiver.");
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before enable the message receiver.", (Throwable)ex);
        }
        BidibMessageProcessor serialMessageReceiver = this.getBidibMessageProcessor();
        if (serialMessageReceiver instanceof AbstractMessageReceiver) {
            LOGGER.info("Enable the message receiver: {}", (Object)serialMessageReceiver);
            ((AbstractMessageReceiver)serialMessageReceiver).enable();
        }
    }
}

