/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.spsw;

import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.SerialPortSocket;
import de.ibapl.spsw.api.SerialPortSocketFactory;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.api.TimeoutIOException;
import de.ibapl.spsw.jniprovider.SerialPortSocketFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.exception.InvalidLibraryException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.serial.AbstractSerialBidib;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpswSerialBidib
extends AbstractSerialBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpswSerialBidib.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private SerialPortSocket port;
    private ReceiverThread receiverThread;
    private final ServiceLoader<SerialPortSocketFactory> serialPortSocketLoader;
    private SerialPortSocketFactory serialPortFactory;
    private boolean useHardwareFlowControl;
    private final ByteArrayOutputStream sendBuffer = new ByteArrayOutputStream(2048);
    private byte[] inputBuffer = new byte[2048];
    private AtomicBoolean receiverRunning = new AtomicBoolean();

    private SpswSerialBidib() {
        this.serialPortSocketLoader = ServiceLoader.load(SerialPortSocketFactory.class);
        for (SerialPortSocketFactory factory : this.serialPortSocketLoader) {
            if (!(factory instanceof SerialPortSocketFactoryImpl)) continue;
            this.serialPortFactory = factory;
            break;
        }
        if (this.serialPortFactory == null) {
            throw new IllegalArgumentException("Failed to fetch the SPSW serial port factory.");
        }
    }

    public static BidibInterface createInstance() {
        LOGGER.info("Create new instance of SpswSerialBidib.");
        SpswSerialBidib instance = new SpswSerialBidib();
        instance.initialize();
        return instance;
    }

    public void close() {
        if (this.port != null) {
            LOGGER.info("Start closing the port: {}", (Object)this.port);
            long start = System.currentTimeMillis();
            if (this.useHardwareFlowControl) {
                try {
                    LOGGER.info("Deactivate DTR.");
                    this.port.setDTR(false);
                }
                catch (Exception e) {
                    LOGGER.warn("Set DTR to false failed.", (Throwable)e);
                }
            }
            LOGGER.info("Set the receiver running flag to false.");
            this.receiverRunning.set(false);
            BidibMessageProcessor serialMessageReceiver = this.getMessageReceiver();
            this.stopReceiverAndQueues(serialMessageReceiver);
            try {
                this.fireCtsChanged(false);
            }
            catch (Exception e) {
                LOGGER.warn("Get CTS value failed.", (Throwable)e);
            }
            try {
                this.port.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Close serial port failed.", (Throwable)ex);
            }
            this.port = null;
            this.stopReceiverThread();
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.cleanupAfterClose(serialMessageReceiver);
        } else {
            LOGGER.info("No port to close available.");
        }
    }

    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            portIdentifiers.addAll(this.serialPortFactory.getPortNames(true));
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }

    protected boolean isImplAvaiable() {
        return this.port != null;
    }

    protected void internalOpen(String portName, Context context) throws Exception {
        BidibMessageProcessor serialMessageReceiver = this.getMessageReceiver();
        SerialPortSocket serialPort = this.serialPortFactory.createSerialPortSocket(portName);
        if (serialPort == null) {
            throw new IllegalArgumentException("Failed to open SPSW port: " + portName);
        }
        Boolean useHardwareFlowControl = (Boolean)context.get("serial.useHardwareFlowControl", Boolean.class, (Object)Boolean.TRUE);
        LOGGER.info("Open port with portName: {}, useHardwareFlowControl: {}", (Object)portName, (Object)useHardwareFlowControl);
        Set flowControl = FlowControl.getFC_NONE();
        if (useHardwareFlowControl.booleanValue()) {
            LOGGER.info("Set flow control mode to RTS_CTS!");
            flowControl = FlowControl.getFC_RTS_CTS();
            this.useHardwareFlowControl = true;
        } else {
            LOGGER.info("Set flow control mode to NONE!");
            this.useHardwareFlowControl = false;
        }
        Integer baudRate = (Integer)context.get("serial.baudrate", Integer.class, (Object)115200);
        LOGGER.info("Open port with baudRate: {}", (Object)baudRate);
        serialPort.open(Speed.fromNative((int)baudRate), DataBits.DB_8, StopBits.SB_1, Parity.NONE, flowControl);
        this.port = serialPort;
        serialPort.setTimeouts(2, 100, 100);
        this.startReceiverAndQueues(serialMessageReceiver, context);
        if (this.useHardwareFlowControl) {
            try {
                LOGGER.info("Activate DTR.");
                serialPort.setDTR(true);
            }
            catch (Exception e) {
                LOGGER.warn("Set DTR true failed.", (Throwable)e);
            }
        }
        try {
            if (this.useHardwareFlowControl) {
                this.fireCtsChanged(serialPort.isCTS());
            } else {
                this.fireCtsChanged(true);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Get CTS value failed.", (Throwable)e);
        }
    }

    public boolean isOpened() {
        return this.port != null && this.port.isOpen();
    }

    protected void sendData(ByteArrayOutputStream data) {
        if (this.port != null && data != null) {
            try {
                this.sendBuffer.reset();
                if (this.useHardwareFlowControl && !this.port.isCTS()) {
                    LOGGER.error("CTS not set! The receiving part is not ready!");
                    throw new RuntimeException("CTS not set! The receiving part is not ready!");
                }
                OutputStream os = this.port.getOutputStream();
                if (!this.firstPacketSent) {
                    LOGGER.info("Send initial sequence.");
                    try {
                        byte[] initialSequence = new byte[]{-2};
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((byte[])initialSequence));
                        }
                        os.write(initialSequence);
                        Thread.sleep(10L);
                        if (MSG_RAW_LOGGER.isInfoEnabled()) {
                            MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)initialSequence.length, (Object)ByteUtils.bytesToHex((byte[])initialSequence));
                        }
                        os.write(initialSequence);
                        this.firstPacketSent = true;
                        LOGGER.info("Send initial sequence passed.");
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Send initial sequence failed.", (Throwable)ex);
                    }
                }
                SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)this.sendBuffer);
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> [{}] - {}", (Object)this.sendBuffer.toByteArray().length, (Object)ByteUtils.bytesToHex((byte[])this.sendBuffer.toByteArray()));
                }
                os.write(this.sendBuffer.toByteArray());
                os.flush();
            }
            catch (IOException ex) {
                byte[] bytes = data.toByteArray();
                LOGGER.warn("Send message to output stream failed: [{}] - {}", (Object)bytes.length, (Object)ByteUtils.bytesToHex((byte[])bytes));
                throw new RuntimeException("Send message to output stream failed: " + ByteUtils.bytesToHex((byte[])bytes), ex);
            }
            finally {
                this.sendBuffer.reset();
            }
        }
    }

    protected void startReceiverAndQueues(BidibMessageProcessor serialMessageReceiver, Context context) {
        LOGGER.info("Start receiver and queues.");
        if (this.receiverThread == null) {
            this.receiverThread = new ReceiverThread();
        }
        this.receiverThread.start();
        super.startReceiverAndQueues(serialMessageReceiver, context);
    }

    protected void stopReceiverAndQueues(BidibMessageProcessor serialMessageReceiver) {
        LOGGER.info("Stop receiver and queues.");
        super.stopReceiverAndQueues(serialMessageReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiverThread() {
        LOGGER.info("Stop the receiver thread by set the running flag to false.");
        this.receiverRunning.set(false);
        if (this.receiverThread != null) {
            LOGGER.info("Wait for termination of receiver thread.");
            ReceiverThread receiverThread = this.receiverThread;
            synchronized (receiverThread) {
                try {
                    this.receiverThread.join(5000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for termination of receiver thread failed.", (Throwable)ex);
                }
            }
            LOGGER.info("Free the receiver thread.");
            this.receiverThread = null;
        }
    }

    private void triggerClosePort() {
        LOGGER.warn("Close the port.");
        Thread worker = new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("Start close port because error was detected.");
                try {
                    SpswSerialBidib.this.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Close after error failed.", (Throwable)ex);
                }
                LOGGER.warn("The port was closed.");
            }
        });
        worker.start();
    }

    public class ReceiverThread
    extends Thread {
        @Override
        public void run() {
            SpswSerialBidib.this.receiverRunning.set(true);
            SerialPortSocket serialPort = SpswSerialBidib.this.port;
            while (SpswSerialBidib.this.receiverRunning.get()) {
                try {
                    int remaining;
                    InputStream input = serialPort.getInputStream();
                    int len = input.read(SpswSerialBidib.this.inputBuffer, 0, SpswSerialBidib.this.inputBuffer.length);
                    if (len < 0) {
                        boolean portClosed = serialPort.isClosed();
                        LOGGER.info("Port closed: {}", (Object)portClosed);
                        if (portClosed) {
                            LOGGER.info("The port is closed. Leave the receiver loop.");
                            SpswSerialBidib.this.receiverRunning.set(false);
                            continue;
                        }
                    }
                    if ((remaining = input.available()) > 0) {
                        LOGGER.warn("More data in inputStream might be available, remaining: {}", (Object)remaining);
                    }
                    if (len <= -1) continue;
                    SpswSerialBidib.this.receive(SpswSerialBidib.this.inputBuffer, len);
                }
                catch (TimeoutIOException ex) {
                    LOGGER.trace("Timout during wait for data.");
                }
                catch (IOException ex) {
                    LOGGER.error("Receive data failed with an exception!", (Throwable)ex);
                    SpswSerialBidib.this.receiverRunning.set(false);
                    if (serialPort != null && !serialPort.isOpen()) continue;
                    SpswSerialBidib.this.triggerClosePort();
                }
                catch (NullPointerException ex) {
                    LOGGER.error("Receive data failed with an NPE! The port might be closed.", (Throwable)ex);
                    SpswSerialBidib.this.receiverRunning.set(false);
                }
                catch (Exception ex) {
                    LOGGER.error("Message receiver returned from receive with an exception!", (Throwable)ex);
                }
            }
            LOGGER.info("Leaving receiver loop.");
        }
    }
}

