/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.spsw;

import java.util.List;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.MessageReceiver;
import org.bidib.jbidibc.core.base.DataTransferStatusListener;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.serial.AbstractSerialBidib;
import org.bidib.jbidibc.serial.LineStatusListener;
import org.bidib.jbidibc.spsw.SpswSerialConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpswSerialBidib
extends AbstractSerialBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpswSerialBidib.class);
    private SpswSerialConnector connector;

    public static BidibInterface createInstance() {
        LOGGER.info("Create new instance of SpswSerialBidib.");
        SpswSerialBidib instance = new SpswSerialBidib();
        instance.initialize();
        return instance;
    }

    public void initialize() {
        LOGGER.info("Initialize. Create the connector.");
        super.initialize();
        this.connector = new SpswSerialConnector();
        MessageReceiver serialMessageReceiver = this.getMessageReceiver();
        this.connector.setMessageReceiver(serialMessageReceiver);
        this.connector.setLineStatusListener(new LineStatusListener(){

            public void notifyLineStatusChanged(boolean ready) {
                SpswSerialBidib.this.fireCtsChanged(ready);
            }
        });
        this.connector.setDataTransferStatusListener(new DataTransferStatusListener(){

            public void notifySendStarted() {
                SpswSerialBidib.this.fireSendStarted();
            }

            public void notifySendStopped() {
                SpswSerialBidib.this.fireSendStopped();
            }

            public void notifyReceiveStarted() {
                SpswSerialBidib.this.fireReceiveStarted();
            }

            public void notifyReceiveStopped() {
                SpswSerialBidib.this.fireReceiveStopped();
            }
        });
        this.connector.initialize();
    }

    public void close() {
        LOGGER.info("Close is called.");
        if (this.connector.close()) {
            this.cleanupAfterClose(this.getMessageReceiver());
        }
    }

    public List<String> getPortIdentifiers() {
        return this.connector.getPortIdentifiers();
    }

    protected boolean isImplAvaiable() {
        return this.connector.isImplAvaiable();
    }

    protected void internalOpen(String portName, Context context) throws Exception {
        this.connector.internalOpen(portName, context);
    }

    public boolean isOpened() {
        boolean isOpened = false;
        try {
            isOpened = this.connector.isOpened();
        }
        catch (Exception ex) {
            LOGGER.warn("The connector is not available.", (Throwable)ex);
        }
        return isOpened;
    }

    public void send(byte[] data) {
        this.connector.send(data);
    }
}

