/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.spsw.debug;

import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.ser2net.Ser2NetProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.exception.NoAnswerException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.LineEndingEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetDebugReader
implements DebugInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetDebugReader.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"DEBUG_RAW");
    private Ser2NetProvider ser2NetProvider;
    private DebugMessageProcessor messageReceiver;
    private String requestedPortName;
    private ConnectionListener connectionListener;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);
    private final ScheduledExecutorService receiveWorker = Executors.newScheduledThreadPool(1);
    private AtomicBoolean closeInProgress = new AtomicBoolean();
    private BlockingQueue<ByteArrayOutputStream> freeBufferQueue = new LinkedBlockingQueue<ByteArrayOutputStream>();
    private BlockingQueue<ByteArrayOutputStream> receiveQueue = new LinkedBlockingQueue<ByteArrayOutputStream>();
    private Thread receiveQueueWorker;
    private AtomicBoolean receiverRunning = new AtomicBoolean();
    private AtomicLong receiveQueueWorkerThreadId = new AtomicLong();
    private AtomicBoolean receiverWorkerEnabled = new AtomicBoolean();

    public NetDebugReader(DebugMessageProcessor messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public void initialize() {
        for (int i = 0; i < 100; ++i) {
            ByteArrayOutputStream item = new ByteArrayOutputStream(64);
            this.freeBufferQueue.add(item);
        }
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    public DebugMessageProcessor getMessageReceiver() {
        return this.messageReceiver;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    private Ser2NetProvider internalOpen(String portName, int baudRate, Context context) throws IOException {
        this.closeInProgress.set(false);
        this.startReceiveQueueWorker();
        LOGGER.info("The interface port is a valid inet address. Create the Ser2NetProvider instance.");
        String[] splited = portName.split(":");
        String host = splited[0];
        int dataPort = Integer.parseInt(splited[1]);
        LOGGER.info("Create ser2NetProvider with host: {}, dataPort: {}", (Object)host, (Object)dataPort);
        Ser2NetProvider ser2NetProvider = null;
        try {
            ser2NetProvider = new Ser2NetProvider(host, dataPort);
            DataBits dataBits = DataBits.DB_8;
            StopBits stopBits = StopBits.SB_1;
            Parity parity = Parity.NONE;
            Set flowControls = FlowControl.getFC_NONE();
            ser2NetProvider.open(Speed.fromNative((int)baudRate), dataBits, stopBits, parity, flowControls);
        }
        catch (IOException ex) {
            LOGGER.warn("Open connection to remote serial port failed.", (Throwable)ex);
            throw ex;
        }
        this.getConnectionListener().opened(portName);
        this.getMessageReceiver().enable();
        final Ser2NetProvider ser2NetProviderReciever = ser2NetProvider;
        this.receiveWorker.submit(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("The receiverWorker is running.");
                NetDebugReader.this.receiverWorkerEnabled.set(true);
                byte[] receiveData = new byte[1024];
                try (BufferedInputStream in = new BufferedInputStream(ser2NetProviderReciever.getInputStream());){
                    int receivedCount = 0;
                    while ((receivedCount = in.read(receiveData)) > 0 && NetDebugReader.this.receiverWorkerEnabled.get()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Received data from tcp socket, len: {}, data: {}.", (Object)receivedCount, (Object)ByteUtils.bytesToHex((byte[])receiveData, (int)receivedCount));
                        }
                        NetDebugReader.this.receive(receiveData, receivedCount);
                    }
                }
                catch (IOException ex) {
                    if (NetDebugReader.this.receiverWorkerEnabled.get()) {
                        LOGGER.warn("--- Interrupt NetDebugReader-run", (Throwable)ex);
                    }
                    LOGGER.info("The NetDebugReader worker is terminating.");
                }
            }
        });
        return ser2NetProvider;
    }

    public void close() {
        if (this.ser2NetProvider != null) {
            LOGGER.info("Close the port, ser2NetProvider: {}", (Object)this.ser2NetProvider);
            long start = System.currentTimeMillis();
            this.getMessageReceiver().disable();
            this.stopReceiveQueueWorker();
            try {
                LOGGER.info("Close the COM port: {}", (Object)this.ser2NetProvider);
                this.ser2NetProvider.close();
            }
            catch (Exception e) {
                LOGGER.warn("Close port failed.", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.ser2NetProvider = null;
            if (this.connectionListener != null) {
                this.connectionListener.closed(this.requestedPortName);
            }
            this.requestedPortName = null;
        }
    }

    public boolean isOpened() {
        boolean isOpened = false;
        try {
            this.portSemaphore.acquire();
            LOGGER.debug("Check if port is opened: {}", (Object)this.ser2NetProvider);
            isOpened = this.ser2NetProvider != null && this.ser2NetProvider.getOutputStream() != null;
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("OutputStream is not available.", (Throwable)ex);
        }
        finally {
            this.portSemaphore.release();
        }
        return isOpened;
    }

    public void open(String portName, int baudRate, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
        block15: {
            LOGGER.info("Open the port: {}", (Object)portName);
            this.setConnectionListener(connectionListener);
            if (this.ser2NetProvider == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}, baudRate: {}", (Object)portName, (Object)baudRate);
                this.requestedPortName = portName;
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.internalOpen(portName, baudRate, context);
                        LOGGER.info("The port was opened internally.");
                        break block15;
                    }
                    catch (NoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw naex;
                    }
                    catch (Exception e2) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                        try {
                            this.close();
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                    catch (UnsatisfiedLinkError err) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    public void send(String message, LineEndingEnum lineEnding) {
        if (this.ser2NetProvider != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)message);
                }
                OutputStream output = this.ser2NetProvider.getOutputStream();
                output.write(message.getBytes());
                output.write(lineEnding.getValues());
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    public void send(byte[] content) {
        if (this.ser2NetProvider != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)ByteUtils.bytesToHex((byte[])content));
                }
                OutputStream output = this.ser2NetProvider.getOutputStream();
                output.write(content);
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    private void receive(byte[] data, int len) {
        try {
            ByteArrayOutputStream buffer = this.freeBufferQueue.take();
            buffer.write(data, 0, len);
            boolean added = this.receiveQueue.offer(buffer);
            if (!added) {
                LOGGER.error("The message was not added to the receive queue: {}", (Object)ByteUtils.bytesToHex((byte[])buffer.toByteArray()));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Add buffer to receive queue failed.", (Throwable)ex);
        }
    }

    private void startReceiveQueueWorker() {
        this.receiverRunning.set(true);
        LOGGER.info("Start the receiveQueueWorker. Current receiveQueueWorker: {}", (Object)this.receiveQueueWorker);
        this.receiveQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    NetDebugReader.this.processReceiveQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the receive queue was terminated with an exception!", (Throwable)ex);
                }
                LOGGER.info("Process receive queue has finished.");
            }
        }, "receiveQueueWorker");
        try {
            this.receiveQueueWorkerThreadId.set(this.receiveQueueWorker.getId());
            this.receiveQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the receiveQueueWorker failed.", (Throwable)ex);
        }
    }

    private void stopReceiveQueueWorker() {
        LOGGER.info("Stop the receive queue worker.");
        this.receiverRunning.set(false);
        this.receiverWorkerEnabled.set(false);
        try {
            this.receiveQueueWorker.interrupt();
            this.receiveQueueWorker.join(1000L);
            LOGGER.info("receiveQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt receiveQueueWorker failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("Shutdown receiveWorker.");
            this.receiveWorker.shutdown();
            this.receiveWorker.awaitTermination(2000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            LOGGER.warn("Wait for shutdown of receiveWorker failed.", (Throwable)ex);
        }
        this.receiveQueueWorker = null;
    }

    private void processReceiveQueue() {
        LOGGER.info("The receiveQueueWorker is ready for processing.");
        while (this.receiverRunning.get()) {
            ByteArrayOutputStream bytes = null;
            try {
                bytes = this.receiveQueue.take();
                if (bytes != null) {
                    try {
                        this.getMessageReceiver().processMessages(bytes);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                    }
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Get message from receiveQueue failed because thread was interrupted.");
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from receiveQueue failed.", (Throwable)ex);
            }
            finally {
                if (bytes != null) {
                    bytes.reset();
                    this.freeBufferQueue.add(bytes);
                }
            }
            Object var1_1 = null;
        }
        LOGGER.info("The receiveQueueWorker has finished processing.");
        this.receiveQueueWorkerThreadId.set(0L);
    }
}

