package org.bidib.jbidibc.spsw;

import java.util.List;

import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.serial.AbstractSerialBidib;
import org.bidib.jbidibc.serial.LineStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpswSerialBidib extends AbstractSerialBidib {

    private static final Logger LOGGER = LoggerFactory.getLogger(SpswSerialBidib.class);

    private SpswSerialConnector connector;

    /**
     * Get a new initialized instance of SpswSerialBidib.
     *
     * @return the instance of SpswSerialBidib
     */
    public static BidibInterface createInstance(final Context context) {
        LOGGER.info("Create new instance of SpswSerialBidib.");

        SpswSerialBidib instance = new SpswSerialBidib();
        instance.initialize(context);

        return instance;
    }

    @Override
    public void initialize(final Context context) {
        LOGGER.info("Initialize. Create the connector.");
        super.initialize(context);

        connector = new SpswSerialConnector();

        final MessageReceiver serialMessageReceiver = getMessageReceiver();
        connector.setMessageReceiver(serialMessageReceiver);
        connector.setLineStatusListener(new LineStatusListener() {

            @Override
            public void notifyLineStatusChanged(boolean ready, boolean manualEvent) {
                fireCtsChanged(ready, manualEvent);
            }
        });

        initializeConnector(connector);
    }

    @Override
    public void close() {
        LOGGER.info("Close is called.");

        if (connector.close()) {
            super.close();

            cleanupAfterClose(getMessageReceiver());
        }
    }

    @Override
    public List<String> getPortIdentifiers() {
        return connector.getPortIdentifiers();
    }

    @Override
    protected boolean isImplAvaiable() {
        return connector.isImplAvaiable();
    }

    @Override
    protected void internalOpen(String portName, Context context) throws Exception {
        connector.internalOpen(portName, context);
    }

    @Override
    public boolean isOpened() {
        boolean isOpened = false;
        try {
            isOpened = connector.isOpened();
        }
        catch (Exception ex) {
            LOGGER.warn("The connector is not available.", ex);
        }
        return isOpened;
    }

    @Override
    public void send(byte[] data) {
        connector.send(data);
    }

    @Override
    protected AbstractBaseBidib<MessageReceiver> getConnector() {
        return connector;
    }
}
