/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.spsw;

import java.util.List;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.serial.AbstractSerialBidib;
import org.bidib.jbidibc.serial.LineStatusListener;
import org.bidib.jbidibc.spsw.SpswSerialConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpswSerialBidib
extends AbstractSerialBidib {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpswSerialBidib.class);
    private SpswSerialConnector connector;

    public static BidibInterface createInstance(Context context) {
        LOGGER.info("Create new instance of SpswSerialBidib.");
        SpswSerialBidib instance = new SpswSerialBidib();
        instance.initialize(context);
        return instance;
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize. Create the connector.");
        super.initialize(context);
        this.connector = new SpswSerialConnector();
        MessageReceiver serialMessageReceiver = this.getMessageReceiver();
        this.connector.setMessageReceiver(serialMessageReceiver);
        this.connector.setLineStatusListener(new LineStatusListener(){

            public void notifyLineStatusChanged(boolean ready, boolean manualEvent) {
                SpswSerialBidib.this.fireCtsChanged(ready, manualEvent);
            }
        });
        this.initializeConnector(this.connector);
    }

    public void close() {
        LOGGER.info("Close is called.");
        if (this.connector.close()) {
            super.close();
            this.cleanupAfterClose(this.getMessageReceiver());
        }
    }

    public List<String> getPortIdentifiers() {
        return this.connector.getPortIdentifiers();
    }

    protected boolean isImplAvaiable() {
        return this.connector.isImplAvaiable();
    }

    protected void internalOpen(String portName, Context context) throws Exception {
        this.connector.internalOpen(portName, context);
    }

    public boolean isOpened() {
        boolean isOpened = false;
        try {
            isOpened = this.connector.isOpened();
        }
        catch (Exception ex) {
            LOGGER.warn("The connector is not available.", (Throwable)ex);
        }
        return isOpened;
    }

    public void send(byte[] data) {
        this.connector.send(data);
    }

    protected AbstractBaseBidib<MessageReceiver> getConnector() {
        return this.connector;
    }
}

