/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.spsw.debug;

import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.ser2net.Ser2NetProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.debug.AbstractDebugReader;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.LineEndingEnum;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetDebugReader
extends AbstractDebugReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetDebugReader.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"DEBUG_RAW");
    private Ser2NetProvider ser2NetProvider;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);
    private final ScheduledExecutorService receiveWorker = Executors.newScheduledThreadPool(1);
    private AtomicBoolean closeInProgress = new AtomicBoolean();
    private AtomicBoolean receiverWorkerEnabled = new AtomicBoolean();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream(2048);

    public NetDebugReader(DebugMessageProcessor messageReceiver) {
        super(messageReceiver);
    }

    public void initialize() {
    }

    public List<String> getPortIdentifiers() {
        return Collections.emptyList();
    }

    private Ser2NetProvider internalOpen(String portName, int baudRate, Context context) throws IOException {
        this.closeInProgress.set(false);
        this.startReceiveQueueWorker();
        LOGGER.info("The interface port is a valid inet address. Create the Ser2NetProvider instance.");
        String[] splited = portName.split(":");
        String host = splited[0];
        int dataPort = Integer.parseInt(splited[1]);
        LOGGER.info("Create ser2NetProvider with host: {}, dataPort: {}", (Object)host, (Object)dataPort);
        Ser2NetProvider ser2NetProvider = null;
        try {
            DataBits dataBits = DataBits.DB_8;
            StopBits stopBits = StopBits.SB_1;
            Parity parity = Parity.NONE;
            Set flowControls = FlowControl.getFC_NONE();
            ser2NetProvider = new Ser2NetProvider(host, dataPort, Speed.fromNative((int)baudRate), dataBits, stopBits, parity, flowControls);
        }
        catch (IOException ex) {
            LOGGER.warn("Open connection to remote serial port failed.", (Throwable)ex);
            throw ex;
        }
        this.getConnectionListener().opened(portName);
        this.getMessageReceiver().enable();
        final Ser2NetProvider ser2NetProviderReciever = ser2NetProvider;
        this.receiveWorker.submit(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("The receiverWorker is running.");
                NetDebugReader.this.receiverWorkerEnabled.set(true);
                byte[] receiveData = new byte[1024];
                try (BufferedInputStream in = new BufferedInputStream(ser2NetProviderReciever.getInputStream());){
                    int receivedCount = 0;
                    while ((receivedCount = in.read(receiveData)) > 0 && NetDebugReader.this.receiverWorkerEnabled.get()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Received data from tcp socket, len: {}, data: {}.", (Object)receivedCount, (Object)ByteUtils.bytesToHex((byte[])receiveData, (int)receivedCount));
                        }
                        NetDebugReader.this.receive(receiveData, receivedCount);
                    }
                }
                catch (IOException ex) {
                    if (NetDebugReader.this.receiverWorkerEnabled.get()) {
                        LOGGER.warn("--- Interrupt NetDebugReader-run", (Throwable)ex);
                    }
                    LOGGER.info("The NetDebugReader worker is terminating.");
                }
            }
        });
        return ser2NetProvider;
    }

    public void close() {
        if (this.ser2NetProvider != null) {
            LOGGER.info("Close the port, ser2NetProvider: {}", (Object)this.ser2NetProvider);
            long start = System.currentTimeMillis();
            this.getMessageReceiver().disable();
            this.stopReceiveQueueWorker();
            try {
                LOGGER.info("Close the COM port: {}", (Object)this.ser2NetProvider);
                this.ser2NetProvider.close();
            }
            catch (Exception e) {
                LOGGER.warn("Close port failed.", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.ser2NetProvider = null;
            if (this.getConnectionListener() != null) {
                this.getConnectionListener().closed(this.getRequestedPortName());
            }
            this.setRequestedPortName(null);
        }
    }

    public boolean isOpened() {
        boolean isOpened = false;
        try {
            this.portSemaphore.acquire();
            LOGGER.debug("Check if port is opened: {}", (Object)this.ser2NetProvider);
            isOpened = this.ser2NetProvider != null && this.ser2NetProvider.getOutputStream() != null;
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("OutputStream is not available.", (Throwable)ex);
        }
        finally {
            this.portSemaphore.release();
        }
        return isOpened;
    }

    public void open(String portName, int baudRate, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
        block15: {
            LOGGER.info("Open the port: {}", (Object)portName);
            this.setConnectionListener(connectionListener);
            if (this.ser2NetProvider == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}, baudRate: {}", (Object)portName, (Object)baudRate);
                this.setRequestedPortName(portName);
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.internalOpen(portName, baudRate, context);
                        LOGGER.info("The port was opened internally.");
                        break block15;
                    }
                    catch (NoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw naex;
                    }
                    catch (Exception e2) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                        try {
                            this.close();
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                    catch (UnsatisfiedLinkError err) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    public void send(String message, LineEndingEnum lineEnding) {
        if (this.ser2NetProvider != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)message);
                }
                OutputStream output = this.ser2NetProvider.getOutputStream();
                output.write(message.getBytes());
                output.write(lineEnding.getValues());
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    public void send(byte[] content) {
        if (this.ser2NetProvider != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)ByteUtils.bytesToHex((byte[])content));
                }
                OutputStream output = this.ser2NetProvider.getOutputStream();
                output.write(content);
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    private void receive(byte[] data, int len) {
        try {
            this.output.reset();
            this.output.write(data, 0, len);
            this.addDataToReceiveQueue(this.output);
        }
        catch (Exception ex) {
            LOGGER.warn("Add buffer to receive queue failed.", (Throwable)ex);
        }
    }
}

