/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.data;

import java.io.Serializable;
import java.util.ArrayList;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.util.Util;

public class ArrrayListDataPoints
implements Comparable<ArrrayListDataPoints>,
Serializable {
    static final long serialVersionUID = 8439427205918618172L;
    private ArrayList<Double> data;
    private Double sum = null;
    private Double sumExceptLast = null;
    private JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType valueDisplayType;

    public ArrrayListDataPoints(ArrayList<Double> data, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType valueDisplayType) {
        this.data = data;
        this.valueDisplayType = valueDisplayType;
    }

    public void setDataSortingType(JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType valueDisplayType) {
        this.valueDisplayType = valueDisplayType;
    }

    public ArrayList<Double> getData() {
        return this.data;
    }

    public void setData(ArrayList<Double> data) {
        this.data = data;
        this.sum = null;
    }

    public double getSum() {
        if (this.sum != null && this.sumExceptLast != null) {
            return this.sum;
        }
        this.sum = 0.0;
        this.sumExceptLast = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            Double temp = this.data.get(i);
            this.sum = this.sum + temp;
            if (i >= this.data.size() - 1) continue;
            this.sumExceptLast = this.sumExceptLast + temp;
        }
        return this.sum;
    }

    public double getSumExceptLast() {
        if (this.sum != null && this.sumExceptLast != null) {
            return this.sumExceptLast;
        }
        this.sum = 0.0;
        this.sumExceptLast = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            Double temp = this.data.get(i);
            this.sum = this.sum + temp;
            if (i >= this.data.size() - 1) continue;
            this.sumExceptLast = this.sumExceptLast + temp;
        }
        return this.sumExceptLast;
    }

    public String toString() {
        String valuesAsString = "";
        for (double temp : this.data) {
            valuesAsString = valuesAsString + Util.roundDouble(temp, 2);
        }
        return valuesAsString;
    }

    @Override
    public int compareTo(ArrrayListDataPoints o) {
        if (this.valueDisplayType == null || this.valueDisplayType == JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers) {
            return Double.compare(this.getSum(), o.getSum());
        }
        if (this.valueDisplayType == JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumExceptLastNumber) {
            return Double.compare(this.getSumExceptLast(), o.getSumExceptLast());
        }
        if (this.getData().isEmpty() && o.getData().isEmpty()) {
            return 0;
        }
        if (this.getData().isEmpty() && !o.getData().isEmpty()) {
            return 1;
        }
        if (!this.getData().isEmpty() && o.getData().isEmpty()) {
            return -1;
        }
        return Double.compare(this.getData().get(0), o.getData().get(0));
    }
}

