/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.SignificantStatisticalCategoryDataset;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import no.uib.jsparklines.renderers.util.StatisticalBarChartColorRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;

public class JSparklinesErrorBarChartTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private double minimumChartValue = 0.05;
    private double tooltipLowerValue = 0.01;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private JLabel valueLabel;
    private JLabel signifianceLabel;
    private double maxValue = 1.0;
    private double minValue = 0.0;
    private Color negativeValuesColor = new Color(51, 51, 255);
    private Color positiveValuesColor = new Color(255, 51, 51);
    private Color tableCellBarChartColorBig = new Color(110, 196, 97);
    private Color tableCellBarChartColorSmall = new Color(247, 247, 23);
    private int widthOfValueLabel = 40;
    private boolean showNumberAndChart = false;
    private DecimalFormat numberFormat = new DecimalFormat("0.00");
    private int labelHorizontalAlignement = 4;
    private boolean indicateSignificance = false;
    private Color plotBackgroundColor = null;
    private GradientColorCoding.ColorGradient currentColorGradient = GradientColorCoding.ColorGradient.RedBlackBlue;
    private boolean positiveColorGradient = false;
    private boolean gradientColoring = false;
    private float errorBarWidth = 4.0f;

    public JSparklinesErrorBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, boolean largeNumbersAreGood) {
        this.positiveValuesColor = largeNumbersAreGood ? this.tableCellBarChartColorBig : this.tableCellBarChartColorSmall;
        this.maxValue = maxValue;
        this.setUpRendererAndChart(plotOrientation);
    }

    public JSparklinesErrorBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, Color positiveValuesColor) {
        this(plotOrientation, 0.0, maxValue, null, positiveValuesColor);
    }

    public JSparklinesErrorBarChartTableCellRenderer(PlotOrientation plotOrientation, Double minValue, Double maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.setUpRendererAndChart(plotOrientation);
    }

    public JSparklinesErrorBarChartTableCellRenderer(PlotOrientation plotOrientation, Double minValue, Double maxValue, Color negativeValuesColor, Color positiveValuesColor) {
        this.negativeValuesColor = negativeValuesColor;
        this.positiveValuesColor = positiveValuesColor;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.setUpRendererAndChart(plotOrientation);
    }

    private void setUpRendererAndChart(PlotOrientation plotOrientation) {
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        this.signifianceLabel = new JLabel("");
        this.signifianceLabel.setHorizontalAlignment(0);
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add((Component)this.chartPanel);
        this.add(this.signifianceLabel);
    }

    public void setGradientColoring(GradientColorCoding.ColorGradient colorGradient, boolean positiveColorGradient) {
        this.setGradientColoring(colorGradient, positiveColorGradient, null);
    }

    public void setGradientColoring(GradientColorCoding.ColorGradient colorGradient, boolean positiveColorGradient, Color plotBackgroundColor) {
        this.gradientColoring = colorGradient != null;
        this.positiveColorGradient = positiveColorGradient;
        if (plotBackgroundColor != null) {
            this.plotBackgroundColor = plotBackgroundColor;
        }
        this.currentColorGradient = colorGradient;
        if (this.gradientColoring && Math.abs(this.minValue) > this.maxValue) {
            this.maxValue = Math.abs(this.minValue);
        }
    }

    public void setBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setErrorBarWidth(float errorBarWidth) {
        this.errorBarWidth = errorBarWidth;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof String) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof DefaultStatisticalCategoryDataset) {
            DefaultStatisticalCategoryDataset tempSet = (DefaultStatisticalCategoryDataset)value;
            this.setToolTipText("<html>Intensity: " + JSparklinesErrorBarChartTableCellRenderer.roundDouble((Double)tempSet.getMeanValue(0, 0), 4) + "<br>" + "STDEV: " + JSparklinesErrorBarChartTableCellRenderer.roundDouble((Double)tempSet.getStdDevValue(0, 0), 4) + "</html>");
            if (this.indicateSignificance && value instanceof SignificantStatisticalCategoryDataset && ((SignificantStatisticalCategoryDataset)((Object)value)).isSignificant() != null && ((SignificantStatisticalCategoryDataset)((Object)value)).isSignificant().booleanValue()) {
                this.signifianceLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/asterisk.png")));
            }
            if (this.indicateSignificance) {
                this.signifianceLabel.setMinimumSize(new Dimension(10, 0));
            } else {
                this.signifianceLabel.setMinimumSize(new Dimension(0, 0));
            }
            if (this.showNumberAndChart) {
                this.numberFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
                double temp = tempSet.getMeanValue(0, 0).doubleValue();
                this.valueLabel.setText(this.numberFormat.format(temp));
                Color bg = c.getBackground();
                this.valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
                if (this.labelHorizontalAlignement == 4) {
                    this.valueLabel.setText(this.valueLabel.getText() + "  ");
                } else if (this.labelHorizontalAlignement == 2) {
                    this.valueLabel.setText("  " + this.valueLabel.getText());
                }
                this.valueLabel.setForeground(c.getForeground());
                this.valueLabel.setHorizontalAlignment(this.labelHorizontalAlignement);
                this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
                this.valueLabel.setSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
                this.valueLabel.setMaximumSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
                this.valueLabel.setPreferredSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
                this.valueLabel.setVisible(true);
            } else {
                this.valueLabel.setMinimumSize(new Dimension(0, 0));
                this.valueLabel.setSize(0, 0);
                this.valueLabel.setVisible(false);
            }
        }
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.getRangeAxis().setRange(this.minValue, this.maxValue);
        plot.setDataset((CategoryDataset)((DefaultStatisticalCategoryDataset)value));
        plot.setOutlineVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        if (value instanceof DefaultStatisticalCategoryDataset) {
            StatisticalBarChartColorRenderer renderer = null;
            DefaultStatisticalCategoryDataset tempSet = (DefaultStatisticalCategoryDataset)value;
            if (this.gradientColoring) {
                Color currentColor = GradientColorCoding.findGradientColor((Double)tempSet.getMeanValue(0, 0), this.minValue, this.maxValue, this.currentColorGradient, this.positiveColorGradient);
                renderer = new StatisticalBarChartColorRenderer(currentColor);
            } else {
                renderer = (Double)tempSet.getMeanValue(0, 0) >= 0.0 ? new StatisticalBarChartColorRenderer(this.positiveValuesColor) : new StatisticalBarChartColorRenderer(this.negativeValuesColor);
            }
            renderer.setErrorIndicatorStroke(new BasicStroke(this.errorBarWidth));
            plot.setRenderer((CategoryItemRenderer)renderer);
        }
        if (this.plotBackgroundColor != null && !isSelected) {
            plot.setBackgroundPaint((Paint)this.plotBackgroundColor);
            this.chartPanel.setBackground(this.plotBackgroundColor);
            this.chart.setBackgroundPaint((Paint)this.plotBackgroundColor);
        } else {
            Color bg = c.getBackground();
            plot.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chartPanel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chart.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        return this;
    }

    public void setNegativeValuesColor(Color negativeValuesColor) {
        this.negativeValuesColor = negativeValuesColor;
    }

    public void setPositiveValuesColor(Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
    }

    private static double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    public double getMinimumChartValue() {
        return this.minimumChartValue;
    }

    public void setMinimumChartValue(double minimumChartValue) {
        this.minimumChartValue = minimumChartValue;
    }

    public double getTooltipLowerValue() {
        return this.tooltipLowerValue;
    }

    public void setTooltipLowerValue(double tooltipLowerValue) {
        this.tooltipLowerValue = tooltipLowerValue;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.numberFormat = numberFormat;
    }

    public void showSignificance(boolean indicateSignificance) {
        this.indicateSignificance = indicateSignificance;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, font, horizontalAlignement, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.labelHorizontalAlignement = horizontalAlignement;
        this.valueLabel.setFont(font);
        this.numberFormat = numberFormat;
    }
}

