/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.JSparklinesMultiLabelDataset;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;

public class JSparklinesMultiLabelTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private Color plotBackgroundColor = null;
    private boolean circle = false;

    public JSparklinesMultiLabelTableCellRenderer() {
        this.setUpRendererAndChart();
    }

    public void setCircle(boolean circle) {
        this.circle = circle;
    }

    private void setUpRendererAndChart() {
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.setLayout(new BoxLayout(this, 2));
    }

    public void setBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof String) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        String tooltips = null;
        if (!(value instanceof JSparklinesMultiLabelDataset)) throw new IllegalArgumentException("JSparklinesMultiLabelTableCellRenderer only supports JSparklinesMultiLabelDataset objects!");
        JSparklinesMultiLabelDataset dataset = (JSparklinesMultiLabelDataset)value;
        if (dataset.getLabels().size() == 1) {
            this.chart = this.createChart(dataset.getLabels().get(0).getColor());
            tooltips = dataset.getLabels().get(0).getLabel();
        } else if (dataset.getLabels().size() == 2) {
            this.chart = this.createChart(dataset.getLabels().get(0).getColor(), dataset.getLabels().get(1).getColor());
            tooltips = this.circle ? "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(1).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(0).getLabel() + "</td></tr></table></html>" : "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(0).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(1).getLabel() + "</td></tr></table></html>";
        } else if (dataset.getLabels().size() == 3) {
            this.chart = this.createChart(dataset.getLabels().get(0).getColor(), dataset.getLabels().get(1).getColor(), dataset.getLabels().get(2).getColor());
            tooltips = this.circle ? "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(1).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(0).getLabel() + "</td></tr>" + "<tr><td>" + dataset.getLabels().get(2).getLabel() + "</td>" + "<td></td></tr></table></html>" : "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(0).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(1).getLabel() + "</td></tr>" + "<tr><td></td>" + "<td>" + dataset.getLabels().get(2).getLabel() + "</td></tr></table></html>";
        } else {
            if (dataset.getLabels().size() != 4) throw new IllegalArgumentException("JSparklinesMultiLabelTableCellRenderer only supports JSparklinesMultiLabelDataset objects of size 1-4!");
            this.chart = this.createChart(dataset.getLabels().get(0).getColor(), dataset.getLabels().get(1).getColor(), dataset.getLabels().get(2).getColor(), dataset.getLabels().get(3).getColor(), true);
            tooltips = this.circle ? "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(3).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(0).getLabel() + "</td></tr>" + "<tr><td>" + dataset.getLabels().get(2).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(1).getLabel() + "</td></tr></table></html>" : "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(0).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(1).getLabel() + "</td></tr>" + "<tr><td>" + dataset.getLabels().get(3).getLabel() + "</td>" + "<td>" + dataset.getLabels().get(2).getLabel() + "</td></tr></table></html>";
        }
        this.setToolTipText(tooltips);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        this.chartPanel = new ChartPanel(this.chart);
        if (this.plotBackgroundColor != null && !isSelected) {
            this.chart.getPlot().setBackgroundPaint((Paint)this.plotBackgroundColor);
            this.chartPanel.setBackground(this.plotBackgroundColor);
            this.chart.setBackgroundPaint((Paint)this.plotBackgroundColor);
        } else {
            Color bg = c.getBackground();
            this.chart.getPlot().setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chartPanel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chart.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        if (isSelected) {
            this.chart.getPlot().setOutlinePaint((Paint)Color.WHITE);
        } else {
            this.chart.getPlot().setOutlinePaint((Paint)Color.DARK_GRAY);
        }
        this.removeAll();
        this.add((Component)this.chartPanel);
        return this;
    }

    private JFreeChart createChart(Color labelA) {
        return this.createChart(labelA, labelA, labelA, labelA, false);
    }

    private JFreeChart createChart(Color labelA, Color labelB) {
        return this.createChart(labelA, labelA, labelB, labelB, false);
    }

    private JFreeChart createChart(Color labelA, Color labelB, Color labelC) {
        return this.createChart(labelA, labelA, labelC, labelB, false);
    }

    private JFreeChart createChart(Color labelA, Color labelB, Color labelC, Color labelD, boolean all) {
        PiePlot plot;
        if (this.circle) {
            DefaultPieDataset pieDataset = new DefaultPieDataset();
            pieDataset.setValue((Comparable)((Object)"A"), 1.0);
            pieDataset.setValue((Comparable)((Object)"B"), 1.0);
            pieDataset.setValue((Comparable)((Object)"C"), 1.0);
            pieDataset.setValue((Comparable)((Object)"D"), 1.0);
            this.chart = ChartFactory.createPieChart(null, (PieDataset)pieDataset, (boolean)false, (boolean)false, (boolean)false);
            plot = (PiePlot)this.chart.getPlot();
            plot.setCircular(true);
            plot.setLabelGenerator(null);
            plot.setShadowXOffset(0.0);
            plot.setShadowYOffset(0.0);
            plot.setSectionOutlinesVisible(false);
            plot.setSectionPaint((Comparable)((Object)"A"), (Paint)labelA);
            plot.setSectionPaint((Comparable)((Object)"B"), (Paint)labelB);
            plot.setSectionPaint((Comparable)((Object)"C"), (Paint)labelC);
            plot.setSectionPaint((Comparable)((Object)"D"), (Paint)labelD);
            plot.setOutlineStroke((Stroke)new BasicStroke(20.0f));
            this.chart.getPlot().setOutlineVisible(false);
        } else {
            LookupPaintScale paintScale = new LookupPaintScale(0.0, 4.0, (Paint)Color.lightGray);
            if (all) {
                paintScale.add(1.0, (Paint)labelD);
                paintScale.add(2.0, (Paint)labelA);
                paintScale.add(3.0, (Paint)labelC);
                paintScale.add(4.0, (Paint)labelB);
            } else {
                paintScale.add(1.0, (Paint)labelA);
                paintScale.add(2.0, (Paint)labelB);
                paintScale.add(3.0, (Paint)labelC);
                paintScale.add(4.0, (Paint)labelD);
            }
            NumberAxis xAxis = new NumberAxis(null);
            NumberAxis yAxis = new NumberAxis(null);
            XYBlockRenderer renderer = new XYBlockRenderer();
            renderer.setPaintScale((PaintScale)paintScale);
            double[][] tempXYZData = new double[3][4];
            tempXYZData[0][0] = 0.0;
            tempXYZData[1][0] = 0.0;
            tempXYZData[2][0] = 1.0;
            tempXYZData[0][1] = 0.0;
            tempXYZData[1][1] = 1.0;
            tempXYZData[2][1] = 2.0;
            tempXYZData[0][2] = 1.0;
            tempXYZData[1][2] = 0.0;
            tempXYZData[2][2] = 3.0;
            tempXYZData[0][3] = 1.0;
            tempXYZData[1][3] = 1.0;
            tempXYZData[2][3] = 4.0;
            DefaultXYZDataset dataset2 = new DefaultXYZDataset();
            dataset2.addSeries((Comparable)((Object)"Series 1"), tempXYZData);
            plot = new XYPlot((XYDataset)dataset2, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
            plot.setBackgroundPaint((Paint)Color.WHITE);
            ((XYPlot)plot).setDomainGridlinePaint((Paint)Color.white);
            ((XYPlot)plot).setRangeGridlinePaint((Paint)Color.white);
            ((XYPlot)plot).getRangeAxis().setVisible(false);
            ((XYPlot)plot).getDomainAxis().setVisible(false);
            ((XYPlot)plot).setRangeGridlinesVisible(false);
            ((XYPlot)plot).setDomainGridlinesVisible(false);
            plot.setOutlineStroke((Stroke)new BasicStroke(20.0f));
        }
        JFreeChart tempChart = new JFreeChart(null, (Plot)plot);
        tempChart.removeLegend();
        tempChart.setBackgroundPaint((Paint)Color.white);
        return tempChart;
    }
}

