/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYZDataset;

public class JSparklinesBubbleHeatMapTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private double minimumChartValue = 1.0;
    private double tooltipLowerValue = 0.01;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private double maxAbsValue = 1.0;
    private boolean showNumbers = false;
    private GradientColorCoding.ColorGradient currentColorGradient = GradientColorCoding.ColorGradient.RedBlackBlue;
    private boolean positiveColorGradient = false;

    public JSparklinesBubbleHeatMapTableCellRenderer(Double maxAbsValue, GradientColorCoding.ColorGradient colorGradient, boolean positiveColorGradient) {
        this.maxAbsValue = maxAbsValue;
        this.currentColorGradient = colorGradient;
        this.positiveColorGradient = positiveColorGradient;
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
    }

    public void setGradientColoring(GradientColorCoding.ColorGradient colorGradient, boolean positiveColorGradient) {
        this.currentColorGradient = colorGradient;
        this.positiveColorGradient = positiveColorGradient;
    }

    public void setMaxValue(double maxAbsValue) {
        this.maxAbsValue = maxAbsValue;
    }

    public void showNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        double[][] data;
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        boolean supportedObjectType = false;
        if (value != null && (value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte)) {
            supportedObjectType = true;
        }
        if (!supportedObjectType) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (this.showNumbers) {
            if (value instanceof Double || value instanceof Float) {
                if (value instanceof Float) {
                    value = ((Float)value).doubleValue();
                }
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, JSparklinesBubbleHeatMapTableCellRenderer.roundDouble((Double)value, 2), isSelected, hasFocus, row, column);
                Double d = new Double("" + value);
                if (Math.abs(d) < this.tooltipLowerValue) {
                    c.setToolTipText("" + JSparklinesBubbleHeatMapTableCellRenderer.roundDouble(new Double("" + value), 8));
                }
            } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
                if (value instanceof Short) {
                    value = ((Short)value).intValue();
                } else if (value instanceof Long) {
                    value = ((Long)value).intValue();
                } else if (value instanceof Byte) {
                    value = ((Byte)value).intValue();
                }
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, (Integer)value, isSelected, hasFocus, row, column);
            }
            ((JLabel)c).setHorizontalAlignment(0);
            return c;
        }
        if (value instanceof Double || value instanceof Float) {
            if (value instanceof Float) {
                value = ((Float)value).doubleValue();
            }
            Double d = new Double("" + value);
            if (Math.abs(d) < this.tooltipLowerValue) {
                this.setToolTipText("" + JSparklinesBubbleHeatMapTableCellRenderer.roundDouble(new Double("" + value), 8));
            } else {
                this.setToolTipText("" + JSparklinesBubbleHeatMapTableCellRenderer.roundDouble(new Double("" + value), 2));
            }
        } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
            this.setToolTipText("" + value);
        }
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        DefaultXYZDataset xyzDataset = new DefaultXYZDataset();
        Color bubbleColor = Color.BLACK;
        if (value instanceof Double || value instanceof Float) {
            if (value instanceof Float) {
                value = ((Float)value).doubleValue();
            }
            if ((Double)value < this.minimumChartValue && (Double)value > 0.0) {
                value = this.minimumChartValue;
            }
            data = new double[3][1];
            data[0][0] = this.maxAbsValue / 2.0;
            data[1][0] = this.maxAbsValue / 2.0;
            data[2][0] = (Double)value < 0.0 ? Math.abs((Double)value) : (Double)value;
            xyzDataset.addSeries((Comparable)((Object)"1"), data);
            bubbleColor = GradientColorCoding.findGradientColor((double)((Double)value), -this.maxAbsValue, this.maxAbsValue, this.currentColorGradient, this.positiveColorGradient);
        } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
            if (value instanceof Short) {
                value = ((Short)value).intValue();
            } else if (value instanceof Long) {
                value = ((Long)value).intValue();
            } else if (value instanceof Byte) {
                value = ((Byte)value).intValue();
            }
            if ((double)((Integer)value).intValue() < this.minimumChartValue && (Integer)value > 0) {
                value = Double.valueOf(this.minimumChartValue).intValue();
            }
            data = new double[3][1];
            data[0][0] = this.maxAbsValue / 2.0;
            data[1][0] = this.maxAbsValue / 2.0;
            data[2][0] = ((Integer)value).doubleValue();
            data[2][0] = ((Integer)value).doubleValue() < 0.0 ? Math.abs(((Integer)value).doubleValue()) : (Double)value;
            xyzDataset.addSeries((Comparable)((Object)"1"), data);
            bubbleColor = GradientColorCoding.findGradientColor(((Integer)value).doubleValue(), -this.maxAbsValue, this.maxAbsValue, this.currentColorGradient, this.positiveColorGradient);
        }
        this.chart = ChartFactory.createBubbleChart(null, null, null, xyzDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = this.chart.getXYPlot();
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getRangeAxis().setUpperMargin(0.0);
        plot.getRangeAxis().setLowerMargin(0.0);
        plot.getDomainAxis().setRange(this.maxAbsValue * 0.4, this.maxAbsValue * 0.6);
        plot.getRangeAxis().setRange(this.maxAbsValue * 0.25, this.maxAbsValue * 0.75);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainGridlinesVisible(false);
        plot.getRenderer().setSeriesPaint(0, bubbleColor);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setBackground(c.getBackground());
        this.removeAll();
        this.add(this.chartPanel);
        this.chart.getPlot().setOutlineVisible(false);
        plot.setBackgroundPaint(c.getBackground());
        this.chartPanel.setBackground(c.getBackground());
        this.chart.setBackgroundPaint(c.getBackground());
        return this;
    }

    private static double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    public double getMinimumChartValue() {
        return this.minimumChartValue;
    }

    public void setMinimumChartValue(double minimumChartValue) {
        this.minimumChartValue = minimumChartValue;
    }

    public double getTooltipLowerValue() {
        return this.tooltipLowerValue;
    }

    public void setTooltipLowerValue(double tooltipLowerValue) {
        this.tooltipLowerValue = tooltipLowerValue;
    }
}

