/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.JSparklinesMultiLabelDataset;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultXYZDataset;

public class JSparklinesMultiLabelTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private Color plotBackgroundColor = null;
    private boolean circle = false;

    public JSparklinesMultiLabelTableCellRenderer() {
        this.setUpRendererAndChart();
    }

    public void setCircle(boolean circle) {
        this.circle = circle;
    }

    private void setUpRendererAndChart() {
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.setLayout(new BoxLayout(this, 2));
    }

    public void setBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null || !(value instanceof JSparklinesMultiLabelDataset)) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        JSparklinesMultiLabelDataset dataset = (JSparklinesMultiLabelDataset)value;
        String tooltips = null;
        if (dataset.getLabels().size() == 1) {
            this.chart = this.createChart(dataset.getLabels().get(0).getColor());
            tooltips = dataset.getLabels().get(0).getLabel();
        } else if (dataset.getLabels().size() == 2) {
            this.chart = this.createChart(dataset.getLabels().get(0).getColor(), dataset.getLabels().get(1).getColor());
            tooltips = this.circle ? "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(1).getLabel() + "</td><td>" + dataset.getLabels().get(0).getLabel() + "</td></tr></table></html>" : "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(0).getLabel() + "</td><td>" + dataset.getLabels().get(1).getLabel() + "</td></tr></table></html>";
        } else if (dataset.getLabels().size() == 3) {
            this.chart = this.createChart(dataset.getLabels().get(0).getColor(), dataset.getLabels().get(1).getColor(), dataset.getLabels().get(2).getColor());
            tooltips = this.circle ? "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(1).getLabel() + "</td><td>" + dataset.getLabels().get(0).getLabel() + "</td></tr><tr><td>" + dataset.getLabels().get(2).getLabel() + "</td><td></td></tr></table></html>" : "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(0).getLabel() + "</td><td>" + dataset.getLabels().get(1).getLabel() + "</td></tr><tr><td></td><td>" + dataset.getLabels().get(2).getLabel() + "</td></tr></table></html>";
        } else if (dataset.getLabels().size() == 4) {
            this.chart = this.createChart(dataset.getLabels().get(0).getColor(), dataset.getLabels().get(1).getColor(), dataset.getLabels().get(2).getColor(), dataset.getLabels().get(3).getColor(), true);
            tooltips = this.circle ? "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(3).getLabel() + "</td><td>" + dataset.getLabels().get(0).getLabel() + "</td></tr><tr><td>" + dataset.getLabels().get(2).getLabel() + "</td><td>" + dataset.getLabels().get(1).getLabel() + "</td></tr></table></html>" : "<html><table border=\"0\"><tr><td>" + dataset.getLabels().get(0).getLabel() + "</td><td>" + dataset.getLabels().get(1).getLabel() + "</td></tr><tr><td>" + dataset.getLabels().get(3).getLabel() + "</td><td>" + dataset.getLabels().get(2).getLabel() + "</td></tr></table></html>";
        } else {
            throw new IllegalArgumentException("JSparklinesMultiLabelTableCellRenderer only supports JSparklinesMultiLabelDataset objects of size 1-4!");
        }
        this.setToolTipText(tooltips);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        this.chartPanel = new ChartPanel(this.chart);
        if (this.plotBackgroundColor != null && !isSelected) {
            this.chart.getPlot().setBackgroundPaint(this.plotBackgroundColor);
            this.chartPanel.setBackground(this.plotBackgroundColor);
            this.chart.setBackgroundPaint(this.plotBackgroundColor);
        } else {
            Color bg = c.getBackground();
            this.chart.getPlot().setBackgroundPaint(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chartPanel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chart.setBackgroundPaint(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        if (isSelected) {
            this.chart.getPlot().setOutlinePaint(Color.WHITE);
        } else {
            this.chart.getPlot().setOutlinePaint(Color.DARK_GRAY);
        }
        this.removeAll();
        this.add(this.chartPanel);
        return this;
    }

    private JFreeChart createChart(Color labelA) {
        return this.createChart(labelA, labelA, labelA, labelA, false);
    }

    private JFreeChart createChart(Color labelA, Color labelB) {
        return this.createChart(labelA, labelA, labelB, labelB, false);
    }

    private JFreeChart createChart(Color labelA, Color labelB, Color labelC) {
        return this.createChart(labelA, labelA, labelC, labelB, false);
    }

    private JFreeChart createChart(Color labelA, Color labelB, Color labelC, Color labelD, boolean all) {
        Plot plot;
        if (this.circle) {
            DefaultPieDataset pieDataset = new DefaultPieDataset();
            pieDataset.setValue((Comparable)((Object)"A"), 1.0);
            pieDataset.setValue((Comparable)((Object)"B"), 1.0);
            pieDataset.setValue((Comparable)((Object)"C"), 1.0);
            pieDataset.setValue((Comparable)((Object)"D"), 1.0);
            this.chart = ChartFactory.createPieChart(null, (PieDataset)pieDataset, false, false, false);
            plot = (PiePlot)this.chart.getPlot();
            ((PiePlot)plot).setCircular(true);
            ((PiePlot)plot).setLabelGenerator(null);
            ((PiePlot)plot).setShadowXOffset(0.0);
            ((PiePlot)plot).setShadowYOffset(0.0);
            ((PiePlot)plot).setSectionOutlinesVisible(false);
            ((PiePlot)plot).setSectionPaint((Comparable)((Object)"A"), labelA);
            ((PiePlot)plot).setSectionPaint((Comparable)((Object)"B"), labelB);
            ((PiePlot)plot).setSectionPaint((Comparable)((Object)"C"), labelC);
            ((PiePlot)plot).setSectionPaint((Comparable)((Object)"D"), labelD);
            plot.setOutlineStroke(new BasicStroke(20.0f));
            this.chart.getPlot().setOutlineVisible(false);
        } else {
            LookupPaintScale paintScale = new LookupPaintScale(0.0, 4.0, Color.lightGray);
            if (all) {
                paintScale.add(1.0, (Paint)labelD);
                paintScale.add(2.0, (Paint)labelA);
                paintScale.add(3.0, (Paint)labelC);
                paintScale.add(4.0, (Paint)labelB);
            } else {
                paintScale.add(1.0, (Paint)labelA);
                paintScale.add(2.0, (Paint)labelB);
                paintScale.add(3.0, (Paint)labelC);
                paintScale.add(4.0, (Paint)labelD);
            }
            NumberAxis xAxis = new NumberAxis(null);
            NumberAxis yAxis = new NumberAxis(null);
            XYBlockRenderer renderer = new XYBlockRenderer();
            renderer.setPaintScale(paintScale);
            double[][] tempXYZData = new double[3][4];
            tempXYZData[0][0] = 0.0;
            tempXYZData[1][0] = 0.0;
            tempXYZData[2][0] = 1.0;
            tempXYZData[0][1] = 0.0;
            tempXYZData[1][1] = 1.0;
            tempXYZData[2][1] = 2.0;
            tempXYZData[0][2] = 1.0;
            tempXYZData[1][2] = 0.0;
            tempXYZData[2][2] = 3.0;
            tempXYZData[0][3] = 1.0;
            tempXYZData[1][3] = 1.0;
            tempXYZData[2][3] = 4.0;
            DefaultXYZDataset dataset2 = new DefaultXYZDataset();
            dataset2.addSeries((Comparable)((Object)"Series 1"), tempXYZData);
            plot = new XYPlot(dataset2, xAxis, yAxis, renderer);
            plot.setBackgroundPaint(Color.WHITE);
            ((XYPlot)plot).setDomainGridlinePaint(Color.white);
            ((XYPlot)plot).setRangeGridlinePaint(Color.white);
            ((XYPlot)plot).getRangeAxis().setVisible(false);
            ((XYPlot)plot).getDomainAxis().setVisible(false);
            ((XYPlot)plot).setRangeGridlinesVisible(false);
            ((XYPlot)plot).setDomainGridlinesVisible(false);
            plot.setOutlineStroke(new BasicStroke(20.0f));
        }
        JFreeChart tempChart = new JFreeChart(null, plot);
        tempChart.removeLegend();
        tempChart.setBackgroundPaint(Color.white);
        return tempChart;
    }
}

