package no.uib.jsparklines;

import java.awt.Color;
import javax.swing.table.DefaultTableModel;
import no.uib.jsparklines.data.JSparklinesMultiLabel;
import no.uib.jsparklines.data.JSparklinesMultiLabelDataset;
import no.uib.jsparklines.renderers.JSparklinesMultiLabelTableCellRenderer;

/**
 * Demo of the JSparklinesMultiLabelTableCellRenderer.
 *
 * @author Harald Barsnes
 */
public class JSparklinesMultiLabelDemo extends javax.swing.JDialog {

    /**
     * Creates a new JSparklinesMultiLabelDemo.
     *
     * @param parent the parent frame
     */
    public JSparklinesMultiLabelDemo(java.awt.Frame parent) {
        super(parent, true);
        initComponents();

        int rowCounter = 1;

        // JSparklinesMultiLabelDataset with one label
        JSparklinesMultiLabelDataset labels = new JSparklinesMultiLabelDataset(new JSparklinesMultiLabel("Red", Color.red));

        ((DefaultTableModel) dataTable.getModel()).addRow(new Object[]{
                    rowCounter++, labels, "Protein A"
                });


        // JSparklinesMultiLabelDataset with two labels
        labels = new JSparklinesMultiLabelDataset(new JSparklinesMultiLabel("Red", Color.red),
                new JSparklinesMultiLabel("Green", Color.green));

        ((DefaultTableModel) dataTable.getModel()).addRow(new Object[]{
                    rowCounter++, labels, "Protein B"
                });


        // JSparklinesMultiLabelDataset with three labels
        labels = new JSparklinesMultiLabelDataset(new JSparklinesMultiLabel("Red", Color.red),
                new JSparklinesMultiLabel("Green", Color.green),
                new JSparklinesMultiLabel("Yellow", Color.yellow));

        ((DefaultTableModel) dataTable.getModel()).addRow(new Object[]{
                    rowCounter++, labels, "Protein C"
                });


        // JSparklinesMultiLabelDataset with four labels
        labels = new JSparklinesMultiLabelDataset(new JSparklinesMultiLabel("Red", Color.red),
                new JSparklinesMultiLabel("Green", Color.green),
                new JSparklinesMultiLabel("Yellow", Color.yellow),
                new JSparklinesMultiLabel("Blue", Color.blue));


        ((DefaultTableModel) dataTable.getModel()).addRow(new Object[]{
                    rowCounter++, labels, "Protein D"
                });

        // make sure that the scroll panes are see-through
        dataTableJScrollPane.getViewport().setOpaque(false);

        // set the cell renderer to JSparklinesMultiLabelTableCellRenderer
        JSparklinesMultiLabelTableCellRenderer renderer = new JSparklinesMultiLabelTableCellRenderer();
        //renderer.setCircle(true); // to display the data as a pie chart, uncomment this line
        dataTable.getColumn(" ").setCellRenderer(renderer);

        // set the min and max column with for the label column
        // note: very important to set this to the same size as the height of the rows!! 
        dataTable.getColumn(" ").setMinWidth(30);
        dataTable.getColumn(" ").setMaxWidth(30);

        dataTable.getColumn("").setMinWidth(30);
        dataTable.getColumn("").setMaxWidth(30);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        dataTableJScrollPane = new javax.swing.JScrollPane();
        dataTable = new javax.swing.JTable();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("JSparklines - Multi Label Demo");

        backgroundPanel.setBackground(new java.awt.Color(255, 255, 255));

        dataTableJScrollPane.setOpaque(false);

        dataTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "", " ", "Text"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Integer.class, java.lang.Object.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        dataTableJScrollPane.setViewportView(dataTable);

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(dataTableJScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)
                .addContainerGap())
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(dataTableJScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 278, Short.MAX_VALUE)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Main method for testing purposes.
     * 
     * @param args the command line arguments
     */
    public static void main(String args[]) {

        /* Set the Nimbus look and feel */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (Exception ex) {
            // ignore, use default look and feel
        }

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                JSparklinesMultiLabelDemo dialog = new JSparklinesMultiLabelDemo(new javax.swing.JFrame());
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JTable dataTable;
    private javax.swing.JScrollPane dataTableJScrollPane;
    // End of variables declaration//GEN-END:variables
}
