/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.data;

import java.io.Serializable;

public class Chromosome
implements Comparable<Chromosome>,
Serializable {
    static final long serialVersionUID = 2505328876343336528L;
    private String chromosomeName;
    private Integer chromosomeNumber;
    private final Integer X = 0x7FFFFFFB;
    private final Integer Y = 0x7FFFFFFC;
    private final Integer Z = 0x7FFFFFFD;
    private final Integer W = 0x7FFFFFFE;
    public static final Integer UNKNOWN = Integer.MAX_VALUE;

    public Chromosome(String chromosomeName) {
        this.chromosomeName = chromosomeName;
        if (chromosomeName == null) {
            this.chromosomeNumber = UNKNOWN;
        } else {
            try {
                this.chromosomeNumber = Integer.parseInt(chromosomeName);
            }
            catch (NumberFormatException e) {
                this.chromosomeNumber = chromosomeName.equalsIgnoreCase("X") ? this.X : (chromosomeName.equalsIgnoreCase("Y") ? this.Y : (chromosomeName.equalsIgnoreCase("Z") ? this.Z : (chromosomeName.equalsIgnoreCase("W") ? this.W : Integer.valueOf(chromosomeName.hashCode()))));
            }
        }
    }

    public String toString() {
        if (this.chromosomeName == null) {
            return "";
        }
        return this.chromosomeName;
    }

    @Override
    public int compareTo(Chromosome o) {
        if (o == null) {
            return 1;
        }
        if (this.chromosomeNumber == null) {
            return -1;
        }
        if (o.chromosomeNumber == null) {
            return 1;
        }
        return Double.compare(this.chromosomeNumber.intValue(), o.chromosomeNumber.intValue());
    }
}

