/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.data;

import java.util.ArrayList;
import no.uib.jsparklines.data.JSparklinesDataSeries;

public class JSparklinesDataset
implements Comparable<JSparklinesDataset> {
    private ArrayList<JSparklinesDataSeries> data;

    public JSparklinesDataset(ArrayList<JSparklinesDataSeries> data) {
        this.data = data;
    }

    public ArrayList<JSparklinesDataSeries> getData() {
        return this.data;
    }

    public void setData(ArrayList<JSparklinesDataSeries> data) {
        this.data = data;
    }

    public String toString() {
        if (this.data.isEmpty()) {
            return "";
        }
        String temp = "";
        temp = temp + "[" + this.data.get(0).toString() + "]";
        for (int i = 1; i < this.data.size(); ++i) {
            temp = temp + ", [" + this.data.get(i).toString() + "]";
        }
        return temp;
    }

    @Override
    public int compareTo(JSparklinesDataset o) {
        if (o == null) {
            return 1;
        }
        double sumThis = 0.0;
        for (int i = 0; i < this.getData().size(); ++i) {
            JSparklinesDataSeries series = this.getData().get(i);
            for (int j = 0; j < series.getData().size(); ++j) {
                sumThis += Math.abs(series.getData().get(j));
            }
        }
        double sumOther = 0.0;
        for (int i = 0; i < o.getData().size(); ++i) {
            JSparklinesDataSeries series = o.getData().get(i);
            for (int j = 0; j < series.getData().size(); ++j) {
                sumOther += Math.abs(series.getData().get(j));
            }
        }
        if (Double.isNaN(sumThis) && Double.isNaN(sumOther)) {
            return 0;
        }
        if (Double.isNaN(sumThis)) {
            return -1;
        }
        if (Double.isNaN(sumOther)) {
            return 1;
        }
        return Double.compare(sumThis, sumOther);
    }
}

