/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import no.uib.jsparklines.renderers.util.AreaRenderer;
import no.uib.jsparklines.renderers.util.BarChartColorRenderer;
import no.uib.jsparklines.renderers.util.ReferenceArea;
import no.uib.jsparklines.renderers.util.ReferenceLine;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JSparklinesTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private boolean showProteinSequenceReferenceLine = true;
    private double referenceLineWidth = 0.03;
    private Color referenceLineColor = Color.BLACK;
    private Color backgroundColor;
    private PlotType plotType;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private double maxValue = 0.0;
    private double minValue = 0.0;
    private PlotOrientation plotOrientation;
    private Color maxValueColor = new Color(251, 51, 51);
    private Color minValueColor = new Color(51, 51, 251);
    private Color upColor = new Color(251, 51, 51);
    private Color downColor = new Color(51, 51, 251);
    private boolean highlightMaxAndMin = false;
    private double widthOfMaxAndMinHighlight = 0.4;
    private HashMap<String, ReferenceLine> referenceLines;
    private HashMap<String, ReferenceArea> referenceAreas;
    private DecimalFormat numberFormat = new DecimalFormat("0.00");
    private int widthOfValueLabel = 40;
    private boolean showNumberAndChart = false;
    private boolean showNumbers = false;
    private int labelHorizontalAlignement = 4;
    private JLabel valueLabel;

    public JSparklinesTableCellRenderer(PlotType plotType, PlotOrientation plotOrientation) {
        this(plotType, plotOrientation, 0.0, 0.0);
    }

    public JSparklinesTableCellRenderer(PlotType plotType, PlotOrientation plotOrientation, Double maxValue) {
        this(plotType, plotOrientation, 0.0, maxValue);
    }

    public JSparklinesTableCellRenderer(PlotType plotType, PlotOrientation plotOrientation, Double minValue, Double maxValue) {
        this.plotType = plotType;
        this.plotOrientation = plotOrientation;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        this.referenceLines = new HashMap();
        this.referenceAreas = new HashMap();
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add((Component)this.chartPanel);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.numberFormat = numberFormat;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, font, horizontalAlignement, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.labelHorizontalAlignement = horizontalAlignement;
        this.valueLabel.setFont(font);
        this.numberFormat = numberFormat;
    }

    public void showNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    public void showProteinSequenceReferenceLine(boolean showProteinSequenceReferenceLine) {
        this.showProteinSequenceReferenceLine = showProteinSequenceReferenceLine;
    }

    public void showProteinSequenceReferenceLine(boolean showProteinSequenceReferenceLine, double lineWidth, Color color) {
        this.showProteinSequenceReferenceLine = showProteinSequenceReferenceLine;
        this.referenceLineWidth = lineWidth;
        this.referenceLineColor = color;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JSparklinesDataSeries sparklineDataSeries;
        JSparklinesDataSeries sparklineDataSeries2;
        int j;
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        if (this.backgroundColor != null) {
            this.setBackground(this.backgroundColor);
        } else {
            this.setBackground(c.getBackground());
        }
        if (value == null || !(value instanceof JSparklinesDataset)) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        JSparklinesDataset sparklineDataset = (JSparklinesDataset)value;
        ArrayList<Color> colors = new ArrayList<Color>();
        int dataCounter = 0;
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html>");
        if ((this.showNumberAndChart || this.showNumbers) && this.plotType == PlotType.stackedBarChartIntegerWithUpperRange) {
            this.numberFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
            double sum = 0.0;
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                JSparklinesDataSeries series = sparklineDataset.getData().get(i);
                for (j = 0; j < series.getData().size(); ++j) {
                    sum += series.getData().get(j).doubleValue();
                }
            }
            if (this.showNumbers) {
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, (int)sum, isSelected, hasFocus, row, column);
                ((JLabel)c).setHorizontalAlignment(4);
                Color bg = c.getBackground();
                c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
                return c;
            }
            this.valueLabel.setText("" + (int)sum);
            Color bg = c.getBackground();
            this.valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            if (this.labelHorizontalAlignement == 4) {
                this.valueLabel.setText(this.valueLabel.getText() + "  ");
            } else if (this.labelHorizontalAlignement == 2) {
                this.valueLabel.setText("  " + this.valueLabel.getText());
            }
            this.valueLabel.setForeground(c.getForeground());
            this.valueLabel.setHorizontalAlignment(this.labelHorizontalAlignement);
            this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
            this.valueLabel.setSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setMaximumSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setPreferredSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setVisible(true);
        } else {
            this.valueLabel.setMinimumSize(new Dimension(0, 0));
            this.valueLabel.setSize(0, 0);
            this.valueLabel.setVisible(false);
        }
        if (this.plotType == PlotType.barChart) {
            DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                sparklineDataSeries2 = sparklineDataset.getData().get(i);
                if (sparklineDataSeries2.getSeriesLabel() != null) {
                    tooltip.append("<font color=rgb(");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getRed()).append(",");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getGreen()).append(",");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getBlue()).append(")>");
                    tooltip.append(sparklineDataSeries2.getSeriesLabel()).append("<br>");
                }
                for (int j2 = 0; j2 < sparklineDataSeries2.getData().size(); ++j2) {
                    barChartDataset.addValue((Number)sparklineDataSeries2.getData().get(j2), (Comparable)((Object)"1"), (Comparable)Integer.valueOf(dataCounter++));
                    colors.add(sparklineDataSeries2.getSeriesColor());
                }
            }
            this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)barChartDataset, (PlotOrientation)this.plotOrientation, (boolean)false, (boolean)false, (boolean)false);
            CategoryPlot plot = this.chart.getCategoryPlot();
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            Iterator<String> allReferencesLines = this.referenceLines.keySet().iterator();
            while (allReferencesLines.hasNext()) {
                ReferenceLine currentReferenceLine = this.referenceLines.get(allReferencesLines.next());
                plot.addRangeMarker((Marker)new ValueMarker(currentReferenceLine.getValue(), (Paint)currentReferenceLine.getLineColor(), (Stroke)new BasicStroke(currentReferenceLine.getLineWidth())));
            }
            Iterator<String> allReferenceAreas = this.referenceAreas.keySet().iterator();
            while (allReferenceAreas.hasNext()) {
                ReferenceArea currentReferenceArea = this.referenceAreas.get(allReferenceAreas.next());
                IntervalMarker marker = new IntervalMarker(currentReferenceArea.getStart(), currentReferenceArea.getEnd(), (Paint)currentReferenceArea.getAreaColor());
                marker.setAlpha(currentReferenceArea.getAlpha());
                plot.addRangeMarker((Marker)marker);
            }
            if (this.maxValue > 0.0) {
                plot.getRangeAxis().setRange(this.minValue, this.maxValue);
            }
            plot.setDataset((CategoryDataset)barChartDataset);
            plot.getRangeAxis().setVisible(false);
            plot.getDomainAxis().setVisible(false);
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            BarChartColorRenderer renderer = new BarChartColorRenderer(colors);
            renderer.setShadowVisible(false);
            plot.setRenderer((CategoryItemRenderer)renderer);
        } else if (this.plotType == PlotType.lineChart || this.plotType == PlotType.areaChart || this.plotType == PlotType.difference) {
            Object renderer;
            if (this.plotType == PlotType.lineChart) {
                renderer = new XYLineAndShapeRenderer(true, false);
            } else if (this.plotType == PlotType.areaChart) {
                renderer = new AreaRenderer();
                ((AreaRenderer)((Object)renderer)).setOutline(true);
            } else {
                renderer = new XYDifferenceRenderer((Paint)this.downColor, (Paint)this.upColor, false);
            }
            double plotMaxValue = Double.MIN_VALUE;
            double plotMinValue = Double.MAX_VALUE;
            int indexOfMaxValue = -1;
            int indexOfMinValue = -1;
            XYSeriesCollection lineChartDataset = new XYSeriesCollection();
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                JSparklinesDataSeries sparklineDataSeries3 = sparklineDataset.getData().get(i);
                if (sparklineDataSeries3.getSeriesLabel() != null) {
                    tooltip.append("<font color=rgb(");
                    tooltip.append(sparklineDataSeries3.getSeriesColor().getRed()).append(",");
                    tooltip.append(sparklineDataSeries3.getSeriesColor().getGreen()).append(",");
                    tooltip.append(sparklineDataSeries3.getSeriesColor().getBlue()).append(")>");
                    tooltip.append(sparklineDataSeries3.getSeriesLabel()).append("<br>");
                }
                XYSeries tempSeries = new XYSeries((Comparable)Integer.valueOf(i));
                XYSeries xAxisSeries = new XYSeries((Comparable)((Object)"x-axis"));
                for (int j3 = 0; j3 < sparklineDataSeries3.getData().size(); ++j3) {
                    tempSeries.add((double)j3, (Number)sparklineDataSeries3.getData().get(j3));
                    xAxisSeries.add((double)j3, 0.0);
                    if (sparklineDataSeries3.getData().get(j3) > plotMaxValue) {
                        plotMaxValue = sparklineDataSeries3.getData().get(j3);
                        indexOfMaxValue = j3;
                    }
                    if (!(sparklineDataSeries3.getData().get(j3) < plotMinValue)) continue;
                    plotMinValue = sparklineDataSeries3.getData().get(j3);
                    indexOfMinValue = j3;
                }
                lineChartDataset.addSeries(tempSeries);
                if (this.plotType == PlotType.difference) {
                    lineChartDataset.addSeries(xAxisSeries);
                    renderer.setSeriesStroke(0, (Stroke)new BasicStroke(0.0f));
                    renderer.setSeriesStroke(1, (Stroke)new BasicStroke(0.0f));
                    continue;
                }
                if (this.plotType == PlotType.lineChart) {
                    renderer.setSeriesPaint(i, (Paint)sparklineDataSeries3.getSeriesColor());
                    renderer.setSeriesStroke(i, (Stroke)sparklineDataSeries3.getLineType());
                    continue;
                }
                renderer.setSeriesFillPaint(i, (Paint)new GradientPaint(0.0f, 0.0f, sparklineDataSeries3.getSeriesColor().brighter().brighter(), 0.0f, 0.0f, sparklineDataSeries3.getSeriesColor().darker().darker()));
                renderer.setSeriesOutlinePaint(i, (Paint)sparklineDataSeries3.getSeriesColor());
            }
            this.chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)lineChartDataset, (PlotOrientation)this.plotOrientation, (boolean)false, (boolean)false, (boolean)false);
            XYPlot plot = this.chart.getXYPlot();
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            if (this.highlightMaxAndMin) {
                plot.addDomainMarker((Marker)new IntervalMarker((double)indexOfMaxValue - this.widthOfMaxAndMinHighlight, (double)indexOfMaxValue + this.widthOfMaxAndMinHighlight, (Paint)this.maxValueColor.brighter().brighter().brighter(), (Stroke)new BasicStroke(1.0f), (Paint)Color.lightGray, (Stroke)new BasicStroke(0.1f), 0.5f), Layer.BACKGROUND);
                plot.addDomainMarker((Marker)new IntervalMarker((double)indexOfMinValue - this.widthOfMaxAndMinHighlight, (double)indexOfMinValue + this.widthOfMaxAndMinHighlight, (Paint)this.minValueColor.brighter().brighter().brighter(), (Stroke)new BasicStroke(1.0f), (Paint)Color.lightGray, (Stroke)new BasicStroke(0.1f), 0.5f), Layer.BACKGROUND);
            }
            Iterator<String> allReferencesLines = this.referenceLines.keySet().iterator();
            while (allReferencesLines.hasNext()) {
                ReferenceLine currentReferenceLine = this.referenceLines.get(allReferencesLines.next());
                plot.addRangeMarker((Marker)new ValueMarker(currentReferenceLine.getValue(), (Paint)currentReferenceLine.getLineColor(), (Stroke)new BasicStroke(currentReferenceLine.getLineWidth())));
            }
            Iterator<String> allReferenceAreas = this.referenceAreas.keySet().iterator();
            while (allReferenceAreas.hasNext()) {
                ReferenceArea currentReferenceArea = this.referenceAreas.get(allReferenceAreas.next());
                IntervalMarker marker = new IntervalMarker(currentReferenceArea.getStart(), currentReferenceArea.getEnd(), (Paint)currentReferenceArea.getAreaColor());
                marker.setAlpha(currentReferenceArea.getAlpha());
                plot.addRangeMarker((Marker)marker);
            }
            if (this.maxValue > 0.0) {
                plot.getRangeAxis().setRange(this.minValue, this.maxValue);
            }
            plot.setDataset((XYDataset)lineChartDataset);
            plot.getRangeAxis().setVisible(false);
            plot.getDomainAxis().setVisible(false);
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            plot.setRenderer((XYItemRenderer)renderer);
        } else if (this.plotType == PlotType.pieChart) {
            DefaultPieDataset pieDataset = new DefaultPieDataset();
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                sparklineDataSeries2 = sparklineDataset.getData().get(i);
                if (sparklineDataSeries2.getSeriesLabel() != null) {
                    tooltip.append("<font color=rgb(");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getRed()).append(",");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getGreen()).append(",");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getBlue()).append(")>");
                    tooltip.append(sparklineDataSeries2.getSeriesLabel()).append("<br>");
                }
                double sumOfValues = 0.0;
                for (int j4 = 0; j4 < sparklineDataSeries2.getData().size(); ++j4) {
                    sumOfValues += sparklineDataSeries2.getData().get(j4).doubleValue();
                }
                pieDataset.setValue((Comparable)((Object)sparklineDataSeries2.getSeriesLabel()), sumOfValues);
            }
            this.chart = ChartFactory.createPieChart(null, (PieDataset)pieDataset, (boolean)false, (boolean)false, (boolean)false);
            PiePlot piePlot = (PiePlot)this.chart.getPlot();
            piePlot.setCircular(true);
            piePlot.setLabelGenerator(null);
            piePlot.setShadowXOffset(0.0);
            piePlot.setShadowYOffset(0.0);
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                piePlot.setSectionPaint((Comparable)((Object)sparklineDataset.getData().get(i).getSeriesLabel()), (Paint)sparklineDataset.getData().get(i).getSeriesColor());
            }
        } else if (this.plotType == PlotType.stackedBarChart || this.plotType == PlotType.stackedPercentBarChart || this.plotType == PlotType.stackedBarChartIntegerWithUpperRange || this.plotType == PlotType.proteinSequence) {
            DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
            StackedBarRenderer renderer = new StackedBarRenderer();
            renderer.setShadowVisible(false);
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                sparklineDataSeries = sparklineDataset.getData().get(i);
                if (this.plotType != PlotType.stackedBarChartIntegerWithUpperRange && sparklineDataSeries.getSeriesLabel() != null) {
                    tooltip.append("<font color=rgb(");
                    tooltip.append(sparklineDataSeries.getSeriesColor().getRed()).append(",");
                    tooltip.append(sparklineDataSeries.getSeriesColor().getGreen()).append(",");
                    tooltip.append(sparklineDataSeries.getSeriesColor().getBlue()).append(")>");
                    tooltip.append(sparklineDataSeries.getSeriesLabel()).append("<br>");
                }
                for (j = 0; j < sparklineDataSeries.getData().size(); ++j) {
                    barChartDataset.addValue((Number)sparklineDataSeries.getData().get(j), (Comparable)((Object)("" + i)), (Comparable)((Object)("" + j)));
                    renderer.setSeriesPaint(i, (Paint)sparklineDataSeries.getSeriesColor());
                    if (sparklineDataSeries.getSeriesLabel() == null || this.plotType != PlotType.stackedBarChartIntegerWithUpperRange) continue;
                    tooltip.append(sparklineDataSeries.getData().get(j).intValue());
                    if (i >= sparklineDataset.getData().size() - 1) continue;
                    tooltip.append(" / ");
                }
            }
            this.chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)barChartDataset, (PlotOrientation)this.plotOrientation, (boolean)false, (boolean)false, (boolean)false);
            CategoryPlot plot = this.chart.getCategoryPlot();
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            plot.getRangeAxis().setUpperMargin(0.0);
            plot.getRangeAxis().setLowerMargin(0.0);
            Iterator<String> allReferencesLines = this.referenceLines.keySet().iterator();
            while (allReferencesLines.hasNext()) {
                ReferenceLine currentReferenceLine = this.referenceLines.get(allReferencesLines.next());
                plot.addRangeMarker((Marker)new ValueMarker(currentReferenceLine.getValue(), (Paint)currentReferenceLine.getLineColor(), (Stroke)new BasicStroke(currentReferenceLine.getLineWidth())));
            }
            Iterator<String> allReferenceAreas = this.referenceAreas.keySet().iterator();
            while (allReferenceAreas.hasNext()) {
                ReferenceArea currentReferenceArea = this.referenceAreas.get(allReferenceAreas.next());
                IntervalMarker marker = new IntervalMarker(currentReferenceArea.getStart(), currentReferenceArea.getEnd(), (Paint)currentReferenceArea.getAreaColor());
                marker.setAlpha(currentReferenceArea.getAlpha());
                plot.addRangeMarker((Marker)marker);
            }
            if (this.plotType == PlotType.stackedPercentBarChart || this.plotType == PlotType.proteinSequence) {
                renderer.setRenderAsPercentages(true);
            } else if (this.plotType == PlotType.stackedBarChartIntegerWithUpperRange) {
                plot.getRangeAxis().setRange(0.0, this.maxValue);
            } else if (this.maxValue > 0.0) {
                plot.getRangeAxis().setRange(this.minValue * (double)sparklineDataset.getData().size(), this.maxValue * (double)sparklineDataset.getData().size());
            }
            plot.setDataset((CategoryDataset)barChartDataset);
            plot.getRangeAxis().setVisible(false);
            plot.getDomainAxis().setVisible(false);
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            if (this.plotType == PlotType.proteinSequence && this.showProteinSequenceReferenceLine) {
                DefaultCategoryDataset referenceLineDataset = new DefaultCategoryDataset();
                referenceLineDataset.addValue(1.0, (Comparable)((Object)"A"), (Comparable)((Object)"B"));
                plot.setDataset(1, (CategoryDataset)referenceLineDataset);
                LayeredBarRenderer referenceLineRenderer = new LayeredBarRenderer();
                referenceLineRenderer.setSeriesBarWidth(0, this.referenceLineWidth);
                referenceLineRenderer.setSeriesFillPaint(0, (Paint)this.referenceLineColor);
                referenceLineRenderer.setSeriesPaint(0, (Paint)this.referenceLineColor);
                plot.setRenderer(1, (CategoryItemRenderer)referenceLineRenderer);
            }
            plot.setRenderer(0, (CategoryItemRenderer)renderer);
        } else if (this.plotType == PlotType.boxPlot) {
            DefaultBoxAndWhiskerCategoryDataset boxPlotDataset = new DefaultBoxAndWhiskerCategoryDataset();
            BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                sparklineDataSeries = sparklineDataset.getData().get(i);
                ArrayList<Double> listValues = new ArrayList<Double>();
                if (sparklineDataSeries.getSeriesLabel() != null) {
                    tooltip.append("<font color=rgb(");
                    tooltip.append(sparklineDataSeries.getSeriesColor().getRed()).append(",");
                    tooltip.append(sparklineDataSeries.getSeriesColor().getGreen()).append(",");
                    tooltip.append(sparklineDataSeries.getSeriesColor().getBlue()).append(")>");
                    tooltip.append(sparklineDataSeries.getSeriesLabel()).append("<br>");
                }
                for (int j5 = 0; j5 < sparklineDataSeries.getData().size(); ++j5) {
                    listValues.add(sparklineDataSeries.getData().get(j5));
                    renderer.setSeriesPaint(i, (Paint)sparklineDataSeries.getSeriesColor());
                }
                boxPlotDataset.add(listValues, (Comparable)((Object)sparklineDataSeries.getSeriesLabel()), (Comparable)((Object)"1"));
            }
            renderer.setMeanVisible(false);
            renderer.setMaximumBarWidth(0.5);
            CategoryPlot plot = new CategoryPlot((CategoryDataset)boxPlotDataset, new CategoryAxis(), (ValueAxis)new NumberAxis(), (CategoryItemRenderer)renderer);
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            plot.getRangeAxis().setVisible(false);
            plot.getDomainAxis().setVisible(false);
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            plot.setOrientation(this.plotOrientation);
            this.chart = new JFreeChart(null, null, (Plot)plot, false);
        } else if (this.plotType == PlotType.upDownChart) {
            DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
            for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
                sparklineDataSeries2 = sparklineDataset.getData().get(i);
                if (sparklineDataSeries2.getSeriesLabel() != null) {
                    tooltip.append("<font color=rgb(");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getRed()).append(",");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getGreen()).append(",");
                    tooltip.append(sparklineDataSeries2.getSeriesColor().getBlue()).append(")>");
                    tooltip.append(sparklineDataSeries2.getSeriesLabel()).append("<br>");
                }
                for (int j6 = 0; j6 < sparklineDataSeries2.getData().size(); ++j6) {
                    if (sparklineDataSeries2.getData().get(j6) > 0.0) {
                        barChartDataset.addValue(1.0, (Comparable)((Object)"1"), (Comparable)Integer.valueOf(dataCounter++));
                        colors.add(this.upColor);
                        continue;
                    }
                    barChartDataset.addValue(-1.0, (Comparable)((Object)"1"), (Comparable)Integer.valueOf(dataCounter++));
                    colors.add(this.downColor);
                }
            }
            this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)barChartDataset, (PlotOrientation)this.plotOrientation, (boolean)false, (boolean)false, (boolean)false);
            CategoryPlot plot = this.chart.getCategoryPlot();
            plot.getRangeAxis().setRange(-1.0, 1.0);
            plot.setDataset((CategoryDataset)barChartDataset);
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            plot.getRangeAxis().setVisible(false);
            plot.getDomainAxis().setVisible(false);
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            BarChartColorRenderer renderer = new BarChartColorRenderer(colors);
            renderer.setShadowVisible(false);
            plot.setRenderer((CategoryItemRenderer)renderer);
        }
        if (!tooltip.toString().equalsIgnoreCase("<html>")) {
            this.setToolTipText(tooltip.append("</html>").toString());
        } else {
            this.setToolTipText(null);
        }
        this.chart.getPlot().setOutlineVisible(false);
        if (this.backgroundColor != null) {
            this.chart.getPlot().setBackgroundPaint((Paint)this.backgroundColor);
            this.chart.setBackgroundPaint((Paint)this.backgroundColor);
        } else {
            this.chart.getPlot().setBackgroundPaint((Paint)c.getBackground());
            this.chart.setBackgroundPaint((Paint)c.getBackground());
        }
        this.chartPanel = new ChartPanel(this.chart);
        if (this.backgroundColor != null) {
            this.chartPanel.setBackground(this.backgroundColor);
        } else {
            this.chartPanel.setBackground(c.getBackground());
        }
        this.remove(1);
        this.add((Component)this.chartPanel);
        return this;
    }

    public void addReferenceLine(String label, double value, float lineWidth, Color lineColor) {
        this.referenceLines.put(label, new ReferenceLine(label, value, lineWidth, lineColor));
    }

    public void addReferenceLine(ReferenceLine referenceLine) {
        this.referenceLines.put(referenceLine.getLabel(), referenceLine);
    }

    public void removeReferenceLine(String label) {
        this.referenceLines.remove(label);
    }

    public void removeAllReferenceLines() {
        this.referenceLines = new HashMap();
    }

    public HashMap<String, ReferenceLine> getAllReferenceLines() {
        return this.referenceLines;
    }

    public void addReferenceArea(String label, double start, double end, Color areaColor, float alpha) {
        this.referenceAreas.put(label, new ReferenceArea(label, start, end, areaColor, alpha));
    }

    public void addReferenceArea(ReferenceArea referenceArea) {
        this.referenceAreas.put(referenceArea.getLabel(), referenceArea);
    }

    public void removeReferenceArea(String label) {
        this.referenceAreas.remove(label);
    }

    public void removeAllReferenceAreas() {
        this.referenceAreas = new HashMap();
    }

    public HashMap<String, ReferenceArea> getAllReferenceAreas() {
        return this.referenceAreas;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setPlotType(PlotType plotType) {
        this.plotType = plotType;
    }

    public Color getMaxValueColor() {
        return this.maxValueColor;
    }

    public void setMaxValueColor(Color maxValueColor) {
        this.maxValueColor = maxValueColor;
    }

    public Color getMinValueColor() {
        return this.minValueColor;
    }

    public void setMinValueColor(Color minValueColor) {
        this.minValueColor = minValueColor;
    }

    public Color getUpColor() {
        return this.upColor;
    }

    public void setUpColor(Color upColor) {
        this.upColor = upColor;
    }

    public Color getDownColor() {
        return this.downColor;
    }

    public void setDownColor(Color downColor) {
        this.downColor = downColor;
    }

    public PlotOrientation getPlotOrientation() {
        return this.plotOrientation;
    }

    public void setPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    static {
        BarRenderer.setDefaultBarPainter((BarPainter)new StandardBarPainter());
    }

    public static enum PlotType {
        barChart,
        lineChart,
        pieChart,
        stackedBarChart,
        stackedPercentBarChart,
        areaChart,
        boxPlot,
        upDownChart,
        proteinSequence,
        difference,
        stackedBarChartIntegerWithUpperRange;

    }
}

