/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.ArrrayListDataPoints;
import no.uib.jsparklines.renderers.util.ReferenceArea;
import no.uib.jsparklines.renderers.util.ReferenceLine;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.DefaultCategoryDataset;

public class JSparklinesArrayListBarChartTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private ValueDisplayType currentValueDisplayType;
    private Color backgroundColor;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private double maxValue = 0.0;
    private PlotOrientation plotOrientation;
    private ArrayList<Color> colors;
    private Color fillColor = null;
    private HashMap<String, ReferenceLine> referenceLines;
    private HashMap<String, ReferenceArea> referenceAreas;
    private DecimalFormat numberFormat = new DecimalFormat("0.00");
    private int widthOfValueLabel = 40;
    private boolean showNumberAndChart = false;
    private boolean showNumbers = false;
    private int labelHorizontalAlignement = 4;
    private JLabel valueLabel;

    public JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, ArrayList<Color> colors, ValueDisplayType valueDisplayType) {
        this(plotOrientation, maxValue, colors, null, valueDisplayType);
    }

    public JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, ArrayList<Color> colors, Color fillColor, ValueDisplayType valueDisplayType) {
        this.plotOrientation = plotOrientation;
        this.maxValue = maxValue;
        this.colors = colors;
        this.fillColor = fillColor;
        this.currentValueDisplayType = valueDisplayType;
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        this.referenceLines = new HashMap();
        this.referenceAreas = new HashMap();
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, dataset, plotOrientation, false, false, false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add(this.chartPanel);
    }

    public JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, ArrayList<Color> colors, boolean showFirstNumber) {
        this(plotOrientation, maxValue, colors, null, showFirstNumber);
    }

    public JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, ArrayList<Color> colors, Color fillColor, boolean showFirstNumber) {
        this.plotOrientation = plotOrientation;
        this.maxValue = maxValue;
        this.colors = colors;
        this.fillColor = fillColor;
        this.currentValueDisplayType = showFirstNumber ? ValueDisplayType.firstNumberOnly : ValueDisplayType.sumOfNumbers;
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        this.referenceLines = new HashMap();
        this.referenceAreas = new HashMap();
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, dataset, plotOrientation, false, false, false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add(this.chartPanel);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.numberFormat = numberFormat;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, font, horizontalAlignement, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.labelHorizontalAlignement = horizontalAlignement;
        this.valueLabel.setFont(font);
        this.numberFormat = numberFormat;
    }

    public void showNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    public void showFirstNumber(boolean showFirstNumber) {
        this.currentValueDisplayType = showFirstNumber ? ValueDisplayType.firstNumberOnly : ValueDisplayType.sumOfNumbers;
    }

    public void setValueDisplayType(ValueDisplayType valueDisplayType) {
        this.currentValueDisplayType = valueDisplayType;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        double fillValue;
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        if (this.backgroundColor != null) {
            this.setBackground(this.backgroundColor);
        } else {
            this.setBackground(c.getBackground());
        }
        if (value == null) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof String) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (!(value instanceof ArrrayListDataPoints)) {
            return c;
        }
        ArrrayListDataPoints values = (ArrrayListDataPoints)value;
        double sumValues = values.getSum();
        if (this.showNumberAndChart || this.showNumbers) {
            this.numberFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
            double tempValue = sumValues;
            if (this.currentValueDisplayType == ValueDisplayType.firstNumberOnly) {
                if (!values.getData().isEmpty()) {
                    tempValue = values.getData().get(0);
                }
            } else if (this.currentValueDisplayType == ValueDisplayType.sumOfNumbers) {
                tempValue = sumValues;
            } else if (this.currentValueDisplayType == ValueDisplayType.sumExceptLastNumber) {
                tempValue = sumValues - values.getData().get(values.getData().size() - 1);
            }
            if (this.showNumbers) {
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, this.numberFormat.format(tempValue), isSelected, hasFocus, row, column);
                ((JLabel)c).setHorizontalAlignment(4);
                Color bg = c.getBackground();
                c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
                return c;
            }
            this.valueLabel.setText(this.numberFormat.format(tempValue));
            Color bg = c.getBackground();
            this.valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            if (this.labelHorizontalAlignement == 4) {
                this.valueLabel.setText(this.valueLabel.getText() + "  ");
            } else if (this.labelHorizontalAlignement == 2) {
                this.valueLabel.setText("  " + this.valueLabel.getText());
            }
            this.valueLabel.setForeground(c.getForeground());
            this.valueLabel.setHorizontalAlignment(this.labelHorizontalAlignement);
            this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
            this.valueLabel.setSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setMaximumSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setPreferredSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setVisible(true);
        } else {
            this.valueLabel.setMinimumSize(new Dimension(0, 0));
            this.valueLabel.setSize(0, 0);
            this.valueLabel.setVisible(false);
        }
        DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        String tooltip = "";
        for (int i = 0; i < values.getData().size(); ++i) {
            barChartDataset.addValue(values.getData().get(i), (Comparable)((Object)("" + i)), (Comparable)((Object)"0"));
            renderer.setSeriesPaint(i, this.colors.get(i));
            tooltip = tooltip + this.numberFormat.format(values.getData().get(i));
            if (i >= values.getData().size() - 1) continue;
            tooltip = tooltip + " / ";
        }
        if (this.fillColor != null && (fillValue = this.maxValue - sumValues) > 0.0) {
            barChartDataset.addValue(fillValue, (Comparable)((Object)("" + values.getData().size())), (Comparable)((Object)"0"));
            renderer.setSeriesPaint(values.getData().size(), this.fillColor);
        }
        this.chart = ChartFactory.createStackedBarChart(null, null, null, barChartDataset, this.plotOrientation, false, false, false);
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getRangeAxis().setUpperMargin(0.0);
        plot.getRangeAxis().setLowerMargin(0.0);
        Iterator<String> allReferencesLines = this.referenceLines.keySet().iterator();
        while (allReferencesLines.hasNext()) {
            ReferenceLine currentReferenceLine = this.referenceLines.get(allReferencesLines.next());
            plot.addRangeMarker(new ValueMarker(currentReferenceLine.getValue(), currentReferenceLine.getLineColor(), new BasicStroke(currentReferenceLine.getLineWidth())));
        }
        Iterator<String> allReferenceAreas = this.referenceAreas.keySet().iterator();
        while (allReferenceAreas.hasNext()) {
            ReferenceArea currentReferenceArea = this.referenceAreas.get(allReferenceAreas.next());
            IntervalMarker marker = new IntervalMarker(currentReferenceArea.getStart(), currentReferenceArea.getEnd(), currentReferenceArea.getAreaColor());
            marker.setAlpha(currentReferenceArea.getAlpha());
            plot.addRangeMarker(marker);
        }
        plot.getRangeAxis().setRange(0.0, this.maxValue);
        plot.setDataset(barChartDataset);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainGridlinesVisible(false);
        plot.setRenderer(0, renderer);
        this.setToolTipText(tooltip);
        this.chart.getPlot().setOutlineVisible(false);
        if (this.backgroundColor != null) {
            this.chart.getPlot().setBackgroundPaint(this.backgroundColor);
            this.chart.setBackgroundPaint(this.backgroundColor);
        } else {
            this.chart.getPlot().setBackgroundPaint(c.getBackground());
            this.chart.setBackgroundPaint(c.getBackground());
        }
        this.chartPanel = new ChartPanel(this.chart);
        if (this.backgroundColor != null) {
            this.chartPanel.setBackground(this.backgroundColor);
        } else {
            this.chartPanel.setBackground(c.getBackground());
        }
        this.remove(1);
        this.add(this.chartPanel);
        return this;
    }

    public void addReferenceLine(String label, double value, float lineWidth, Color lineColor) {
        this.referenceLines.put(label, new ReferenceLine(label, value, lineWidth, lineColor));
    }

    public void addReferenceLine(ReferenceLine referenceLine) {
        this.referenceLines.put(referenceLine.getLabel(), referenceLine);
    }

    public void removeReferenceLine(String label) {
        this.referenceLines.remove(label);
    }

    public void removeAllReferenceLines() {
        this.referenceLines = new HashMap();
    }

    public HashMap<String, ReferenceLine> getAllReferenceLines() {
        return this.referenceLines;
    }

    public void addReferenceArea(String label, double start, double end, Color areaColor, float alpha) {
        this.referenceAreas.put(label, new ReferenceArea(label, start, end, areaColor, alpha));
    }

    public void addReferenceArea(ReferenceArea referenceArea) {
        this.referenceAreas.put(referenceArea.getLabel(), referenceArea);
    }

    public void removeReferenceArea(String label) {
        this.referenceAreas.remove(label);
    }

    public void removeAllReferenceAreas() {
        this.referenceAreas = new HashMap();
    }

    public HashMap<String, ReferenceArea> getAllReferenceAreas() {
        return this.referenceAreas;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public ArrayList<Color> getColors() {
        return this.colors;
    }

    public void setColors(ArrayList<Color> colors) {
        this.colors = colors;
    }

    public PlotOrientation getPlotOrientation() {
        return this.plotOrientation;
    }

    public void setPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    static {
        BarRenderer.setDefaultBarPainter(new StandardBarPainter());
    }

    public static enum ValueDisplayType {
        firstNumberOnly,
        sumOfNumbers,
        sumExceptLastNumber;

    }
}

