/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.DefaultCategoryDataset;

public class JSparklinesHeatMapTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private Color backgroundColor;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private double maxValue;
    private GradientColorCoding.ColorGradient currentColorGradient = GradientColorCoding.ColorGradient.RedBlackBlue;
    private boolean positiveColorGradient = false;

    public JSparklinesHeatMapTableCellRenderer(GradientColorCoding.ColorGradient currentColorGradient, double maxValue) {
        this.currentColorGradient = currentColorGradient;
        this.maxValue = maxValue;
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, dataset, PlotOrientation.VERTICAL, false, false, false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.chartPanel);
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setGradientColoring(GradientColorCoding.ColorGradient colorGradient, boolean positiveColorGradient, Color plotBackgroundColor) {
        this.positiveColorGradient = positiveColorGradient;
        if (plotBackgroundColor != null) {
            this.backgroundColor = plotBackgroundColor;
        }
        this.currentColorGradient = colorGradient;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        if (this.backgroundColor != null) {
            this.setBackground(this.backgroundColor);
        } else {
            this.setBackground(c.getBackground());
        }
        if (value == null || !(value instanceof JSparklinesDataSeries)) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        JSparklinesDataSeries dataSeries = (JSparklinesDataSeries)value;
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html>");
        DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        for (int i = 0; i < dataSeries.getData().size(); ++i) {
            barChartDataset.addValue(1.0, (Comparable)((Object)("" + i)), (Comparable)((Object)("" + i)));
            Color currentColor = GradientColorCoding.findGradientColor(dataSeries.getData().get(i), -this.maxValue, this.maxValue, this.currentColorGradient, this.positiveColorGradient);
            renderer.setSeriesPaint(i, currentColor);
        }
        this.chart = ChartFactory.createStackedBarChart(null, null, null, barChartDataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getRangeAxis().setUpperMargin(0.0);
        plot.getRangeAxis().setLowerMargin(0.0);
        plot.setDataset(barChartDataset);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainGridlinesVisible(false);
        plot.setRenderer(0, renderer);
        if (!tooltip.toString().equalsIgnoreCase("<html>")) {
            this.setToolTipText(tooltip.append("</html>").toString());
        } else {
            this.setToolTipText(null);
        }
        this.chart.getPlot().setOutlineVisible(false);
        if (this.backgroundColor != null) {
            this.chart.getPlot().setBackgroundPaint(this.backgroundColor);
            this.chart.setBackgroundPaint(this.backgroundColor);
        } else {
            this.chart.getPlot().setBackgroundPaint(c.getBackground());
            this.chart.setBackgroundPaint(c.getBackground());
        }
        this.chartPanel = new ChartPanel(this.chart);
        if (this.backgroundColor != null) {
            this.chartPanel.setBackground(this.backgroundColor);
        } else {
            this.chartPanel.setBackground(c.getBackground());
        }
        this.removeAll();
        this.add(this.chartPanel);
        return this;
    }

    static {
        BarRenderer.setDefaultBarPainter(new StandardBarPainter());
    }
}

