/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.data;

import java.io.Serializable;

public class Chromosome
implements Comparable<Chromosome>,
Serializable {
    static final long serialVersionUID = 2505328876343336528L;
    private Integer chromosomeNumber;
    private final Integer X = 0x7FFFFFFB;
    private final Integer Y = 0x7FFFFFFC;
    private final Integer Z = 0x7FFFFFFD;
    private final Integer W = 0x7FFFFFFE;
    private final Integer UNKNOWN = Integer.MAX_VALUE;

    public Chromosome(String chromosomeNumber) {
        if (chromosomeNumber == null) {
            this.chromosomeNumber = this.UNKNOWN;
        } else {
            try {
                this.chromosomeNumber = Integer.parseInt(chromosomeNumber);
            }
            catch (NumberFormatException e) {
                if (chromosomeNumber.equalsIgnoreCase("X")) {
                    this.chromosomeNumber = this.X;
                }
                if (chromosomeNumber.equalsIgnoreCase("Y")) {
                    this.chromosomeNumber = this.Y;
                }
                if (chromosomeNumber.equalsIgnoreCase("Z")) {
                    this.chromosomeNumber = this.Z;
                }
                if (chromosomeNumber.equalsIgnoreCase("W")) {
                    this.chromosomeNumber = this.W;
                }
                throw new IllegalArgumentException(chromosomeNumber + " has to be a positive integer or X, Y, Z or W.");
            }
        }
    }

    public String toString() {
        if (this.chromosomeNumber.intValue() == this.X.intValue()) {
            return "X";
        }
        if (this.chromosomeNumber.intValue() == this.Y.intValue()) {
            return "Y";
        }
        if (this.chromosomeNumber.intValue() == this.Z.intValue()) {
            return "Z";
        }
        if (this.chromosomeNumber.intValue() == this.W.intValue()) {
            return "W";
        }
        if (this.chromosomeNumber.intValue() == this.UNKNOWN.intValue()) {
            return "";
        }
        return "" + this.chromosomeNumber;
    }

    @Override
    public int compareTo(Chromosome o) {
        if (o == null) {
            return 1;
        }
        if (this.chromosomeNumber == null) {
            return -1;
        }
        if (o.chromosomeNumber == null) {
            return 1;
        }
        return Double.compare(this.chromosomeNumber.intValue(), o.chromosomeNumber.intValue());
    }
}

